/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.connector.file.src.AbstractFileSource;
import org.apache.flink.connector.file.src.ContinuousEnumerationSettings;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.PendingSplitsCheckpoint;
import org.apache.flink.connector.file.src.assigners.FileSplitAssigner;
import org.apache.flink.connector.file.src.assigners.SimpleSplitAssigner;
import org.apache.flink.connector.file.src.enumerate.FileEnumerator;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connectors.hive.ContinuousHivePendingSplitsCheckpoint;
import org.apache.flink.connectors.hive.ContinuousHivePendingSplitsCheckpointSerializer;
import org.apache.flink.connectors.hive.ContinuousHiveSplitEnumerator;
import org.apache.flink.connectors.hive.HiveSourceFileEnumerator;
import org.apache.flink.connectors.hive.HiveSourceSplitSerializer;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.connectors.hive.HiveTableSource;
import org.apache.flink.connectors.hive.JobConfWrapper;
import org.apache.flink.connectors.hive.read.HiveBulkFormatAdapter;
import org.apache.flink.connectors.hive.read.HiveSourceSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.filesystem.ContinuousPartitionFetcher;
import org.apache.flink.table.filesystem.LimitableBulkFormat;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.mapred.JobConf;

public class HiveSource
extends AbstractFileSource<RowData, HiveSourceSplit>
implements ResultTypeQueryable<RowData> {
    private static final long serialVersionUID = 1L;
    private final JobConfWrapper jobConfWrapper;
    private final List<String> partitionKeys;
    private final ContinuousPartitionFetcher<Partition, ?> fetcher;
    private final HiveTableSource.HiveContinuousPartitionFetcherContext<?> fetcherContext;
    private final ObjectPath tablePath;

    HiveSource(Path[] inputPaths, FileEnumerator.Provider fileEnumerator, FileSplitAssigner.Provider splitAssigner, BulkFormat<RowData, HiveSourceSplit> readerFormat, @Nullable ContinuousEnumerationSettings continuousEnumerationSettings, JobConf jobConf, ObjectPath tablePath, List<String> partitionKeys, @Nullable ContinuousPartitionFetcher<Partition, ?> fetcher, @Nullable HiveTableSource.HiveContinuousPartitionFetcherContext<?> fetcherContext) {
        super(inputPaths, fileEnumerator, splitAssigner, readerFormat, continuousEnumerationSettings);
        this.jobConfWrapper = new JobConfWrapper(jobConf);
        this.tablePath = tablePath;
        this.partitionKeys = partitionKeys;
        this.fetcher = fetcher;
        this.fetcherContext = fetcherContext;
    }

    public SimpleVersionedSerializer<HiveSourceSplit> getSplitSerializer() {
        return HiveSourceSplitSerializer.INSTANCE;
    }

    public SimpleVersionedSerializer<PendingSplitsCheckpoint<HiveSourceSplit>> getEnumeratorCheckpointSerializer() {
        if (this.continuousPartitionedEnumerator()) {
            return new ContinuousHivePendingSplitsCheckpointSerializer(this.getSplitSerializer());
        }
        return super.getEnumeratorCheckpointSerializer();
    }

    public SplitEnumerator<HiveSourceSplit, PendingSplitsCheckpoint<HiveSourceSplit>> createEnumerator(SplitEnumeratorContext<HiveSourceSplit> enumContext) {
        if (this.continuousPartitionedEnumerator()) {
            return this.createContinuousSplitEnumerator(enumContext, (Comparable<?>)this.fetcherContext.getConsumeStartOffset(), (Collection<List<String>>)Collections.emptyList(), (Collection<HiveSourceSplit>)Collections.emptyList());
        }
        return super.createEnumerator(enumContext);
    }

    public SplitEnumerator<HiveSourceSplit, PendingSplitsCheckpoint<HiveSourceSplit>> restoreEnumerator(SplitEnumeratorContext<HiveSourceSplit> enumContext, PendingSplitsCheckpoint<HiveSourceSplit> checkpoint) {
        if (this.continuousPartitionedEnumerator()) {
            Preconditions.checkState((boolean)(checkpoint instanceof ContinuousHivePendingSplitsCheckpoint), (String)"Illegal type of splits checkpoint %s for streaming read partitioned table", (Object[])new Object[]{checkpoint.getClass().getName()});
            ContinuousHivePendingSplitsCheckpoint hiveCheckpoint = (ContinuousHivePendingSplitsCheckpoint)checkpoint;
            return this.createContinuousSplitEnumerator(enumContext, hiveCheckpoint.getCurrentReadOffset(), hiveCheckpoint.getSeenPartitionsSinceOffset(), hiveCheckpoint.getSplits());
        }
        return super.restoreEnumerator(enumContext, checkpoint);
    }

    private boolean continuousPartitionedEnumerator() {
        return this.getBoundedness() == Boundedness.CONTINUOUS_UNBOUNDED && !this.partitionKeys.isEmpty();
    }

    private SplitEnumerator<HiveSourceSplit, PendingSplitsCheckpoint<HiveSourceSplit>> createContinuousSplitEnumerator(SplitEnumeratorContext<HiveSourceSplit> enumContext, Comparable<?> currentReadOffset, Collection<List<String>> seenPartitions, Collection<HiveSourceSplit> splits) {
        return new ContinuousHiveSplitEnumerator(enumContext, currentReadOffset, seenPartitions, this.getAssignerFactory().create(new ArrayList<HiveSourceSplit>(splits)), this.getContinuousEnumerationSettings().getDiscoveryInterval().toMillis(), this.jobConfWrapper.conf(), this.tablePath, this.fetcher, this.fetcherContext);
    }

    public static class HiveSourceBuilder
    extends AbstractFileSource.AbstractFileSourceBuilder<RowData, HiveSourceSplit, HiveSourceBuilder> {
        private final JobConf jobConf;
        private final ObjectPath tablePath;
        private final List<String> partitionKeys;
        private ContinuousPartitionFetcher<Partition, ?> fetcher = null;
        private HiveTableSource.HiveContinuousPartitionFetcherContext<?> fetcherContext = null;

        HiveSourceBuilder(JobConf jobConf, ObjectPath tablePath, CatalogTable catalogTable, List<HiveTablePartition> partitions, @Nullable Long limit, String hiveVersion, boolean useMapRedReader, RowType producedRowType) {
            super(new Path[1], HiveSourceBuilder.createBulkFormat(new JobConf((Configuration)jobConf), catalogTable, hiveVersion, producedRowType, useMapRedReader, limit), (FileEnumerator.Provider)new HiveSourceFileEnumerator.Provider(partitions, new JobConfWrapper(jobConf)), null);
            this.jobConf = jobConf;
            this.tablePath = tablePath;
            this.partitionKeys = catalogTable.getPartitionKeys();
        }

        public HiveSource build() {
            FileSplitAssigner.Provider & Serializable splitAssigner = this.continuousSourceSettings == null || this.partitionKeys.isEmpty() ? FileSource.DEFAULT_SPLIT_ASSIGNER : SimpleSplitAssigner::new;
            return new HiveSource(this.inputPaths, this.fileEnumerator, splitAssigner, (BulkFormat<RowData, HiveSourceSplit>)this.readerFormat, this.continuousSourceSettings, this.jobConf, this.tablePath, this.partitionKeys, this.fetcher, this.fetcherContext);
        }

        public HiveSourceBuilder setFetcher(ContinuousPartitionFetcher<Partition, ?> fetcher) {
            this.fetcher = fetcher;
            return this;
        }

        public HiveSourceBuilder setFetcherContext(HiveTableSource.HiveContinuousPartitionFetcherContext<?> fetcherContext) {
            this.fetcherContext = fetcherContext;
            return this;
        }

        private static BulkFormat<RowData, HiveSourceSplit> createBulkFormat(JobConf jobConf, CatalogTable catalogTable, String hiveVersion, RowType producedRowType, boolean useMapRedReader, Long limit) {
            Preconditions.checkNotNull((Object)catalogTable, (String)"catalogTable can not be null.");
            return LimitableBulkFormat.create((BulkFormat)new HiveBulkFormatAdapter(new JobConfWrapper(jobConf), catalogTable.getPartitionKeys(), catalogTable.getSchema().getFieldNames(), catalogTable.getSchema().getFieldDataTypes(), hiveVersion, producedRowType, useMapRedReader), (Long)limit);
        }
    }
}

