/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.gcp.pubsub;

import com.google.auth.Credentials;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.SubscriberGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.time.Duration;
import org.apache.flink.streaming.connectors.gcp.pubsub.BlockingGrpcPubSubSubscriber;
import org.apache.flink.streaming.connectors.gcp.pubsub.common.PubSubSubscriber;
import org.apache.flink.streaming.connectors.gcp.pubsub.common.PubSubSubscriberFactory;

class DefaultPubSubSubscriberFactory
implements PubSubSubscriberFactory {
    private final int retries;
    private final Duration timeout;
    private final int maxMessagesPerPull;
    private final String projectSubscriptionName;

    DefaultPubSubSubscriberFactory(String projectSubscriptionName, int retries, Duration pullTimeout, int maxMessagesPerPull) {
        this.retries = retries;
        this.timeout = pullTimeout;
        this.maxMessagesPerPull = maxMessagesPerPull;
        this.projectSubscriptionName = projectSubscriptionName;
    }

    @Override
    public PubSubSubscriber getSubscriber(Credentials credentials) throws IOException {
        ManagedChannel channel = NettyChannelBuilder.forTarget((String)SubscriberStubSettings.getDefaultEndpoint()).negotiationType(NegotiationType.TLS).sslContext(GrpcSslContexts.forClient().ciphers(null).build()).build();
        PullRequest pullRequest = PullRequest.newBuilder().setMaxMessages(this.maxMessagesPerPull).setSubscription(this.projectSubscriptionName).build();
        SubscriberGrpc.SubscriberBlockingStub stub = (SubscriberGrpc.SubscriberBlockingStub)SubscriberGrpc.newBlockingStub((Channel)channel).withCallCredentials(MoreCallCredentials.from((Credentials)credentials));
        return new BlockingGrpcPubSubSubscriber(this.projectSubscriptionName, channel, stub, pullRequest, this.retries, this.timeout);
    }
}

