/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.hessian2.dubbo;

import com.alibaba.com.caucho.hessian.io.SerializerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.serialize.hessian2.dubbo.Hessian2FactoryInitializer;

public abstract class AbstractHessian2FactoryInitializer
implements Hessian2FactoryInitializer {
    private static final Map<ClassLoader, SerializerFactory> CL_2_SERIALIZER_FACTORY = new ConcurrentHashMap<ClassLoader, SerializerFactory>();
    private static volatile SerializerFactory SYSTEM_SERIALIZER_FACTORY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SerializerFactory getSerializerFactory() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            if (SYSTEM_SERIALIZER_FACTORY != null) return SYSTEM_SERIALIZER_FACTORY;
            Class<AbstractHessian2FactoryInitializer> clazz = AbstractHessian2FactoryInitializer.class;
            synchronized (AbstractHessian2FactoryInitializer.class) {
                if (SYSTEM_SERIALIZER_FACTORY != null) return SYSTEM_SERIALIZER_FACTORY;
                SYSTEM_SERIALIZER_FACTORY = this.createSerializerFactory();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return SYSTEM_SERIALIZER_FACTORY;
            }
        }
        if (CL_2_SERIALIZER_FACTORY.containsKey(classLoader)) return CL_2_SERIALIZER_FACTORY.get(classLoader);
        Class<AbstractHessian2FactoryInitializer> clazz = AbstractHessian2FactoryInitializer.class;
        synchronized (AbstractHessian2FactoryInitializer.class) {
            if (CL_2_SERIALIZER_FACTORY.containsKey(classLoader)) return CL_2_SERIALIZER_FACTORY.get(classLoader);
            SerializerFactory serializerFactory = this.createSerializerFactory();
            CL_2_SERIALIZER_FACTORY.put(classLoader, serializerFactory);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return serializerFactory;
        }
    }

    protected abstract SerializerFactory createSerializerFactory();
}

