/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.extension.inject;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.common.context.Lifecycle;
import org.apache.dubbo.common.extension.Adaptive;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionInjector;
import org.apache.dubbo.common.extension.ExtensionLoader;

@Adaptive
public class AdaptiveExtensionInjector
implements ExtensionInjector,
Lifecycle {
    private List<ExtensionInjector> injectors = Collections.emptyList();
    private ExtensionAccessor extensionAccessor;

    @Override
    public void setExtensionAccessor(ExtensionAccessor extensionAccessor) {
        this.extensionAccessor = extensionAccessor;
    }

    @Override
    public void initialize() throws IllegalStateException {
        ExtensionLoader<ExtensionInjector> loader = this.extensionAccessor.getExtensionLoader(ExtensionInjector.class);
        this.injectors = loader.getSupportedExtensions().stream().map(loader::getExtension).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public <T> T getInstance(Class<T> type, String name) {
        return this.injectors.stream().map(injector -> injector.getInstance(type, name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public void start() throws IllegalStateException {
    }

    @Override
    public void destroy() throws IllegalStateException {
    }
}

