/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.validation.support.jvalidation;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.groups.Default;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewConstructor;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.bytecode.ClassGenerator;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.validation.MethodValidated;
import org.apache.dubbo.validation.Validator;

public class JValidatorNew
implements Validator {
    private static final Logger logger = LoggerFactory.getLogger(JValidatorNew.class);
    private final Class<?> clazz;
    private final Map<String, Class> methodClassMap;
    private final jakarta.validation.Validator validator;

    public JValidatorNew(URL url) {
        this.clazz = ReflectUtils.forName(url.getServiceInterface());
        String jvalidation = url.getParameter("jvalidationNew");
        ValidatorFactory factory = jvalidation != null && jvalidation.length() > 0 ? Validation.byProvider(ReflectUtils.forName(jvalidation)).configure().buildValidatorFactory() : Validation.buildDefaultValidatorFactory();
        this.validator = factory.getValidator();
        this.methodClassMap = new ConcurrentHashMap<String, Class>();
    }

    private static Object getMethodParameterBean(Class<?> clazz, Method method, Object[] args) {
        if (!JValidatorNew.hasConstraintParameter(method)) {
            return null;
        }
        try {
            Class<?> parameterClass;
            String parameterClassName = JValidatorNew.generateMethodParameterClassName(clazz, method);
            try {
                parameterClass = Class.forName(parameterClassName, true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                parameterClass = JValidatorNew.generateMethodParameterClass(clazz, method, parameterClassName);
            }
            Object parameterBean = parameterClass.newInstance();
            for (int i = 0; i < args.length; ++i) {
                Field field = parameterClass.getField(method.getName() + "Argument" + i);
                field.set(parameterBean, args[i]);
            }
            return parameterBean;
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> generateMethodParameterClass(Class<?> clazz, Method method, String parameterClassName) throws Exception {
        ClassPool pool = ClassGenerator.getClassPool(clazz.getClassLoader());
        String string = parameterClassName.intern();
        synchronized (string) {
            CtClass ctClass = null;
            try {
                ctClass = pool.getCtClass(parameterClassName);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if (null == ctClass) {
                ctClass = pool.makeClass(parameterClassName);
                ClassFile classFile = ctClass.getClassFile();
                classFile.setVersionToJava5();
                ctClass.addConstructor(CtNewConstructor.defaultConstructor((CtClass)pool.getCtClass(parameterClassName)));
                Class<?>[] parameterTypes = method.getParameterTypes();
                java.lang.annotation.Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> type = parameterTypes[i];
                    java.lang.annotation.Annotation[] annotations = parameterAnnotations[i];
                    AnnotationsAttribute attribute = new AnnotationsAttribute(classFile.getConstPool(), "RuntimeVisibleAnnotations");
                    for (java.lang.annotation.Annotation annotation : annotations) {
                        Method[] members;
                        if (!annotation.annotationType().isAnnotationPresent(Constraint.class)) continue;
                        Annotation ja = new Annotation(classFile.getConstPool(), pool.getCtClass(annotation.annotationType().getName()));
                        for (Method member : members = annotation.annotationType().getMethods()) {
                            Object value;
                            if (!Modifier.isPublic((int)member.getModifiers()) || member.getParameterTypes().length != 0 || member.getDeclaringClass() != annotation.annotationType() || null == (value = member.invoke((Object)annotation, new Object[0]))) continue;
                            MemberValue memberValue = JValidatorNew.createMemberValue(classFile.getConstPool(), pool.get(member.getReturnType().getName()), value);
                            ja.addMemberValue(member.getName(), memberValue);
                        }
                        attribute.addAnnotation(ja);
                    }
                    String fieldName = method.getName() + "Argument" + i;
                    CtField ctField = CtField.make((String)("public " + type.getCanonicalName() + " " + fieldName + ";"), (CtClass)pool.getCtClass(parameterClassName));
                    ctField.getFieldInfo().addAttribute((AttributeInfo)attribute);
                    ctClass.addField(ctField);
                }
                return ctClass.toClass(clazz.getClassLoader(), null);
            }
            return Class.forName(parameterClassName, true, clazz.getClassLoader());
        }
    }

    private static String generateMethodParameterClassName(Class<?> clazz, Method method) {
        Class<?>[] parameterTypes;
        StringBuilder builder = new StringBuilder().append(clazz.getName()).append('_').append(JValidatorNew.toUpperMethoName(method.getName())).append("Parameter");
        for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
            builder.append('_').append(parameterType.getName());
        }
        return builder.toString();
    }

    private static boolean hasConstraintParameter(Method method) {
        java.lang.annotation.Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations != null && parameterAnnotations.length > 0) {
            java.lang.annotation.Annotation[][] annotationArray = parameterAnnotations;
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                java.lang.annotation.Annotation[] annotations;
                for (java.lang.annotation.Annotation annotation : annotations = annotationArray[i]) {
                    if (!annotation.annotationType().isAnnotationPresent(Constraint.class)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static String toUpperMethoName(String methodName) {
        return methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
    }

    private static MemberValue createMemberValue(ConstPool cp, CtClass type, Object value) throws NotFoundException {
        MemberValue memberValue = Annotation.createMemberValue((ConstPool)cp, (CtClass)type);
        if (memberValue instanceof BooleanMemberValue) {
            ((BooleanMemberValue)memberValue).setValue(((Boolean)value).booleanValue());
        } else if (memberValue instanceof ByteMemberValue) {
            ((ByteMemberValue)memberValue).setValue(((Byte)value).byteValue());
        } else if (memberValue instanceof CharMemberValue) {
            ((CharMemberValue)memberValue).setValue(((Character)value).charValue());
        } else if (memberValue instanceof ShortMemberValue) {
            ((ShortMemberValue)memberValue).setValue(((Short)value).shortValue());
        } else if (memberValue instanceof IntegerMemberValue) {
            ((IntegerMemberValue)memberValue).setValue(((Integer)value).intValue());
        } else if (memberValue instanceof LongMemberValue) {
            ((LongMemberValue)memberValue).setValue(((Long)value).longValue());
        } else if (memberValue instanceof FloatMemberValue) {
            ((FloatMemberValue)memberValue).setValue(((Float)value).floatValue());
        } else if (memberValue instanceof DoubleMemberValue) {
            ((DoubleMemberValue)memberValue).setValue(((Double)value).doubleValue());
        } else if (memberValue instanceof ClassMemberValue) {
            ((ClassMemberValue)memberValue).setValue(((Class)value).getName());
        } else if (memberValue instanceof StringMemberValue) {
            ((StringMemberValue)memberValue).setValue((String)value);
        } else if (memberValue instanceof EnumMemberValue) {
            ((EnumMemberValue)memberValue).setValue(((Enum)value).name());
        } else if (memberValue instanceof ArrayMemberValue) {
            CtClass arrayType = type.getComponentType();
            int len = Array.getLength(value);
            MemberValue[] members = new MemberValue[len];
            for (int i = 0; i < len; ++i) {
                members[i] = JValidatorNew.createMemberValue(cp, arrayType, Array.get(value, i));
            }
            ((ArrayMemberValue)memberValue).setValue(members);
        }
        return memberValue;
    }

    @Override
    public void validate(String methodName, Class<?>[] parameterTypes, Object[] arguments) throws Exception {
        try {
            ArrayList groups = new ArrayList();
            Class methodClass = this.methodClass(methodName);
            if (methodClass != null) {
                groups.add(methodClass);
            }
            HashSet violations = new HashSet();
            Method method = this.clazz.getMethod(methodName, parameterTypes);
            if (method.isAnnotationPresent(MethodValidated.class)) {
                Class<?>[] methodClasses = method.getAnnotation(MethodValidated.class).value();
                groups.addAll(Arrays.asList(methodClasses));
            }
            groups.add(0, Default.class);
            groups.add(1, this.clazz);
            Class[] classgroups = groups.toArray(new Class[groups.size()]);
            Object parameterBean = JValidatorNew.getMethodParameterBean(this.clazz, method, arguments);
            if (parameterBean != null) {
                violations.addAll(this.validator.validate(parameterBean, classgroups));
            }
            for (Object arg : arguments) {
                this.validate(violations, arg, classgroups);
            }
            if (!violations.isEmpty()) {
                logger.info("Failed to validate service: " + this.clazz.getName() + ", method: " + methodName + ", cause: " + violations);
                throw new ConstraintViolationException("Failed to validate service: " + this.clazz.getName() + ", method: " + methodName + ", cause: " + violations, violations);
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    private Class methodClass(String methodName) {
        Class<?> methodClass = null;
        String methodClassName = this.clazz.getName() + "$" + JValidatorNew.toUpperMethoName(methodName);
        Class cached = this.methodClassMap.get(methodClassName);
        if (cached != null) {
            return cached == this.clazz ? null : cached;
        }
        try {
            methodClass = Class.forName(methodClassName, false, Thread.currentThread().getContextClassLoader());
            this.methodClassMap.put(methodClassName, methodClass);
        }
        catch (ClassNotFoundException e) {
            this.methodClassMap.put(methodClassName, this.clazz);
        }
        return methodClass;
    }

    private void validate(Set<ConstraintViolation<?>> violations, Object arg, Class<?> ... groups) {
        if (arg != null && !ReflectUtils.isPrimitives(arg.getClass())) {
            if (arg instanceof Object[]) {
                for (Object item : (Object[])arg) {
                    this.validate(violations, item, groups);
                }
            } else if (arg instanceof Collection) {
                for (Object item : (Collection)arg) {
                    this.validate(violations, item, groups);
                }
            } else if (arg instanceof Map) {
                for (Map.Entry entry : ((Map)arg).entrySet()) {
                    this.validate(violations, entry.getKey(), groups);
                    this.validate(violations, entry.getValue(), groups);
                }
            } else {
                violations.addAll(this.validator.validate(arg, (Class[])groups));
            }
        }
    }
}

