/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import java.util.List;
import javax.net.ssl.SSLSession;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.api.SslContexts;

public class SslServerTlsHandler
extends ByteToMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(SslServerTlsHandler.class);
    private final SslContext sslContext;
    private final boolean detectSsl;

    public SslServerTlsHandler() {
        this(null, false);
    }

    public SslServerTlsHandler(URL url) {
        this(SslContexts.buildServerSslContext(url));
    }

    public SslServerTlsHandler(SslContext sslContext) {
        this(sslContext, true);
    }

    public SslServerTlsHandler(SslContext sslContext, boolean detectSsl) {
        this.sslContext = sslContext;
        this.detectSsl = detectSsl;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error("TLS negotiation failed when trying to accept new connection.", cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
            if (handshakeEvent.isSuccess()) {
                SSLSession session = ((SslHandler)ctx.pipeline().get(SslHandler.class)).engine().getSession();
                logger.info("TLS negotiation succeed with session: " + session);
                ctx.pipeline().remove((ChannelHandler)this);
            } else {
                logger.error("TLS negotiation failed when trying to accept new connection.", handshakeEvent.cause());
                ctx.close();
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (byteBuf.readableBytes() < 5) {
            return;
        }
        if (this.isSsl(byteBuf)) {
            this.enableSsl(channelHandlerContext);
        }
    }

    private boolean isSsl(ByteBuf buf) {
        if (this.detectSsl) {
            return SslHandler.isEncrypted((ByteBuf)buf);
        }
        return false;
    }

    private void enableSsl(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        ctx.pipeline().addAfter(ctx.name(), null, (ChannelHandler)this.sslContext.newHandler(ctx.alloc()));
        p.addLast("unificationA", (ChannelHandler)new SslServerTlsHandler(this.sslContext, false));
        p.remove((ChannelHandler)this);
    }
}

