/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.zookeeper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.support.CacheableFailbackRegistry;
import org.apache.dubbo.remoting.zookeeper.ChildListener;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.ZookeeperTransporter;
import org.apache.dubbo.rpc.RpcException;

public class ZookeeperRegistry
extends CacheableFailbackRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperRegistry.class);
    private static final String DEFAULT_ROOT = "dubbo";
    private final String root;
    private final Set<String> anyServices = new ConcurrentHashSet<String>();
    private final ConcurrentMap<URL, ConcurrentMap<NotifyListener, ChildListener>> zkListeners = new ConcurrentHashMap<URL, ConcurrentMap<NotifyListener, ChildListener>>();
    private ZookeeperClient zkClient;

    public ZookeeperRegistry(URL url, ZookeeperTransporter zookeeperTransporter) {
        super(url);
        if (url.isAnyHost()) {
            throw new IllegalStateException("registry address == null");
        }
        String group = url.getGroup(DEFAULT_ROOT);
        if (!group.startsWith("/")) {
            group = "/" + group;
        }
        this.root = group;
        this.zkClient = zookeeperTransporter.connect(url);
        this.zkClient.addStateListener(state -> {
            if (state == 2) {
                logger.warn("Trying to fetch the latest urls, in case there're provider changes during connection loss.\n Since ephemeral ZNode will not get deleted for a connection lose, there's no need to re-register url of this instance.");
                this.fetchLatestAddresses();
            } else if (state == 4) {
                logger.warn("Trying to re-register urls and re-subscribe listeners of this instance to registry...");
                try {
                    this.recover();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            } else if (state == 0) {
                logger.warn("Url of this instance will be deleted from registry soon. Dubbo client will try to re-register once a new session is created.");
            } else if (state == 3 || state == 1) {
                // empty if block
            }
        });
    }

    @Override
    public boolean isAvailable() {
        return this.zkClient != null && this.zkClient.isConnected();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.zkClient = null;
    }

    private void checkDestroyed() {
        if (this.zkClient == null) {
            throw new IllegalStateException("registry is destroyed");
        }
    }

    @Override
    public void doRegister(URL url) {
        try {
            this.checkDestroyed();
            this.zkClient.create(this.toUrlPath(url), url.getParameter("dynamic", true));
        }
        catch (Throwable e) {
            throw new RpcException("Failed to register " + url + " to zookeeper " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void doUnregister(URL url) {
        try {
            this.checkDestroyed();
            this.zkClient.delete(this.toUrlPath(url));
        }
        catch (Throwable e) {
            throw new RpcException("Failed to unregister " + url + " to zookeeper " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSubscribe(URL url, NotifyListener listener) {
        block10: {
            try {
                this.checkDestroyed();
                if ("*".equals(url.getServiceInterface())) {
                    String root = this.toRootPath();
                    boolean check = url.getParameter("check", false);
                    ConcurrentMap listeners = this.zkListeners.computeIfAbsent(url, k -> new ConcurrentHashMap());
                    ChildListener zkListener = listeners.computeIfAbsent(listener, k -> (parentPath, currentChildren) -> {
                        for (String child : currentChildren) {
                            if (this.anyServices.contains(child = URL.decode(child))) continue;
                            this.anyServices.add(child);
                            this.subscribe(url.setPath(child).addParameters("interface", child, "check", String.valueOf(check)), (NotifyListener)k);
                        }
                    });
                    this.zkClient.create(root, false);
                    List<String> services = this.zkClient.addChildListener(root, zkListener);
                    if (CollectionUtils.isNotEmpty(services)) {
                        for (String service : services) {
                            service = URL.decode(service);
                            this.anyServices.add(service);
                            this.subscribe(url.setPath(service).addParameters("interface", service, "check", String.valueOf(check)), listener);
                        }
                    }
                    break block10;
                }
                CountDownLatch latch = new CountDownLatch(1);
                try {
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (String path : this.toCategoriesPath(url)) {
                        ConcurrentMap listeners = this.zkListeners.computeIfAbsent(url, k -> new ConcurrentHashMap());
                        ChildListener zkListener = listeners.computeIfAbsent(listener, k -> new RegistryChildListenerImpl(url, (NotifyListener)k, latch));
                        if (zkListener instanceof RegistryChildListenerImpl) {
                            ((RegistryChildListenerImpl)zkListener).setLatch(latch);
                        }
                        this.zkClient.create(path, false);
                        List<String> children = this.zkClient.addChildListener(path, zkListener);
                        if (children == null) continue;
                        urls.addAll(this.toUrlsWithEmpty(url, path, children));
                    }
                    this.notify(url, listener, urls);
                }
                finally {
                    latch.countDown();
                }
            }
            catch (Throwable e) {
                throw new RpcException("Failed to subscribe " + url + " to zookeeper " + this.getUrl() + ", cause: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void doUnsubscribe(URL url, NotifyListener listener) {
        this.checkDestroyed();
        ConcurrentMap listeners = (ConcurrentMap)this.zkListeners.get(url);
        if (listeners != null) {
            ChildListener zkListener = (ChildListener)listeners.remove(listener);
            if (zkListener != null) {
                if ("*".equals(url.getServiceInterface())) {
                    String root = this.toRootPath();
                    this.zkClient.removeChildListener(root, zkListener);
                } else {
                    for (String path : this.toCategoriesPath(url)) {
                        this.zkClient.removeChildListener(path, zkListener);
                    }
                }
            }
            if (listeners.isEmpty()) {
                this.zkListeners.remove(url);
            }
        }
    }

    @Override
    public List<URL> lookup(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("lookup url == null");
        }
        try {
            this.checkDestroyed();
            ArrayList<String> providers = new ArrayList<String>();
            for (String path : this.toCategoriesPath(url)) {
                List<String> children = this.zkClient.getChildren(path);
                if (children == null) continue;
                providers.addAll(children);
            }
            return this.toUrlsWithoutEmpty(url, providers);
        }
        catch (Throwable e) {
            throw new RpcException("Failed to lookup " + url + " from zookeeper " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    private String toRootDir() {
        if (this.root.equals("/")) {
            return this.root;
        }
        return this.root + "/";
    }

    private String toRootPath() {
        return this.root;
    }

    private String toServicePath(URL url) {
        String name = url.getServiceInterface();
        if ("*".equals(name)) {
            return this.toRootPath();
        }
        return this.toRootDir() + URL.encode(name);
    }

    private String[] toCategoriesPath(URL url) {
        String[] categories = "*".equals(url.getCategory()) ? new String[]{"providers", "consumers", "routers", "configurators"} : url.getCategory(new String[]{"providers"});
        String[] paths = new String[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            paths[i] = this.toServicePath(url) + "/" + categories[i];
        }
        return paths;
    }

    private String toCategoryPath(URL url) {
        return this.toServicePath(url) + "/" + url.getCategory("providers");
    }

    private String toUrlPath(URL url) {
        return this.toCategoryPath(url) + "/" + URL.encode(url.toFullString());
    }

    private void fetchLatestAddresses() {
        HashMap<URL, Set<NotifyListener>> recoverSubscribed = new HashMap<URL, Set<NotifyListener>>(this.getSubscribed());
        if (!recoverSubscribed.isEmpty()) {
            if (logger.isInfoEnabled()) {
                logger.info("Fetching the latest urls of " + recoverSubscribed.keySet());
            }
            for (Map.Entry entry : recoverSubscribed.entrySet()) {
                URL url = (URL)entry.getKey();
                for (NotifyListener listener : (Set)entry.getValue()) {
                    this.removeFailedSubscribed(url, listener);
                    this.addFailedSubscribed(url, listener);
                }
            }
        }
    }

    @Override
    protected boolean isMatch(URL subscribeUrl, URL providerUrl) {
        return UrlUtils.isMatch(subscribeUrl, providerUrl);
    }

    public class ZookeeperRegistryNotifier {
        private long lastExecuteTime;
        private final URL consumerUrl;
        private final NotifyListener listener;
        private final long delayTime;

        public ZookeeperRegistryNotifier(URL consumerUrl, NotifyListener listener, long delayTime) {
            this.consumerUrl = consumerUrl;
            this.listener = listener;
            this.delayTime = delayTime;
        }

        public void notify(String path, Object rawAddresses) {
            if (path.endsWith("configurators") || path.endsWith("routers")) {
                this.doNotify(path, rawAddresses);
            }
            if (this.delayTime <= 0L) {
                this.doNotify(path, rawAddresses);
            } else {
                long interval = this.delayTime - (System.currentTimeMillis() - this.lastExecuteTime);
                if (interval > 0L) {
                    try {
                        Thread.sleep(interval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.lastExecuteTime = System.currentTimeMillis();
                this.doNotify(path, rawAddresses);
            }
        }

        protected void doNotify(String path, Object rawAddresses) {
            ZookeeperRegistry.this.notify(this.consumerUrl, this.listener, ZookeeperRegistry.this.toUrlsWithEmpty(this.consumerUrl, path, (List)rawAddresses));
        }
    }

    private class RegistryChildListenerImpl
    implements ChildListener {
        private final ZookeeperRegistryNotifier notifier;
        private volatile CountDownLatch latch;

        public RegistryChildListenerImpl(URL consumerUrl, NotifyListener listener, CountDownLatch latch) {
            this.latch = latch;
            this.notifier = new ZookeeperRegistryNotifier(consumerUrl, listener, ZookeeperRegistry.this.getDelay());
        }

        public void setLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void childChanged(String path, List<String> children) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                logger.warn("Zookeeper children listener thread was interrupted unexpectedly, may cause race condition with the main thread.");
            }
            this.notifier.notify(path, children);
        }
    }
}

