/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata.store;

import java.lang.reflect.Type;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.AbstractCacheManager;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.rpc.model.ScopeModel;

public class MetaCacheManager
extends AbstractCacheManager<MetadataInfo> {
    private static final String DEFAULT_FILE_NAME = ".metadata";
    private static final int DEFAULT_ENTRY_SIZE = 100;

    public static MetaCacheManager getInstance(ScopeModel scopeModel) {
        return scopeModel.getBeanFactory().getOrRegisterBean(MetaCacheManager.class);
    }

    public MetaCacheManager(String registryName, ScheduledExecutorService executorService) {
        String rawEntrySize;
        int entrySize;
        String filePath = System.getProperty("dubbo.meta.cache.filePath");
        String fileName = System.getProperty("dubbo.meta.cache.fileName");
        if (StringUtils.isEmpty(fileName)) {
            fileName = DEFAULT_FILE_NAME;
        }
        if (StringUtils.isNotEmpty(registryName)) {
            fileName = fileName + "." + registryName;
        }
        entrySize = (entrySize = StringUtils.parseInteger(rawEntrySize = System.getProperty("dubbo.meta.cache.entrySize"))) == 0 ? 100 : entrySize;
        String rawMaxFileSize = System.getProperty("dubbo.meta.cache.maxFileSize");
        long maxFileSize = StringUtils.parseLong(rawMaxFileSize);
        this.init(filePath, fileName, entrySize, maxFileSize, 60, executorService);
    }

    public MetaCacheManager() {
        this("", null);
    }

    @Override
    protected MetadataInfo toValueType(String value) {
        return (MetadataInfo)JsonUtils.getJson().toJavaObject(value, (Type)((Object)MetadataInfo.class));
    }

    @Override
    protected String getName() {
        return "meta";
    }
}

