/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.protocol;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.qos.server.Server;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

@Activate(order=200)
public class QosProtocolWrapper
implements Protocol,
ScopeModelAware {
    private final Logger logger = LoggerFactory.getLogger(QosProtocolWrapper.class);
    private AtomicBoolean hasStarted = new AtomicBoolean(false);
    private Protocol protocol;
    private FrameworkModel frameworkModel;

    public QosProtocolWrapper(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol == null");
        }
        this.protocol = protocol;
    }

    @Override
    public void setFrameworkModel(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public int getDefaultPort() {
        return this.protocol.getDefaultPort();
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        this.startQosServer(invoker.getUrl());
        return this.protocol.export(invoker);
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        this.startQosServer(url);
        return this.protocol.refer(type, url);
    }

    @Override
    public void destroy() {
        this.protocol.destroy();
        this.stopServer();
    }

    @Override
    public List<ProtocolServer> getServers() {
        return this.protocol.getServers();
    }

    private void startQosServer(URL url) {
        try {
            if (!this.hasStarted.compareAndSet(false, true)) {
                return;
            }
            boolean qosEnable = url.getParameter("qos.enable", true);
            if (!qosEnable) {
                this.logger.info("qos won't be started because it is disabled. Please check dubbo.application.qos.enable is configured either in system property, dubbo.properties or XML/spring-boot configuration.");
                return;
            }
            String host = url.getParameter("qos.host");
            int port = url.getParameter("qos.port", 22222);
            boolean acceptForeignIp = Boolean.parseBoolean(url.getParameter("qos.accept.foreign.ip", "false"));
            Server server = this.frameworkModel.getBeanFactory().getBean(Server.class);
            server.setHost(host);
            server.setPort(port);
            server.setAcceptForeignIp(acceptForeignIp);
            server.start();
        }
        catch (Throwable throwable) {
            this.logger.warn("Fail to start qos server: ", throwable);
        }
    }

    void stopServer() {
        if (this.hasStarted.compareAndSet(true, false)) {
            Server server = this.frameworkModel.getBeanFactory().getBean(Server.class);
            server.stop();
        }
    }
}

