/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.monitor.dubbo;

import com.alibaba.metrics.FastCompass;
import com.alibaba.metrics.MetricLevel;
import com.alibaba.metrics.MetricManager;
import com.alibaba.metrics.MetricName;
import com.alibaba.metrics.MetricRegistry;
import com.alibaba.metrics.common.CollectLevel;
import com.alibaba.metrics.common.MetricObject;
import com.alibaba.metrics.common.MetricsCollector;
import com.alibaba.metrics.common.MetricsCollectorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionAccessorAware;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.store.DataStore;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.monitor.MetricsService;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;
import org.apache.dubbo.rpc.support.RpcUtils;

@Deprecated
public class MetricsFilter
implements Filter,
ExtensionAccessorAware,
ScopeModelAware {
    private static final Logger logger = LoggerFactory.getLogger(MetricsFilter.class);
    protected static volatile AtomicBoolean exported = new AtomicBoolean(false);
    private Integer port;
    private String protocolName;
    private ExtensionAccessor extensionAccessor;
    private ApplicationModel applicationModel;
    private static final String METRICS_PORT = "metrics.port";
    private static final String METRICS_PROTOCOL = "metrics.protocol";

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (exported.compareAndSet(false, true)) {
            this.protocolName = invoker.getUrl().getParameter(METRICS_PROTOCOL) == null ? "dubbo" : invoker.getUrl().getParameter(METRICS_PROTOCOL);
            Protocol protocol = this.extensionAccessor.getExtensionLoader(Protocol.class).getExtension(this.protocolName);
            this.port = invoker.getUrl().getParameter(METRICS_PORT) == null ? protocol.getDefaultPort() : Integer.valueOf(invoker.getUrl().getParameter(METRICS_PORT)).intValue();
            Invoker<MetricsService> metricsInvoker = this.initMetricsInvoker();
            try {
                protocol.export(metricsInvoker);
            }
            catch (RuntimeException e) {
                logger.error("Metrics Service need to be configured when multiple processes are running on a host" + e.getMessage());
            }
        }
        boolean isProvider = invoker.getUrl().getSide("provider").equalsIgnoreCase("provider");
        long start = System.currentTimeMillis();
        try {
            Result result = invoker.invoke(invocation);
            long duration = System.currentTimeMillis() - start;
            this.reportMetrics(invoker, invocation, duration, "success", isProvider);
            return result;
        }
        catch (RpcException e) {
            long duration = System.currentTimeMillis() - start;
            String result = "error";
            if (e.isTimeout()) {
                result = "timeoutError";
            }
            if (e.isBiz()) {
                result = "bisError";
            }
            if (e.isNetwork()) {
                result = "networkError";
            }
            if (e.isSerialization()) {
                result = "serializationError";
            }
            this.reportMetrics(invoker, invocation, duration, result, isProvider);
            throw e;
        }
    }

    private String buildMethodName(Invocation invocation) {
        String methodName = RpcUtils.getMethodName(invocation);
        StringBuilder method = new StringBuilder(methodName);
        Class<?>[] argTypes = RpcUtils.getParameterTypes(invocation);
        method.append('(');
        for (int i = 0; i < argTypes.length; ++i) {
            method.append((i == 0 ? "" : ", ") + argTypes[i].getSimpleName());
        }
        method.append(')');
        Class<?> returnType = RpcUtils.getReturnType(invocation);
        String typeName = null;
        if (returnType != null) {
            typeName = returnType.getTypeName();
            typeName = typeName.substring(typeName.lastIndexOf(".") + 1);
        }
        return (typeName == null ? "void" : typeName) + " " + method;
    }

    private void reportMetrics(Invoker<?> invoker, Invocation invocation, long duration, String result, boolean isProvider) {
        MetricName method;
        MetricName global;
        final String serviceName = invoker.getInterface().getName();
        final String methodName = this.buildMethodName(invocation);
        if (isProvider) {
            global = new MetricName("dubbo.provider", MetricLevel.MAJOR);
            method = new MetricName("dubbo.provider.method", (Map)new HashMap<String, String>(4){
                {
                    super(initialCapacity);
                    this.put("service", serviceName);
                    this.put("method", methodName);
                }
            }, MetricLevel.NORMAL);
        } else {
            global = new MetricName("dubbo.consumer", MetricLevel.MAJOR);
            method = new MetricName("dubbo.consumer.method", (Map)new HashMap<String, String>(4){
                {
                    super(initialCapacity);
                    this.put("service", serviceName);
                    this.put("method", methodName);
                }
            }, MetricLevel.NORMAL);
        }
        this.setCompassQuantity("dubbo", result, duration, global, method);
    }

    private void setCompassQuantity(String groupName, String result, long duration, MetricName ... metricNames) {
        for (MetricName metricName : metricNames) {
            FastCompass compass = MetricManager.getFastCompass((String)groupName, (MetricName)metricName);
            compass.record(duration, result);
        }
    }

    private List<MetricObject> getThreadPoolMessage() {
        DataStore dataStore = this.extensionAccessor.getExtensionLoader(DataStore.class).getDefaultExtension();
        Map<String, Object> executors = dataStore.get(CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY);
        ArrayList<MetricObject> threadPoolMtricList = new ArrayList<MetricObject>();
        for (Map.Entry<String, Object> entry : executors.entrySet()) {
            String port = entry.getKey();
            ExecutorService executor = (ExecutorService)entry.getValue();
            if (!(executor instanceof ThreadPoolExecutor)) continue;
            ThreadPoolExecutor tp = (ThreadPoolExecutor)executor;
            threadPoolMtricList.add(this.value2MetricObject("threadPool.active", tp.getActiveCount(), MetricLevel.MAJOR));
            threadPoolMtricList.add(this.value2MetricObject("threadPool.core", tp.getCorePoolSize(), MetricLevel.MAJOR));
            threadPoolMtricList.add(this.value2MetricObject("threadPool.max", tp.getMaximumPoolSize(), MetricLevel.MAJOR));
            threadPoolMtricList.add(this.value2MetricObject("threadPool.current", tp.getPoolSize(), MetricLevel.MAJOR));
        }
        return threadPoolMtricList;
    }

    private MetricObject value2MetricObject(String metric, Integer value, MetricLevel level) {
        if (metric == null || value == null || level == null) {
            return null;
        }
        return new MetricObject.Builder(metric).withValue((Object)value).withLevel(level).build();
    }

    private Invoker<MetricsService> initMetricsInvoker() {
        Invoker<MetricsService> metricsInvoker = new Invoker<MetricsService>(){

            @Override
            public Class<MetricsService> getInterface() {
                return MetricsService.class;
            }

            @Override
            public Result invoke(Invocation invocation) throws RpcException {
                String group = invocation.getArguments()[0].toString();
                MetricRegistry registry = MetricManager.getIMetricManager().getMetricRegistryByGroup(group);
                SortedMap fastCompasses = registry.getFastCompasses();
                long timestamp = System.currentTimeMillis();
                double rateFactor = TimeUnit.SECONDS.toSeconds(1L);
                double durationFactor = 1.0 / (double)TimeUnit.MILLISECONDS.toNanos(1L);
                MetricsCollector collector = MetricsCollectorFactory.createNew((CollectLevel)CollectLevel.NORMAL, (Map)Collections.EMPTY_MAP, (double)rateFactor, (double)durationFactor, null);
                for (Map.Entry entry : fastCompasses.entrySet()) {
                    collector.collect((MetricName)entry.getKey(), (FastCompass)entry.getValue(), timestamp);
                }
                List res = collector.build();
                res.addAll(MetricsFilter.this.getThreadPoolMessage());
                return AsyncRpcResult.newDefaultAsyncResult(JsonUtils.getJson().toJson(res), invocation);
            }

            @Override
            public URL getUrl() {
                return URL.valueOf(MetricsFilter.this.protocolName + "://" + NetUtils.getIpByConfig(MetricsFilter.this.applicationModel) + ":" + MetricsFilter.this.port + "/" + MetricsService.class.getName());
            }

            @Override
            public boolean isAvailable() {
                return false;
            }

            @Override
            public void destroy() {
            }
        };
        return metricsInvoker;
    }

    @Override
    public void setExtensionAccessor(ExtensionAccessor extensionAccessor) {
        this.extensionAccessor = extensionAccessor;
    }
}

