/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.InmemoryConfiguration;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionDirector;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassLoaderResourceLoader;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;

public class ConfigUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigUtils.class);
    private static Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\s*\\{?\\s*([\\._0-9a-zA-Z]+)\\s*\\}?");
    private static int PID = -1;

    private ConfigUtils() {
    }

    public static boolean isNotEmpty(String value) {
        return !ConfigUtils.isEmpty(value);
    }

    public static boolean isEmpty(String value) {
        return StringUtils.isEmpty(value) || "false".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value) || "null".equalsIgnoreCase(value) || "N/A".equalsIgnoreCase(value);
    }

    public static boolean isDefault(String value) {
        return "true".equalsIgnoreCase(value) || "default".equalsIgnoreCase(value);
    }

    public static List<String> mergeValues(ExtensionDirector extensionDirector, Class<?> type, String cfg, List<String> def) {
        String[] configs;
        ArrayList<String> defaults = new ArrayList<String>();
        if (def != null) {
            for (String name : def) {
                if (!extensionDirector.getExtensionLoader(type).hasExtension(name)) continue;
                defaults.add(name);
            }
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String config : configs = cfg == null || cfg.trim().length() == 0 ? new String[]{} : CommonConstants.COMMA_SPLIT_PATTERN.split(cfg)) {
            if (config == null || config.trim().length() <= 0) continue;
            names.add(config);
        }
        if (!names.contains("-default")) {
            int i = names.indexOf("default");
            if (i > 0) {
                names.addAll(i, defaults);
            } else {
                names.addAll(0, defaults);
            }
            names.remove("default");
        } else {
            names.remove("default");
        }
        for (String name : new ArrayList(names)) {
            if (!name.startsWith("-")) continue;
            names.remove(name);
            names.remove(name.substring(1));
        }
        return names;
    }

    public static String replaceProperty(String expression, Map<String, String> params) {
        return ConfigUtils.replaceProperty(expression, new InmemoryConfiguration(params));
    }

    public static String replaceProperty(String expression, Configuration configuration) {
        if (StringUtils.isEmpty(expression) || expression.indexOf(36) < 0) {
            return expression;
        }
        Matcher matcher = VARIABLE_PATTERN.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = System.getProperty(key);
            if (value == null && configuration != null) {
                Object val = configuration.getProperty(key);
                String string = value = val != null ? val.toString() : null;
            }
            if (value == null) {
                value = matcher.group();
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static Properties getProperties(Set<ClassLoader> classLoaders) {
        String path = System.getProperty("dubbo.properties.file");
        if (StringUtils.isEmpty(path) && StringUtils.isEmpty(path = System.getenv("dubbo.properties.file"))) {
            path = "dubbo.properties";
        }
        return ConfigUtils.loadProperties(classLoaders, path, false, true);
    }

    public static String getSystemProperty(String key) {
        String value = System.getenv(key);
        if (StringUtils.isEmpty(value)) {
            value = System.getProperty(key);
        }
        return value;
    }

    public static Properties loadProperties(Set<ClassLoader> classLoaders, String fileName) {
        return ConfigUtils.loadProperties(classLoaders, fileName, false, false);
    }

    public static Properties loadProperties(Set<ClassLoader> classLoaders, String fileName, boolean allowMultiFile) {
        return ConfigUtils.loadProperties(classLoaders, fileName, allowMultiFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(Set<ClassLoader> classLoaders, String fileName, boolean allowMultiFile, boolean optional) {
        Properties properties = new Properties();
        if (ConfigUtils.checkFileNameExist(fileName)) {
            try (FileInputStream input = new FileInputStream(fileName);){
                properties.load(input);
            }
            catch (Throwable e) {
                logger.warn("Failed to load " + fileName + " file from " + fileName + "(ignore this file): " + e.getMessage(), e);
            }
            return properties;
        }
        Set<URL> set = null;
        try {
            LinkedList<ClassLoader> classLoadersToLoad = new LinkedList<ClassLoader>();
            classLoadersToLoad.add(ClassUtils.getClassLoader());
            classLoadersToLoad.addAll(classLoaders);
            set = ClassLoaderResourceLoader.loadResources(fileName, classLoadersToLoad).values().stream().reduce(new LinkedHashSet(), (a, i) -> {
                a.addAll(i);
                return a;
            });
        }
        catch (Throwable t) {
            logger.warn("Fail to load " + fileName + " file: " + t.getMessage(), t);
        }
        if (CollectionUtils.isEmpty(set)) {
            if (!optional) {
                logger.warn("No " + fileName + " found on the class path.");
            }
            return properties;
        }
        if (!allowMultiFile) {
            if (set.size() > 1) {
                String errMsg = String.format("only 1 %s file is expected, but %d dubbo.properties files found on class path: %s", fileName, set.size(), set);
                logger.warn(errMsg);
            }
            try {
                properties.load(ClassUtils.getClassLoader().getResourceAsStream(fileName));
            }
            catch (Throwable e) {
                logger.warn("Failed to load " + fileName + " file from " + fileName + "(ignore this file): " + e.getMessage(), e);
            }
            return properties;
        }
        logger.info("load " + fileName + " properties file from " + set);
        for (URL url : set) {
            try {
                Properties p = new Properties();
                InputStream input = url.openStream();
                if (input == null) continue;
                try {
                    p.load(input);
                    properties.putAll((Map<?, ?>)p);
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable e) {
                logger.warn("Fail to load " + fileName + " file from " + url + "(ignore this file): " + e.getMessage(), e);
            }
        }
        return properties;
    }

    public static String loadMigrationRule(Set<ClassLoader> classLoaders, String fileName) {
        String rawRule = "";
        if (ConfigUtils.checkFileNameExist(fileName)) {
            String string;
            FileInputStream input = new FileInputStream(fileName);
            try {
                string = ConfigUtils.readString(input);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    logger.warn("Failed to load " + fileName + " file from " + fileName + "(ignore this file): " + e.getMessage(), e);
                }
            }
            input.close();
            return string;
        }
        try {
            LinkedList<ClassLoader> classLoadersToLoad = new LinkedList<ClassLoader>();
            classLoadersToLoad.add(ClassUtils.getClassLoader());
            classLoadersToLoad.addAll(classLoaders);
            for (Set<URL> urls : ClassLoaderResourceLoader.loadResources(fileName, classLoadersToLoad).values()) {
                for (URL url : urls) {
                    InputStream is = url.openStream();
                    if (is == null) continue;
                    return ConfigUtils.readString(is);
                }
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to load " + fileName + " file from " + fileName + "(ignore this file): " + e.getMessage(), e);
        }
        return rawRule;
    }

    private static String readString(InputStream is) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] buffer = new char[10];
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            int n;
            while ((n = reader.read(buffer)) != -1) {
                if (n < 10) {
                    buffer = Arrays.copyOf(buffer, n);
                }
                stringBuilder.append(String.valueOf(buffer));
                buffer = new char[10];
            }
        }
        catch (IOException e) {
            logger.error("Read migration file error.", e);
        }
        return stringBuilder.toString();
    }

    private static boolean checkFileNameExist(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public static int getPid() {
        if (PID < 0) {
            try {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                String name = runtime.getName();
                PID = Integer.parseInt(name.substring(0, name.indexOf(64)));
            }
            catch (Throwable e) {
                PID = 0;
            }
        }
        return PID;
    }
}

