/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.parameter;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.ResourceType;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.DataSourceParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.ResourceParametersHelper;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopJobType;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.sources.SourceMysqlParameter;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.targets.TargetMysqlParameter;

public class SqoopParameters
extends AbstractParameters {
    private String jobType;
    private String customShell;
    private String jobName;
    private String modelType;
    private int concurrency;
    private String splitBy;
    private String sourceType;
    private String targetType;
    private String sourceParams;
    private String targetParams;
    private List<Property> hadoopCustomParams;
    private List<Property> sqoopAdvancedParams;

    public String getModelType() {
        return this.modelType;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public String getSplitBy() {
        return this.splitBy;
    }

    public void setSplitBy(String splitBy) {
        this.splitBy = splitBy;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getSourceParams() {
        return this.sourceParams;
    }

    public void setSourceParams(String sourceParams) {
        this.sourceParams = sourceParams;
    }

    public String getTargetParams() {
        return this.targetParams;
    }

    public void setTargetParams(String targetParams) {
        this.targetParams = targetParams;
    }

    public String getJobType() {
        return this.jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getCustomShell() {
        return this.customShell;
    }

    public void setCustomShell(String customShell) {
        this.customShell = customShell;
    }

    public List<Property> getHadoopCustomParams() {
        return this.hadoopCustomParams;
    }

    public void setHadoopCustomParams(List<Property> hadoopCustomParams) {
        this.hadoopCustomParams = hadoopCustomParams;
    }

    public List<Property> getSqoopAdvancedParams() {
        return this.sqoopAdvancedParams;
    }

    public void setSqoopAdvancedParams(List<Property> sqoopAdvancedParams) {
        this.sqoopAdvancedParams = sqoopAdvancedParams;
    }

    public boolean checkParameters() {
        boolean sqoopParamsCheck = false;
        if (StringUtils.isEmpty((CharSequence)this.jobType)) {
            return sqoopParamsCheck;
        }
        if (SqoopJobType.TEMPLATE.getDescp().equals(this.jobType)) {
            sqoopParamsCheck = StringUtils.isEmpty((CharSequence)this.customShell) && StringUtils.isNotEmpty((CharSequence)this.modelType) && StringUtils.isNotEmpty((CharSequence)this.jobName) && this.concurrency != 0 && StringUtils.isNotEmpty((CharSequence)this.sourceType) && StringUtils.isNotEmpty((CharSequence)this.targetType) && StringUtils.isNotEmpty((CharSequence)this.sourceParams) && StringUtils.isNotEmpty((CharSequence)this.targetParams);
        } else if (SqoopJobType.CUSTOM.getDescp().equals(this.jobType)) {
            sqoopParamsCheck = StringUtils.isNotEmpty((CharSequence)this.customShell) && StringUtils.isEmpty((CharSequence)this.jobName);
        }
        return sqoopParamsCheck;
    }

    public ResourceParametersHelper getResources() {
        TargetMysqlParameter targetMysqlParameter;
        ResourceParametersHelper resources = super.getResources();
        if (!SqoopJobType.TEMPLATE.getDescp().equals(this.getJobType())) {
            return resources;
        }
        SourceMysqlParameter sourceMysqlParameter = (SourceMysqlParameter)JSONUtils.parseObject((String)this.getSourceParams(), SourceMysqlParameter.class);
        if (sourceMysqlParameter.getSrcDatasource() != 0) {
            resources.put(ResourceType.DATASOURCE, Integer.valueOf(sourceMysqlParameter.getSrcDatasource()));
        }
        if ((targetMysqlParameter = (TargetMysqlParameter)JSONUtils.parseObject((String)this.getTargetParams(), TargetMysqlParameter.class)).getTargetDatasource() != 0) {
            resources.put(ResourceType.DATASOURCE, Integer.valueOf(targetMysqlParameter.getTargetDatasource()));
        }
        return resources;
    }

    public SqoopTaskExecutionContext generateExtendedContext(ResourceParametersHelper parametersHelper) {
        SqoopTaskExecutionContext sqoopTaskExecutionContext = new SqoopTaskExecutionContext();
        if (!SqoopJobType.TEMPLATE.getDescp().equals(this.getJobType())) {
            return sqoopTaskExecutionContext;
        }
        SourceMysqlParameter sourceMysqlParameter = (SourceMysqlParameter)JSONUtils.parseObject((String)this.getSourceParams(), SourceMysqlParameter.class);
        TargetMysqlParameter targetMysqlParameter = (TargetMysqlParameter)JSONUtils.parseObject((String)this.getTargetParams(), TargetMysqlParameter.class);
        DataSourceParameters dataSource = (DataSourceParameters)parametersHelper.getResourceParameters(ResourceType.DATASOURCE, Integer.valueOf(sourceMysqlParameter.getSrcDatasource()));
        DataSourceParameters dataTarget = (DataSourceParameters)parametersHelper.getResourceParameters(ResourceType.DATASOURCE, Integer.valueOf(targetMysqlParameter.getTargetDatasource()));
        if (Objects.nonNull(dataSource)) {
            sqoopTaskExecutionContext.setDataSourceId(sourceMysqlParameter.getSrcDatasource());
            sqoopTaskExecutionContext.setSourcetype(dataSource.getType());
            sqoopTaskExecutionContext.setSourceConnectionParams(dataSource.getConnectionParams());
        }
        if (Objects.nonNull(dataTarget)) {
            sqoopTaskExecutionContext.setDataTargetId(targetMysqlParameter.getTargetDatasource());
            sqoopTaskExecutionContext.setTargetType(dataTarget.getType());
            sqoopTaskExecutionContext.setTargetConnectionParams(dataTarget.getConnectionParams());
        }
        return sqoopTaskExecutionContext;
    }
}

