/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator.targets;

import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ITargetGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.targets.TargetHiveParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTargetGenerator
implements ITargetGenerator {
    private static final Logger logger = LoggerFactory.getLogger(HiveTargetGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, SqoopTaskExecutionContext sqoopTaskExecutionContext) {
        StringBuilder hiveTargetSb = new StringBuilder();
        try {
            TargetHiveParameter targetHiveParameter = (TargetHiveParameter)JSONUtils.parseObject((String)sqoopParameters.getTargetParams(), TargetHiveParameter.class);
            if (null != targetHiveParameter) {
                hiveTargetSb.append(" ").append("--hive-import");
                if (StringUtils.isNotEmpty((CharSequence)targetHiveParameter.getHiveDatabase()) && StringUtils.isNotEmpty((CharSequence)targetHiveParameter.getHiveTable())) {
                    hiveTargetSb.append(" ").append("--hive-database").append(" ").append(targetHiveParameter.getHiveDatabase()).append(" ").append("--hive-table").append(" ").append(targetHiveParameter.getHiveTable());
                }
                if (targetHiveParameter.isCreateHiveTable()) {
                    hiveTargetSb.append(" ").append("--create-hive-table");
                }
                if (targetHiveParameter.isDropDelimiter()) {
                    hiveTargetSb.append(" ").append("--hive-drop-import-delims");
                }
                if (targetHiveParameter.isHiveOverWrite()) {
                    hiveTargetSb.append(" ").append("--hive-overwrite").append(" ").append("--delete-target-dir");
                }
                if (StringUtils.isNotEmpty((CharSequence)targetHiveParameter.getReplaceDelimiter())) {
                    hiveTargetSb.append(" ").append("--hive-delims-replacement").append(" ").append(targetHiveParameter.getReplaceDelimiter());
                }
                if (StringUtils.isNotEmpty((CharSequence)targetHiveParameter.getHivePartitionKey()) && StringUtils.isNotEmpty((CharSequence)targetHiveParameter.getHivePartitionValue())) {
                    hiveTargetSb.append(" ").append("--hive-partition-key").append(" ").append(targetHiveParameter.getHivePartitionKey()).append(" ").append("--hive-partition-value").append(" ").append(targetHiveParameter.getHivePartitionValue());
                }
                if (StringUtils.isNotEmpty((CharSequence)targetHiveParameter.getHiveTargetDir())) {
                    hiveTargetSb.append(" ").append("--target-dir").append(" ").append(targetHiveParameter.getHiveTargetDir());
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("Sqoop hive target params build failed: [%s]", e.getMessage()));
        }
        return hiveTargetSb.toString();
    }
}

