/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop;

import java.util.Map;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractYarnTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParamUtils;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.SqoopJobGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;

public class SqoopTask
extends AbstractYarnTask {
    private SqoopParameters sqoopParameters;
    private final TaskExecutionContext taskExecutionContext;
    private SqoopTaskExecutionContext sqoopTaskExecutionContext;

    public SqoopTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        this.logger.info("sqoop task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.sqoopParameters = (SqoopParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), SqoopParameters.class));
        if (null == this.sqoopParameters) {
            throw new IllegalArgumentException("Sqoop Task params is null");
        }
        if (!this.sqoopParameters.checkParameters()) {
            throw new IllegalArgumentException("Sqoop Task params check fail");
        }
        this.sqoopTaskExecutionContext = this.sqoopParameters.generateExtendedContext(this.taskExecutionContext.getResourceParametersHelper());
    }

    protected String buildCommand() {
        SqoopJobGenerator generator = new SqoopJobGenerator();
        String script = generator.generateSqoopJob(this.sqoopParameters, this.sqoopTaskExecutionContext);
        Map paramsMap = this.taskExecutionContext.getPrepareParamsMap();
        String resultScripts = ParameterUtils.convertParameterPlaceholders((String)script, (Map)ParamUtils.convert((Map)paramsMap));
        this.logger.info("sqoop script: {}", (Object)resultScripts);
        return resultScripts;
    }

    protected void setMainJarName() {
    }

    public AbstractParameters getParameters() {
        return this.sqoopParameters;
    }
}

