/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.email.template;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.alert.api.ShowType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.alert.email.template.AlertTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationprocessor.json.JSONArray;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONTokener;

public class DefaultHTMLTemplate
implements AlertTemplate {
    public static final Logger logger = LoggerFactory.getLogger(DefaultHTMLTemplate.class);

    @Override
    public String getMessageFromTemplate(String content, ShowType showType, boolean showAll) {
        switch (showType) {
            case TABLE: {
                return this.getTableTypeMessage(content, showAll);
            }
            case TEXT: {
                return this.getTextTypeMessage(content);
            }
        }
        throw new IllegalArgumentException(String.format("not support showType: %s in DefaultHTMLTemplate", showType));
    }

    private String getTableTypeMessage(String content, boolean showAll) {
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            List mapItemsList = JSONUtils.toList((String)content, LinkedHashMap.class);
            if (!showAll && mapItemsList.size() > 1000) {
                mapItemsList = mapItemsList.subList(0, 1000);
            }
            StringBuilder contents = new StringBuilder(200);
            boolean flag = true;
            String title = "";
            for (LinkedHashMap mapItems : mapItemsList) {
                Set entries = mapItems.entrySet();
                Iterator iterator = entries.iterator();
                StringBuilder t = new StringBuilder("<tr>");
                StringBuilder cs = new StringBuilder("<tr>");
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    t.append("<th>").append((String)entry.getKey()).append("</th>");
                    cs.append("<td>").append(entry.getValue()).append("</td>");
                }
                t.append("</tr>");
                cs.append("</tr>");
                if (flag) {
                    title = t.toString();
                }
                flag = false;
                contents.append((CharSequence)cs);
            }
            return this.getMessageFromHtmlTemplate(title, contents.toString());
        }
        return content;
    }

    private String getTextTypeMessage(String content) {
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            try {
                Object contentObject = new JSONTokener(content).nextValue();
                if (!(contentObject instanceof JSONArray)) {
                    ObjectNode jsonNodes = JSONUtils.parseObject((String)content);
                    content = JSONUtils.toJsonString(Collections.singletonList(jsonNodes));
                }
            }
            catch (JSONException e) {
                logger.error("alert content is null");
            }
            ArrayNode list = JSONUtils.parseArray((String)content);
            StringBuilder contents = new StringBuilder(100);
            for (JsonNode jsonNode : list) {
                contents.append("<tr>");
                contents.append("<td>").append(jsonNode.toString()).append("</td>");
                contents.append("</tr>");
            }
            return this.getMessageFromHtmlTemplate(null, contents.toString());
        }
        return content;
    }

    private String getMessageFromHtmlTemplate(String title, String content) {
        Objects.requireNonNull(content, "content must not null");
        String htmlTableThead = StringUtils.isEmpty((CharSequence)title) ? "" : String.format("<thead>%s</thead>%n", title);
        return "<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN' 'http://www.w3.org/TR/html4/loose.dtd'><html><head><title>dolphinscheduler</title><meta name='Keywords' content=''><meta name='Description' content=''><style type=\"text/css\">table {margin-top:0px;padding-top:0px;border:1px solid;font-size: 14px;color: #333333;border-width: 1px;border-color: #666666;border-collapse: collapse;}table th {border-width: 1px;padding: 8px;border-style: solid;border-color: #666666;background-color: #dedede;text-align: left;}table td {border-width: 1px;padding: 8px;border-style: solid;border-color: #666666;background-color: #ffffff;text-align: left;}</style></head><body style=\"margin:0;padding:0\"><table border=\"1px\" cellpadding=\"5px\" cellspacing=\"-10px\"> " + htmlTableThead + content + "</table></body></html>";
    }
}

