/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.email;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.alert.email.exception.AlertEmailException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelUtils {
    private static final int XLSX_WINDOW_ROW = 10000;
    private static final Logger logger = LoggerFactory.getLogger(ExcelUtils.class);

    private ExcelUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void genExcelFile(String content, String title, String xlsFilePath) {
        File file = new File(xlsFilePath);
        if (!file.exists() && !file.mkdirs()) {
            logger.error("Create xlsx directory error, path:{}", (Object)xlsFilePath);
            throw new AlertEmailException("Create xlsx directory error");
        }
        List itemsList = JSONUtils.toList((String)content, LinkedHashMap.class);
        if (CollectionUtils.isEmpty((Collection)itemsList)) {
            logger.error("itemsList is null");
            throw new AlertEmailException("itemsList is null");
        }
        LinkedHashMap headerMap = (LinkedHashMap)itemsList.get(0);
        ArrayList headerList = new ArrayList();
        for (Map.Entry en : headerMap.entrySet()) {
            headerList.add(en.getKey());
        }
        try (SXSSFWorkbook wb = new SXSSFWorkbook(10000);
             FileOutputStream fos = new FileOutputStream(String.format("%s/%s.xlsx", xlsFilePath, title));){
            SXSSFSheet sheet = wb.createSheet();
            Row row = sheet.createRow(0);
            row.setHeight((short)500);
            CellStyle cellStyle = wb.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.RIGHT);
            for (int i = 0; i < headerList.size(); ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle(cellStyle);
                cell.setCellValue((String)headerList.get(i));
            }
            int rowIndex = 1;
            for (LinkedHashMap itemsMap : itemsList) {
                Object[] values = itemsMap.values().toArray();
                row = sheet.createRow(rowIndex);
                row.setHeight((short)500);
                ++rowIndex;
                for (int j = 0; j < values.length; ++j) {
                    Cell cell1 = row.createCell(j);
                    cell1.setCellStyle(cellStyle);
                    if (values[j] instanceof Number) {
                        cell1.setCellValue(Double.parseDouble(String.valueOf(values[j])));
                        continue;
                    }
                    cell1.setCellValue(String.valueOf(values[j]));
                }
            }
            for (int i = 0; i < headerList.size(); ++i) {
                sheet.setColumnWidth(i, ((String)headerList.get(i)).length() * 800);
            }
            wb.write((OutputStream)fos);
            wb.dispose();
        }
        catch (Exception e) {
            throw new AlertEmailException("generate excel error", e);
        }
    }
}

