/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UserTypeConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class CastNode
extends ValueNode {
    ValueNode castOperand;
    private int targetCharType;
    TypeId sourceCTI = null;
    private boolean forDataTypeFunction = false;
    private boolean externallyGeneratedCastNode = false;
    private boolean assignmentSemantics = false;

    public void init(Object object, Object object2) throws StandardException {
        this.castOperand = (ValueNode)object;
        this.setType((DataTypeDescriptor)object2);
    }

    public void init(Object object, Object object2, Object object3) throws StandardException {
        this.castOperand = (ValueNode)object;
        int n = (Integer)object3;
        this.targetCharType = (Integer)object2;
        if (n < 0) {
            return;
        }
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.targetCharType, n));
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.castOperand.getOrderableVariantType();
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List list) throws StandardException {
        Object object;
        int n;
        Object object2;
        this.castOperand = this.castOperand.bindExpression(fromList, subqueryList, list);
        if (this.getTypeServices() == null) {
            object2 = this.castOperand.getTypeServices();
            n = -1;
            TypeId typeId = ((DataTypeDescriptor)object2).getTypeId();
            if (object2 != null) {
                if (typeId.isNumericTypeId()) {
                    n = ((DataTypeDescriptor)object2).getPrecision() + 1;
                    if (((DataTypeDescriptor)object2).getScale() > 0) {
                        ++n;
                    }
                } else if (typeId.isStringTypeId()) {
                    n = ((DataTypeDescriptor)object2).getMaximumWidth();
                    if (this.targetCharType == 1) {
                        n = Math.min(n, 254);
                    } else if (this.targetCharType == 12) {
                        n = Math.min(n, 32672);
                    }
                } else {
                    object = ((DataTypeDescriptor)object2).getTypeId();
                    if (n < 0) {
                        n = DataTypeUtilities.getColumnDisplaySize(((TypeId)object).getJDBCTypeId(), -1);
                    }
                }
            }
            if (n < 0) {
                n = 1;
            }
            this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.targetCharType, n));
        }
        if (this.castOperand instanceof UntypedNullConstantNode) {
            this.castOperand.setType(this.getTypeServices());
        }
        this.bindCastNodeOnly();
        if (this.castOperand instanceof ConstantNode && !(this.castOperand instanceof UntypedNullConstantNode)) {
            object2 = this;
            n = this.sourceCTI.getJDBCTypeId();
            int n2 = this.getTypeId().getJDBCTypeId();
            switch (n) {
                case -7: 
                case 16: {
                    if (n2 == -7 || n2 == 16) {
                        object2 = this.castOperand;
                        break;
                    }
                    if (n2 != 1) break;
                    object = (BooleanConstantNode)this.castOperand;
                    String string = ((BooleanConstantNode)object).getValueAsString();
                    object2 = (ValueNode)this.getNodeFactory().getNode(61, string, ReuseFactory.getInteger(this.getTypeServices().getMaximumWidth()), this.getContextManager());
                    break;
                }
                case 1: {
                    object2 = this.getCastFromCharConstant(n2);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (n2 != 1) break;
                    object = ((UserTypeConstantNode)this.castOperand).getObjectValue().toString();
                    object2 = (ValueNode)this.getNodeFactory().getNode(61, object, ReuseFactory.getInteger(this.getTypeServices().getMaximumWidth()), this.getContextManager());
                    break;
                }
                case 3: {
                    if (n2 == 3 || n2 == 2) break;
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    object2 = this.getCastFromNumericType(((ConstantNode)this.castOperand).getValue(), n2);
                }
            }
            return object2;
        }
        return this;
    }

    public void bindCastNodeOnly() throws StandardException {
        Object object;
        this.sourceCTI = this.castOperand.getTypeId();
        if (this.externallyGeneratedCastNode && this.getTypeId().isStringTypeId()) {
            this.setCollationUsingCompilationSchema();
        }
        if (this.getTypeId().userType()) {
            this.setType(this.bindUserType(this.getTypeServices()));
            object = this.getTypeId().getCorrespondingJavaTypeName();
            this.verifyClassExist((String)object);
        }
        if (this.castOperand.requiresTypeFromContext()) {
            this.castOperand.setType(this.getTypeServices());
        } else if (!(this.castOperand instanceof UntypedNullConstantNode) && !(object = this.castOperand.getTypeCompiler()).convertible(this.getTypeId(), this.forDataTypeFunction)) {
            throw StandardException.newException("42846", (Object)this.sourceCTI.getSQLTypeName(), (Object)this.getTypeId().getSQLTypeName());
        }
        if (this.castOperand.getTypeServices().getTypeId().isStringTypeId() && this.getTypeId().isBooleanTypeId()) {
            this.setNullability(true);
        } else {
            this.setNullability(this.castOperand.getTypeServices().isNullable());
        }
    }

    private ValueNode getCastFromCharConstant(int n) throws StandardException {
        String string = ((CharConstantNode)this.castOperand).getString();
        String string2 = StringUtil.SQLToUpperCase(string.trim());
        CastNode castNode = this;
        switch (n) {
            case -7: 
            case 16: {
                if (string2.equals("TRUE")) {
                    return (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
                }
                if (string2.equals("FALSE")) {
                    return (ValueNode)this.getNodeFactory().getNode(38, Boolean.FALSE, this.getContextManager());
                }
                if (string2.equals("UNKNOWN")) {
                    return (ValueNode)this.getNodeFactory().getNode(38, null, this.getContextManager());
                }
                throw StandardException.newException("22018", "boolean");
            }
            case 91: {
                return (ValueNode)this.getNodeFactory().getNode(76, this.getDataValueFactory().getDateValue(string2, false), this.getContextManager());
            }
            case 93: {
                return (ValueNode)this.getNodeFactory().getNode(76, this.getDataValueFactory().getTimestampValue(string2, false), this.getContextManager());
            }
            case 92: {
                return (ValueNode)this.getNodeFactory().getNode(76, this.getDataValueFactory().getTimeValue(string2, false), this.getContextManager());
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                try {
                    return this.getCastFromIntegralType(new Double(string2).longValue(), n);
                }
                catch (NumberFormatException numberFormatException) {
                    String string3 = TypeId.getBuiltInTypeId(n).getSQLTypeName();
                    throw StandardException.newException("22018", string3);
                }
            }
            case 7: {
                Float f;
                try {
                    f = Float.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw StandardException.newException("22018", "float");
                }
                return (ValueNode)this.getNodeFactory().getNode(69, f, this.getContextManager());
            }
            case 8: {
                Double d;
                try {
                    d = new Double(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw StandardException.newException("22018", "double");
                }
                return (ValueNode)this.getNodeFactory().getNode(68, d, this.getContextManager());
            }
        }
        return castNode;
    }

    private ValueNode getCastFromIntegralType(long l, int n) throws StandardException {
        CastNode castNode = this;
        switch (n) {
            case 1: {
                return (ValueNode)this.getNodeFactory().getNode(61, Long.toString(l), ReuseFactory.getInteger(this.getTypeServices().getMaximumWidth()), this.getContextManager());
            }
            case -6: {
                if (l < -128L || l > 127L) {
                    throw StandardException.newException("22003", "TINYINT");
                }
                return (ValueNode)this.getNodeFactory().getNode(75, ReuseFactory.getByte((byte)l), this.getContextManager());
            }
            case 5: {
                if (l < -32768L || l > 32767L) {
                    throw StandardException.newException("22003", "SHORT");
                }
                return (ValueNode)this.getNodeFactory().getNode(74, ReuseFactory.getShort((short)l), this.getContextManager());
            }
            case 4: {
                if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                    throw StandardException.newException("22003", "INTEGER");
                }
                return (ValueNode)this.getNodeFactory().getNode(70, ReuseFactory.getInteger((int)l), this.getContextManager());
            }
            case -5: {
                return (ValueNode)this.getNodeFactory().getNode(71, ReuseFactory.getLong(l), this.getContextManager());
            }
            case 7: {
                if ((float)Math.abs(l) > Float.MAX_VALUE) {
                    throw StandardException.newException("22003", "REAL");
                }
                return (ValueNode)this.getNodeFactory().getNode(69, new Float(l), this.getContextManager());
            }
            case 8: {
                return (ValueNode)this.getNodeFactory().getNode(68, new Double(l), this.getContextManager());
            }
        }
        return castNode;
    }

    private ValueNode getCastFromNumericType(DataValueDescriptor dataValueDescriptor, int n) throws StandardException {
        int n2 = -1;
        Object object = null;
        switch (n) {
            case 1: {
                n2 = 61;
                object = dataValueDescriptor.getString();
                return (ValueNode)this.getNodeFactory().getNode(n2, object, ReuseFactory.getInteger(this.getTypeServices().getMaximumWidth()), this.getContextManager());
            }
            case -6: {
                n2 = 75;
                object = new Byte(dataValueDescriptor.getByte());
                break;
            }
            case 5: {
                n2 = 74;
                object = ReuseFactory.getShort(dataValueDescriptor.getShort());
                break;
            }
            case 4: {
                n2 = 70;
                object = ReuseFactory.getInteger(dataValueDescriptor.getInt());
                break;
            }
            case -5: {
                n2 = 71;
                object = ReuseFactory.getLong(dataValueDescriptor.getLong());
                break;
            }
            case 7: {
                n2 = 69;
                object = new Float(NumberDataType.normalizeREAL(dataValueDescriptor.getDouble()));
                break;
            }
            case 8: {
                n2 = 68;
                object = new Double(dataValueDescriptor.getDouble());
            }
        }
        if (n2 == -1) {
            return this;
        }
        return (ValueNode)this.getNodeFactory().getNode(n2, object, this.getContextManager());
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.castOperand = this.castOperand.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return this.castOperand.categorize(jBitSet, bl);
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.castOperand = this.castOperand.remapColumnReferencesToExpressions();
        return this;
    }

    public boolean isConstantExpression() {
        return this.castOperand.isConstantExpression();
    }

    public boolean constantExpression(PredicateList predicateList) {
        return this.castOperand.constantExpression(predicateList);
    }

    Object getConstantValueAsObject() throws StandardException {
        Object object = this.castOperand.getConstantValueAsObject();
        if (object == null) {
            return null;
        }
        if (this.sourceCTI.getCorrespondingJavaTypeName().equals(this.getTypeId().getCorrespondingJavaTypeName())) {
            return object;
        }
        return null;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.castOperand.generateExpression(expressionClassBuilder, methodBuilder);
        if (this.castOperand instanceof UntypedNullConstantNode) {
            return;
        }
        if (this.castOperand.requiresTypeFromContext()) {
            this.sourceCTI = this.getTypeId();
        }
        this.genDataValueConversion(expressionClassBuilder, methodBuilder);
    }

    private void genDataValueConversion(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
        String string = this.getTypeCompiler().interfaceName();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
        expressionClassBuilder.generateNull(methodBuilder2, this.getTypeCompiler(this.getTypeId()), this.getTypeServices().getCollationType());
        methodBuilder2.setField(localField);
        if (!this.sourceCTI.userType() && !this.getTypeId().userType()) {
            methodBuilder.getField(localField);
            methodBuilder.swap();
            methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", "setValue", "void", 1);
        } else {
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", "getObject", "java.lang.Object", 0);
            methodBuilder.getField(localField);
            methodBuilder.swap();
            String string2 = this.getTypeId().getCorrespondingJavaTypeName();
            methodBuilder.dup();
            methodBuilder.isInstanceOf(string2);
            methodBuilder.push(string2);
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", "setObjectForCast", "void", 3);
        }
        methodBuilder.getField(localField);
        if (this.getTypeId().variableLength()) {
            boolean bl = this.getTypeId().isNumericTypeId();
            methodBuilder.dup();
            methodBuilder.push(bl ? this.getTypeServices().getPrecision() : this.getTypeServices().getMaximumWidth());
            methodBuilder.push(this.getTypeServices().getScale());
            methodBuilder.push(!this.sourceCTI.variableLength() || bl || this.assignmentSemantics);
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
        }
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.castOperand != null) {
            this.castOperand = (ValueNode)this.castOperand.accept(visitor);
        }
    }

    void setForExternallyGeneratedCASTnode() {
        this.externallyGeneratedCastNode = true;
    }

    void setForDataTypeFunction(boolean bl) {
        this.forDataTypeFunction = bl;
    }

    void setAssignmentSemantics() {
        this.assignmentSemantics = true;
    }

    protected boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (this.isSameNodeType(valueNode)) {
            CastNode castNode = (CastNode)valueNode;
            return this.getTypeServices().equals(castNode.getTypeServices()) && this.castOperand.isEquivalent(castNode.castOperand);
        }
        return false;
    }
}

