/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.dosgi.dsw.handlers.Chain;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;

public class SecurityDelegatingHttpContext
implements HttpContext {
    private static final Logger LOG = LogUtils.getL7dLogger(SecurityDelegatingHttpContext.class);
    public static final String FILTER_PROP = "org.apache.cxf.httpservice.filter";
    public static final String FILTER_REQUIRED_PROP = "org.apache.cxf.httpservice.requirefilter";
    private static final String FILTER_FILTER = "(org.apache.cxf.httpservice.filter=*)";
    BundleContext bundleContext;
    HttpContext delegate;
    boolean requireFilter;

    public SecurityDelegatingHttpContext(BundleContext bundleContext, HttpContext delegate) {
        this.bundleContext = bundleContext;
        this.delegate = delegate;
        this.requireFilter = Boolean.TRUE.toString().equalsIgnoreCase(bundleContext.getProperty(FILTER_REQUIRED_PROP));
    }

    public String getMimeType(String name) {
        return this.delegate.getMimeType(name);
    }

    public URL getResource(String name) {
        return this.delegate.getResource(name);
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServiceReference[] refs;
        try {
            refs = this.bundleContext.getServiceReferences(Filter.class.getName(), FILTER_FILTER);
        }
        catch (InvalidSyntaxException e) {
            LOG.warning(e.getMessage());
            return false;
        }
        if (refs == null || refs.length == 0) {
            LOG.info("No filter registered.");
            return !this.requireFilter;
        }
        Filter[] filters = new Filter[refs.length];
        for (int i = 0; i < refs.length; ++i) {
            filters[i] = (Filter)this.bundleContext.getService(refs[i]);
        }
        try {
            new Chain(filters).doFilter((ServletRequest)request, (ServletResponse)response);
            return !response.isCommitted();
        }
        catch (ServletException e) {
            LOG.warning(e.getMessage());
            return false;
        }
    }
}

