/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.modeled.details;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.x.async.AsyncCuratorFramework;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.modeled.ModelSpec;
import org.apache.curator.x.async.modeled.ModeledFramework;
import org.apache.curator.x.async.modeled.ZNode;
import org.apache.curator.x.async.modeled.ZPath;
import org.apache.curator.x.async.modeled.cached.CachedModeledFramework;
import org.apache.curator.x.async.modeled.cached.ModeledCache;
import org.apache.curator.x.async.modeled.cached.ModeledCacheListener;
import org.apache.curator.x.async.modeled.details.ModelStage;
import org.apache.curator.x.async.modeled.details.ModeledCacheImpl;
import org.apache.curator.x.async.modeled.details.VersionedModeledFrameworkImpl;
import org.apache.curator.x.async.modeled.versioned.VersionedModeledFramework;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.DataTree;

class CachedModeledFrameworkImpl<T>
implements CachedModeledFramework<T> {
    private final ModeledFramework<T> client;
    private final ModeledCacheImpl<T> cache;
    private final Executor executor;

    CachedModeledFrameworkImpl(ModeledFramework<T> client, ExecutorService executor) {
        this(client, new ModeledCacheImpl<T>(client.unwrap().unwrap(), client.modelSpec(), executor), executor);
    }

    private CachedModeledFrameworkImpl(ModeledFramework<T> client, ModeledCacheImpl<T> cache, Executor executor) {
        this.client = client;
        this.cache = cache;
        this.executor = executor;
    }

    @Override
    public ModeledCache<T> cache() {
        return this.cache;
    }

    @Override
    public void start() {
        this.cache.start();
    }

    @Override
    public void close() {
        this.cache.close();
    }

    @Override
    public Listenable<ModeledCacheListener<T>> listenable() {
        return this.cache.listenable();
    }

    @Override
    public CachedModeledFramework<T> cached() {
        throw new UnsupportedOperationException("Already a cached instance");
    }

    @Override
    public CachedModeledFramework<T> cached(ExecutorService executor) {
        throw new UnsupportedOperationException("Already a cached instance");
    }

    @Override
    public VersionedModeledFramework<T> versioned() {
        return new VersionedModeledFrameworkImpl(this);
    }

    @Override
    public AsyncCuratorFramework unwrap() {
        return this.client.unwrap();
    }

    @Override
    public ModelSpec<T> modelSpec() {
        return this.client.modelSpec();
    }

    @Override
    public CachedModeledFramework<T> child(Object child) {
        return new CachedModeledFrameworkImpl<T>(this.client.child(child), this.cache, this.executor);
    }

    @Override
    public ModeledFramework<T> parent() {
        throw new UnsupportedOperationException("Not supported for CachedModeledFramework. Instead, call parent() on the ModeledFramework before calling cached()");
    }

    @Override
    public CachedModeledFramework<T> withPath(ZPath path) {
        return new CachedModeledFrameworkImpl<T>(this.client.withPath(path), this.cache, this.executor);
    }

    @Override
    public AsyncStage<String> set(T model) {
        return this.client.set(model);
    }

    @Override
    public AsyncStage<String> set(T model, Stat storingStatIn) {
        return this.client.set(model, storingStatIn);
    }

    @Override
    public AsyncStage<String> set(T model, Stat storingStatIn, int version) {
        return this.client.set(model, storingStatIn, version);
    }

    @Override
    public AsyncStage<String> set(T model, int version) {
        return this.client.set(model, version);
    }

    @Override
    public AsyncStage<T> read() {
        return this.internalRead(ZNode::model, this::exceptionally);
    }

    @Override
    public AsyncStage<T> read(Stat storingStatIn) {
        return this.internalRead(n -> {
            if (storingStatIn != null) {
                DataTree.copyStat((Stat)n.stat(), (Stat)storingStatIn);
            }
            return n.model();
        }, this::exceptionally);
    }

    @Override
    public AsyncStage<ZNode<T>> readAsZNode() {
        return this.internalRead(Function.identity(), this::exceptionally);
    }

    @Override
    public AsyncStage<T> readThrough() {
        return this.internalRead(ZNode::model, this.client::read);
    }

    @Override
    public AsyncStage<T> readThrough(Stat storingStatIn) {
        return this.internalRead(ZNode::model, () -> this.client.read(storingStatIn));
    }

    @Override
    public AsyncStage<ZNode<T>> readThroughAsZNode() {
        return this.internalRead(Function.identity(), this.client::readAsZNode);
    }

    @Override
    public AsyncStage<List<T>> list() {
        List children = this.cache.currentChildren().values().stream().map(ZNode::model).collect(Collectors.toList());
        return ModelStage.completed(children);
    }

    @Override
    public AsyncStage<Stat> update(T model) {
        return this.client.update(model);
    }

    @Override
    public AsyncStage<Stat> update(T model, int version) {
        return this.client.update(model, version);
    }

    @Override
    public AsyncStage<Void> delete() {
        return this.client.delete();
    }

    @Override
    public AsyncStage<Void> delete(int version) {
        return this.client.delete(version);
    }

    @Override
    public AsyncStage<Stat> checkExists() {
        ZPath path = this.client.modelSpec().path();
        Optional<ZNode<ZNode>> data = this.cache.currentData(path);
        return data.map(node -> this.completed(node.stat())).orElseGet(() -> this.completed(null));
    }

    @Override
    public AsyncStage<List<ZPath>> children() {
        List paths = this.cache.currentChildren(this.client.modelSpec().path()).keySet().stream().filter(path -> !path.isRoot() && path.parent().equals(this.client.modelSpec().path())).collect(Collectors.toList());
        return this.completed(paths);
    }

    @Override
    public AsyncStage<List<ZNode<T>>> childrenAsZNodes() {
        List nodes = this.cache.currentChildren(this.client.modelSpec().path()).entrySet().stream().filter(e -> !((ZPath)e.getKey()).isRoot() && ((ZPath)e.getKey()).parent().equals(this.client.modelSpec().path())).map(Map.Entry::getValue).collect(Collectors.toList());
        return this.completed(nodes);
    }

    @Override
    public CuratorOp createOp(T model) {
        return this.client.createOp(model);
    }

    @Override
    public CuratorOp updateOp(T model) {
        return this.client.updateOp(model);
    }

    @Override
    public CuratorOp updateOp(T model, int version) {
        return this.client.updateOp(model, version);
    }

    @Override
    public CuratorOp deleteOp() {
        return this.client.deleteOp();
    }

    @Override
    public CuratorOp deleteOp(int version) {
        return this.client.deleteOp(version);
    }

    @Override
    public CuratorOp checkExistsOp() {
        return this.client.checkExistsOp();
    }

    @Override
    public CuratorOp checkExistsOp(int version) {
        return this.client.checkExistsOp(version);
    }

    @Override
    public AsyncStage<List<CuratorTransactionResult>> inTransaction(List<CuratorOp> operations) {
        return this.client.inTransaction(operations);
    }

    private <U> AsyncStage<U> completed(U value) {
        return ModelStage.completed(value);
    }

    private <U> AsyncStage<U> exceptionally() {
        KeeperException.NoNodeException exception = new KeeperException.NoNodeException(this.client.modelSpec().path().fullPath());
        return ModelStage.exceptionally((Exception)exception);
    }

    private <U> AsyncStage<U> internalRead(Function<ZNode<T>, U> resolver, Supplier<AsyncStage<U>> elseProc) {
        ZPath path = this.client.modelSpec().path();
        Optional<ZNode<ZNode>> data = this.cache.currentData(path);
        return data.map(node -> this.completed(resolver.apply((ZNode<T>)node))).orElseGet(elseProc);
    }
}

