/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.modeled;

import java.util.List;
import java.util.Set;
import org.apache.curator.framework.schema.Schema;
import org.apache.curator.shaded.com.google.common.collect.ImmutableSet;
import org.apache.curator.x.async.api.CreateOption;
import org.apache.curator.x.async.api.DeleteOption;
import org.apache.curator.x.async.modeled.ModelSerializer;
import org.apache.curator.x.async.modeled.ModelSpecBuilder;
import org.apache.curator.x.async.modeled.Resolvable;
import org.apache.curator.x.async.modeled.ZPath;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.ACL;

public interface ModelSpec<T>
extends Resolvable {
    public static final Set<CreateOption> defaultCreateOptions = ImmutableSet.of((Object)((Object)CreateOption.createParentsAsContainers), (Object)((Object)CreateOption.setDataIfExists));
    public static final Set<DeleteOption> defaultDeleteOptions = ImmutableSet.of((Object)((Object)DeleteOption.guaranteed));

    public static <T> ModelSpecBuilder<T> builder(ZPath path, ModelSerializer<T> serializer) {
        return new ModelSpecBuilder<T>(path, serializer).withCreateOptions(defaultCreateOptions).withDeleteOptions(defaultDeleteOptions);
    }

    public static <T> ModelSpecBuilder<T> builder(ModelSerializer<T> serializer) {
        return new ModelSpecBuilder<T>(serializer).withCreateOptions(defaultCreateOptions).withDeleteOptions(defaultDeleteOptions);
    }

    public ModelSpec<T> child(Object var1);

    public ModelSpec<T> parent();

    public ModelSpec<T> withPath(ZPath var1);

    @Override
    public ModelSpec<T> resolved(Object ... var1);

    @Override
    public ModelSpec<T> resolved(List<Object> var1);

    public ZPath path();

    public ModelSerializer<T> serializer();

    public CreateMode createMode();

    public List<ACL> aclList();

    public Set<CreateOption> createOptions();

    public Set<DeleteOption> deleteOptions();

    public long ttl();

    public Schema schema();
}

