/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.UnaryOperator;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.details.BackgroundProc;
import org.apache.curator.x.async.details.InternalWatcher;
import org.apache.zookeeper.WatchedEvent;

class InternalCallback<T>
extends CompletableFuture<T>
implements BackgroundCallback,
AsyncStage<T> {
    private final BackgroundProc<T> resultFunction;
    private final InternalWatcher watcher;
    private final UnaryOperator<CuratorEvent> resultFilter;

    InternalCallback(BackgroundProc<T> resultFunction, InternalWatcher watcher, UnaryOperator<CuratorEvent> resultFilter) {
        this.resultFunction = resultFunction;
        this.watcher = watcher;
        this.resultFilter = resultFilter;
    }

    @Override
    public CompletionStage<WatchedEvent> event() {
        return this.watcher != null ? this.watcher.getFuture() : null;
    }

    public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
        event = this.resultFilter != null ? (CuratorEvent)this.resultFilter.apply(event) : event;
        this.resultFunction.apply(event, this);
    }
}

