/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.SetDataBuilderImpl;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.api.AsyncPathAndBytesable;
import org.apache.curator.x.async.api.AsyncSetDataBuilder;
import org.apache.curator.x.async.details.BackgroundProcs;
import org.apache.curator.x.async.details.BuilderCommon;
import org.apache.curator.x.async.details.Filters;
import org.apache.zookeeper.data.Stat;

class AsyncSetDataBuilderImpl
implements AsyncSetDataBuilder {
    private final CuratorFrameworkImpl client;
    private final Filters filters;
    private boolean compressed = false;
    private int version = -1;

    AsyncSetDataBuilderImpl(CuratorFrameworkImpl client, Filters filters) {
        this.client = client;
        this.filters = filters;
    }

    @Override
    public AsyncStage<Stat> forPath(String path) {
        return this.internalForPath(path, null, false);
    }

    @Override
    public AsyncStage<Stat> forPath(String path, byte[] data) {
        return this.internalForPath(path, data, true);
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<Stat>> compressed() {
        this.compressed = true;
        return this;
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<Stat>> compressedWithVersion(int version) {
        this.compressed = true;
        this.version = version;
        return this;
    }

    @Override
    public AsyncPathAndBytesable<AsyncStage<Stat>> withVersion(int version) {
        this.version = version;
        return this;
    }

    private AsyncStage<Stat> internalForPath(String path, byte[] data, boolean useData) {
        BuilderCommon<Stat> common = new BuilderCommon<Stat>(this.filters, BackgroundProcs.statProc);
        SetDataBuilderImpl builder = new SetDataBuilderImpl(this.client, common.backgrounding, this.version, this.compressed);
        return BackgroundProcs.safeCall(common.internalCallback, () -> useData ? builder.forPath(path, data) : builder.forPath(path));
    }
}

