/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.ExistsBuilderImpl;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.WatchMode;
import org.apache.curator.x.async.api.AsyncExistsBuilder;
import org.apache.curator.x.async.api.AsyncPathable;
import org.apache.curator.x.async.api.ExistsOption;
import org.apache.curator.x.async.details.BackgroundProcs;
import org.apache.curator.x.async.details.BuilderCommon;
import org.apache.curator.x.async.details.Filters;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

class AsyncExistsBuilderImpl
implements AsyncExistsBuilder {
    private final CuratorFrameworkImpl client;
    private final Filters filters;
    private final WatchMode watchMode;
    private Set<ExistsOption> options = Collections.emptySet();

    AsyncExistsBuilderImpl(CuratorFrameworkImpl client, Filters filters, WatchMode watchMode) {
        this.client = client;
        this.filters = filters;
        this.watchMode = watchMode;
    }

    @Override
    public AsyncPathable<AsyncStage<Stat>> withOptions(Set<ExistsOption> options) {
        this.options = Objects.requireNonNull(options, "options cannot be null");
        return this;
    }

    @Override
    public AsyncStage<Stat> forPath(String path) {
        BuilderCommon<Stat> common = new BuilderCommon<Stat>(this.filters, this.watchMode, BackgroundProcs.safeStatProc);
        ExistsBuilderImpl builder = new ExistsBuilderImpl(this.client, common.backgrounding, (Watcher)common.watcher, this.options.contains((Object)ExistsOption.createParentsIfNeeded), this.options.contains((Object)ExistsOption.createParentsAsContainers));
        return BackgroundProcs.safeCall(common.internalCallback, () -> builder.forPath(path));
    }
}

