/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.constant.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.language.constant.ConstantLanguage;
import org.apache.camel.language.constant.springboot.ConstantLanguageConfiguration;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.LanguageConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={LanguageConfigurationProperties.class, ConstantLanguageConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.language", "camel.language.constant"})
public class ConstantLanguageAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private ConstantLanguageConfiguration configuration;

    public ConstantLanguageAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public LanguageCustomizer configureConstantLanguage() {
        return new LanguageCustomizer(){

            public void configure(String name, Language target) {
                CamelPropertiesHelper.copyProperties((CamelContext)ConstantLanguageAutoConfiguration.this.camelContext, (Object)((Object)ConstantLanguageAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Language target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)ConstantLanguageAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.language.customizer", "camel.language.constant.customizer"}) && target instanceof ConstantLanguage;
            }
        };
    }
}

