/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import org.apache.calcite.avatica.remote.AbstractHandler;
import org.apache.calcite.avatica.remote.Handler;
import org.apache.calcite.avatica.remote.JsonService;
import org.apache.calcite.avatica.remote.Service;

public class JsonHandler
extends AbstractHandler<String> {
    protected static final ObjectMapper MAPPER = JsonService.MAPPER;

    public JsonHandler(Service service) {
        super(service);
    }

    @Override
    public Handler.HandlerResponse<String> apply(String jsonRequest) {
        return super.apply(jsonRequest);
    }

    @Override
    Service.Request decode(String request) throws IOException {
        return MAPPER.readValue(request, Service.Request.class);
    }

    @Override
    String encode(Service.Response response) throws IOException {
        StringWriter w = new StringWriter();
        MAPPER.writeValue(w, (Object)response);
        return w.toString();
    }
}

