/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.ant.antunit.AntUnitExecutionNotifier;
import org.apache.ant.antunit.AssertionFailedException;
import org.apache.ant.antunit.LogCapturer;
import org.apache.ant.antunit.ProjectFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class AntUnitScriptRunner {
    private static final String SETUP = "setUp";
    private static final String TEST = "test";
    private static final String TEARDOWN = "tearDown";
    private static final String SUITESETUP = "suiteSetUp";
    private static final String SUITETEARDOWN = "suiteTearDown";
    private final ProjectFactory prjFactory;
    private boolean isSuiteStarted;
    private final boolean hasSetUp;
    private final boolean hasTearDown;
    private final boolean hasSuiteSetUp;
    private final boolean hasSuiteTearDown;
    private final List testTargets;
    private Project project = null;
    private boolean projectIsDirty;

    public AntUnitScriptRunner(ProjectFactory prjFactory) throws BuildException {
        this.prjFactory = prjFactory;
        Project newProject = this.getCurrentProject();
        Hashtable targets = newProject.getTargets();
        this.hasSetUp = targets.containsKey(SETUP);
        this.hasTearDown = targets.containsKey(TEARDOWN);
        this.hasSuiteSetUp = targets.containsKey(SUITESETUP);
        this.hasSuiteTearDown = targets.containsKey(SUITETEARDOWN);
        this.testTargets = new LinkedList();
        Iterator it = targets.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!name.startsWith(TEST) || name.equals(TEST)) continue;
            this.testTargets.add(name);
        }
    }

    public final Project getCurrentProject() throws BuildException {
        if (this.project == null) {
            this.project = this.prjFactory.createProject();
            this.projectIsDirty = false;
        }
        return this.project;
    }

    private Project getCleanProject() {
        if (this.project == null || this.projectIsDirty) {
            this.project = this.prjFactory.createProject();
        }
        this.projectIsDirty = true;
        return this.project;
    }

    public List getTestTartgets() {
        return this.testTargets;
    }

    public String getName() {
        return this.getCurrentProject().getName();
    }

    private boolean startSuite(AntUnitExecutionNotifier notifier) {
        this.getCurrentProject().fireBuildStarted();
        if (this.hasSuiteSetUp) {
            try {
                Project newProject = this.getCleanProject();
                newProject.executeTarget(SUITESETUP);
            }
            catch (BuildException e) {
                notifier.fireStartTest(SUITESETUP);
                this.fireFailOrError(SUITESETUP, e, notifier);
                return false;
            }
        }
        this.isSuiteStarted = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTarget(String name, AntUnitExecutionNotifier notifier) {
        if (!this.isSuiteStarted) {
            throw new AssertionError();
        }
        Project newProject = this.getCleanProject();
        Vector<String> v = new Vector<String>();
        if (this.hasSetUp) {
            v.add(SETUP);
        }
        v.add(name);
        LogCapturer lc = new LogCapturer(newProject);
        try {
            notifier.fireStartTest(name);
            newProject.executeTargets(v);
        }
        catch (BuildException e) {
            this.fireFailOrError(name, e, notifier);
        }
        finally {
            notifier.fireEndTest(name);
            if (this.hasTearDown) {
                try {
                    newProject.executeTarget(TEARDOWN);
                }
                catch (BuildException e) {
                    this.fireFailOrError(name, e, notifier);
                }
            }
        }
    }

    private void endSuite(Throwable caught, AntUnitExecutionNotifier notifier) {
        if (this.hasSuiteTearDown) {
            try {
                Project newProject = this.getCleanProject();
                newProject.executeTarget(SUITETEARDOWN);
            }
            catch (BuildException e) {
                notifier.fireStartTest(SUITETEARDOWN);
                this.fireFailOrError(SUITETEARDOWN, e, notifier);
            }
        }
        this.getCurrentProject().fireBuildFinished(caught);
        this.isSuiteStarted = false;
    }

    private void fireFailOrError(String targetName, BuildException e, AntUnitExecutionNotifier notifier) {
        boolean failed = false;
        for (Throwable t = e; t != null && t instanceof BuildException; t = t.getCause()) {
            if (!(t instanceof AssertionFailedException)) continue;
            failed = true;
            notifier.fireFail(targetName, (AssertionFailedException)((Object)t));
            break;
        }
        if (!failed) {
            notifier.fireError(targetName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSuite(List suiteTargets, AntUnitExecutionNotifier notifier) {
        Throwable caught = null;
        try {
            if (!this.startSuite(notifier)) {
                return;
            }
            Iterator iter = suiteTargets.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                this.runTarget(name, notifier);
            }
        }
        catch (Throwable e) {
            caught = e;
        }
        finally {
            this.endSuite(caught, notifier);
        }
    }
}

