/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.logging;

import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;

public class JDKLogImpl
implements Log {
    protected final Logger logger;
    private static final String THIS_CLASS_NAME = JDKLogImpl.class.getName();

    public JDKLogImpl(String category) {
        this.logger = Logger.getLogger(category);
    }

    public JDKLogImpl(Class category) {
        this.logger = Logger.getLogger(category.getName());
    }

    private void log(Level lv, String msg) {
        this.log(lv, msg, null);
    }

    private void log(Level lv, String msg, Throwable e) {
        if (this.logger.isLoggable(lv)) {
            LogRecord r = new LogRecord(lv, msg);
            r.setThrown(e);
            for (StackTraceElement frame : new Exception().getStackTrace()) {
                if (frame.getClassName().equals(THIS_CLASS_NAME)) continue;
                r.setSourceClassName(frame.getClassName());
                r.setSourceMethodName(frame.getMethodName());
                break;
            }
            this.logger.log(r);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void trace(String msg) {
        this.log(Level.FINER, msg);
    }

    @Override
    public void trace(String msg, Object ... args) {
        if (this.isTraceEnabled()) {
            this.log(Level.FINER, this.format(msg, args));
        }
    }

    @Override
    public void trace(Object msg) {
        this.log(Level.FINER, msg.toString());
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.log(Level.FINER, msg, t);
    }

    @Override
    public void debug(String msg) {
        this.log(Level.FINE, msg);
    }

    @Override
    public void debug(String msg, Object ... args) {
        if (this.isDebugEnabled()) {
            this.log(Level.FINE, this.format(msg, args));
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log(Level.FINE, msg, t);
    }

    @Override
    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    @Override
    public void info(String msg, Object ... args) {
        if (this.isInfoEnabled()) {
            this.log(Level.INFO, this.format(msg, args));
        }
    }

    @Override
    public void warn(String msg) {
        this.log(Level.WARNING, msg);
    }

    @Override
    public void warn(String msg, Object ... args) {
        if (this.isWarnEnabled()) {
            this.log(Level.WARNING, this.format(msg, args));
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.log(Level.WARNING, msg, t);
    }

    @Override
    public void error(String msg) {
        this.log(Level.SEVERE, msg);
    }

    @Override
    public void error(String format, Object ... args) {
        if (this.isErrorEnabled()) {
            this.log(Level.SEVERE, this.format(format, args));
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log(Level.SEVERE, msg, t);
    }

    @Override
    public void fatal(String msg) {
        this.log(Level.SEVERE, msg);
    }

    @Override
    public void fatal(String msg, Object ... args) {
        if (this.isFatalEnabled()) {
            this.log(Level.SEVERE, this.format(msg, args));
        }
    }

    @Override
    public void fatal(String msg, Throwable t) {
        this.log(Level.SEVERE, msg, t);
    }

    @Override
    public String getLevel() {
        Level level = this.logger.getLevel();
        return level != null ? level.toString() : "off";
    }

    @Override
    public void setLevel(String level) {
        Level new_level = JDKLogImpl.strToLevel(level);
        if (new_level != null) {
            this.logger.setLevel(new_level);
        }
    }

    protected String format(String format, Object ... args) {
        try {
            return String.format(format, args);
        }
        catch (IllegalFormatException ex) {
            this.error("Illegal format string \"" + format + "\", args=" + Arrays.toString(args));
        }
        catch (Throwable t) {
            this.error("Failure formatting string: format string=" + format + ", args=" + Arrays.toString(args));
        }
        return format;
    }

    protected static Level strToLevel(String level) {
        if (level == null) {
            return null;
        }
        if ((level = level.toLowerCase().trim()).equals("fatal")) {
            return Level.SEVERE;
        }
        if (level.equals("error")) {
            return Level.SEVERE;
        }
        if (level.equals("warn")) {
            return Level.WARNING;
        }
        if (level.equals("warning")) {
            return Level.WARNING;
        }
        if (level.equals("info")) {
            return Level.INFO;
        }
        if (level.equals("debug")) {
            return Level.FINE;
        }
        if (level.equals("trace")) {
            return Level.FINER;
        }
        return null;
    }
}

