/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.postgresql;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.anyline.adapter.DataWriter;
import org.anyline.data.jdbc.postgresql.PostgresqlGeometryAdapter;
import org.anyline.entity.geometry.Box;
import org.anyline.entity.geometry.Circle;
import org.anyline.entity.geometry.Line;
import org.anyline.entity.geometry.LineSegment;
import org.anyline.entity.geometry.LineString;
import org.anyline.entity.geometry.Point;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.metadata.type.init.StandardTypeMetadata;
import org.anyline.proxy.ConvertProxy;
import org.anyline.util.DateUtil;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;

public enum PostgresqlWriter {
    DateWriter(new Object[]{Date.class, LocalDate.class}, new DataWriter(){

        public Object write(Object value, Boolean placeholder, Boolean unicode, TypeMetadata type) {
            if (!placeholder.booleanValue() && null != value) {
                java.util.Date date = (java.util.Date)ConvertProxy.convert((Object)value, java.util.Date.class, (boolean)false);
                value = " to_date( '" + DateUtil.format((java.util.Date)date) + "', 'YYYY-MM-DD')";
            }
            return value;
        }
    }),
    DateTimeWriter(new Object[]{Timestamp.class, java.util.Date.class, LocalDateTime.class}, new DataWriter(){

        public Object write(Object value, Boolean placeholder, Boolean unicode, TypeMetadata type) {
            if (!placeholder.booleanValue() && null != value) {
                java.util.Date date = (java.util.Date)ConvertProxy.convert((Object)value, java.util.Date.class, (boolean)false);
                value = " to_timestamp( '" + DateUtil.format((java.util.Date)date) + "', 'YYYY-MM-DD HH24:MI:SS')";
            }
            return value;
        }
    }),
    PointWriter(new Object[]{Point.class, StandardTypeMetadata.POINT}, new DataWriter(){

        public Object write(Object value, Boolean placeholder, Boolean unicode, TypeMetadata type) {
            if (value instanceof Point) {
                Point point = (Point)value;
                PGpoint pg = PostgresqlGeometryAdapter.convert(point);
                if (placeholder.booleanValue()) {
                    return pg;
                }
                return point.toString(true);
            }
            return value;
        }
    }),
    LineSegmentWriter(new Object[]{LineSegment.class, StandardTypeMetadata.LSEG}, new DataWriter(){

        public Object write(Object value, Boolean placeholder, Boolean unicode, TypeMetadata type) {
            if (value instanceof LineSegment) {
                LineSegment segment = (LineSegment)value;
                PGlseg pg = PostgresqlGeometryAdapter.convert(segment);
                if (placeholder.booleanValue()) {
                    return pg;
                }
                return segment.toString(true);
            }
            return value;
        }
    }),
    PathWriter(new Object[]{LineString.class, StandardTypeMetadata.PATH}, new DataWriter(){

        public Object write(Object value, Boolean placeholder, Boolean unicode, TypeMetadata type) {
            if (value instanceof LineString) {
                LineString string = (LineString)value;
                PGpath pg = PostgresqlGeometryAdapter.convert(string);
                if (placeholder.booleanValue()) {
                    return pg;
                }
                return string.toString(true);
            }
            return value;
        }
    }),
    LineWriter(new Object[]{Line.class, StandardTypeMetadata.LINE}, new DataWriter(){

        public Object write(Object value, Boolean placeholder, Boolean unicode, TypeMetadata type) {
            if (value instanceof Line) {
                Line line = (Line)value;
                PGline pg = PostgresqlGeometryAdapter.convert(line);
                if (placeholder.booleanValue()) {
                    return pg;
                }
                return line.toString(true);
            }
            return value;
        }
    }),
    BoxWriter(new Object[]{Box.class, StandardTypeMetadata.BOX}, new DataWriter(){

        public Object write(Object value, Boolean placeholder, Boolean unicode, TypeMetadata type) {
            if (value instanceof Box) {
                Box box = (Box)value;
                PGbox pg = PostgresqlGeometryAdapter.convert(box);
                if (placeholder.booleanValue()) {
                    return pg;
                }
                return box.toString(true);
            }
            return value;
        }
    }),
    CircleWriter(new Object[]{Circle.class, StandardTypeMetadata.CIRCLE}, new DataWriter(){

        public Object write(Object value, Boolean placeholder, Boolean unicode, TypeMetadata type) {
            if (value instanceof Circle) {
                Circle circle = (Circle)value;
                PGcircle pg = PostgresqlGeometryAdapter.convert(circle);
                if (placeholder.booleanValue()) {
                    return pg;
                }
                return circle.toString(true);
            }
            return value;
        }
    });

    private final Object[] supports;
    private final DataWriter writer;

    public Object[] supports() {
        return this.supports;
    }

    public DataWriter writer() {
        return this.writer;
    }

    private PostgresqlWriter(Object[] supports, DataWriter writer) {
        this.supports = supports;
        this.writer = writer;
    }
}

