/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util.regular;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularContain;
import org.anyline.util.regular.RegularMatch;
import org.anyline.util.regular.RegularMatchPrefix;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class RegularUtil {
    private static Regular regular;
    public static Regular regularMatch;
    public static Regular regularMatchPrefix;
    public static Regular regularContain;
    private static final Map<Regular.MATCH_MODE, Regular> regularList;
    public static final String REGEX_VARIABLE = "${(\\w+)}";
    public static final String TAG_BEGIN = "${begin}";
    public static final String TAG_END = "${end}";
    private static final Log log;

    public static synchronized boolean match(String src, String regx, Regular.MATCH_MODE mode) {
        boolean result = false;
        if (null == src || null == regx) {
            return result;
        }
        regular = regularList.get((Object)mode);
        try {
            result = regular.match(src, regx);
        }
        catch (Exception e) {
            log.warn("[match(src, regx, mode) error][src:{}][regx:{}][mode:{}]", new Object[]{src, regx, mode});
            e.printStackTrace();
        }
        return result;
    }

    public static boolean match(String src, String regx) {
        return RegularUtil.match(src, regx, Regular.MATCH_MODE.CONTAIN);
    }

    public static synchronized List<List<String>> fetchs(String src, String regx, Regular.MATCH_MODE mode) throws Exception {
        List<List<String>> result = null;
        if (null != src) {
            regular = regularList.get((Object)mode);
            result = regular.fetchs(src, regx);
        }
        return result;
    }

    public static List<List<String>> fetchs(String src, String regx) throws Exception {
        return RegularUtil.fetchs(src, regx, Regular.MATCH_MODE.CONTAIN);
    }

    public static List<String> fetch(String src, String regx) throws Exception {
        return RegularUtil.fetch(src, regx, Regular.MATCH_MODE.CONTAIN);
    }

    public static synchronized List<String> fetch(String src, String regx, Regular.MATCH_MODE mode, int idx) throws Exception {
        List<String> result = null;
        if (null != src) {
            regular = regularList.get((Object)mode);
            result = regular.fetch(src, regx, idx);
        }
        return result;
    }

    public static synchronized List<String> fetch(String src, String regx, Regular.MATCH_MODE mode) throws Exception {
        List<String> result = null;
        if (null != src) {
            regular = regularList.get((Object)mode);
            result = regular.fetch(src, regx);
        }
        return result;
    }

    public static List<String> filter(List<String> src, String regx, Regular.MATCH_MODE mode, Regular.FILTER_TYPE type) {
        if (Regular.FILTER_TYPE.PICK == type) {
            return RegularUtil.pick(src, regx, mode);
        }
        if (Regular.FILTER_TYPE.WIPE == type) {
            return RegularUtil.wipe(src, regx, mode);
        }
        return new ArrayList<String>();
    }

    public static synchronized List<String> pick(List<String> src, String regx, Regular.MATCH_MODE mode) {
        regular = regularList.get((Object)mode);
        return regular.pick(src, regx);
    }

    public static synchronized List<String> wipe(List<String> src, String regx, Regular.MATCH_MODE mode) {
        regular = regularList.get((Object)mode);
        return regular.wipe(src, regx);
    }

    public static int indexOf(String src, String regx, int begin) {
        int idx = -1;
        try {
            Perl5Compiler patternCompiler = new Perl5Compiler();
            Pattern pattern = patternCompiler.compile(regx, 1);
            Perl5Matcher matcher = new Perl5Matcher();
            PatternMatcherInput input = new PatternMatcherInput(src);
            while (matcher.contains(input, pattern)) {
                MatchResult matchResult = matcher.getMatch();
                int tmp = matchResult.beginOffset(0);
                if (tmp < begin) continue;
                idx = tmp;
                break;
            }
        }
        catch (Exception e) {
            log.error("[\u63d0\u53d6\u5f02\u5e38][src:{}][regx:{}]", (Object)src, (Object)regx);
            e.printStackTrace();
        }
        return idx;
    }

    public static int indexOf(String src, String regx) {
        return RegularUtil.indexOf(src, regx, 0);
    }

    public static List<String> regexpValue(String src, String regex, Regular.MATCH_MODE mode) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List<List<String>> rs = RegularUtil.fetchs(src, regex, mode);
            for (List<String> row : rs) {
                result.add(row.get(0));
            }
        }
        catch (Exception e) {
            log.error("[\u63d0\u53d6\u5f02\u5e38][src:{}][reg:{}][mode:{}]", new Object[]{src, regex, mode});
            e.printStackTrace();
        }
        return result;
    }

    public static String removeTagWithBodyByAttribute(String src, String attribute) {
        if (null == src || null == attribute) {
            return src;
        }
        Object reg = "";
        reg = "<([\\w-]+)[^>]*?\\s" + attribute + "\\b[^>]*?>[^>]*?</\\1>";
        src = src.replaceAll((String)reg, "");
        reg = "<[\\w-]+[^>]*?\\s" + attribute + "\\b[^>]*?(>|(/>))";
        src = src.replaceAll((String)reg, "");
        return src;
    }

    public static String removeTagWithBodyByAttributeValue(String src, String attribute, String value) {
        if (null == src || null == attribute || null == value) {
            return src;
        }
        Object reg = "";
        reg = "<([\\w-]+)[^>]*?\\s" + attribute + "\\b[\\s]*=[\\s]*(['\"])[^>]*?\\b" + value + "\\b[^>]*?\\2[^>]*?>[^>]*?</\\1>";
        src = src.replaceAll((String)reg, "");
        reg = "<([\\w-]+)[^>]*?\\s" + attribute + "\\b[\\s]*=[\\s]*(['\"])[^>]*?\\b" + value + "\\b[^>]*?\\2[^>]*?/>";
        src = src.replaceAll((String)reg, "");
        return src;
    }

    public static String removeTagByAttributeValue(String src, String attribute, String value) throws Exception {
        if (null == src || null == attribute || null == value) {
            return src;
        }
        List<List<String>> lists = RegularUtil.getTagWithBodyByAttributeValue(src, attribute, value);
        for (List<String> list : lists) {
            String all = list.get(0);
            String body = list.get(3);
            src = src.replace(all, body);
        }
        return src;
    }

    public static String removeTagByAttribute(String src, String attribute) throws Exception {
        if (null == src || null == attribute) {
            return src;
        }
        List<List<String>> lists = RegularUtil.getTagWithBodyByAttribute(src, attribute);
        for (List<String> list : lists) {
            String all = list.get(0);
            String body = list.get(3);
            src = src.replace(all, body);
        }
        return src;
    }

    public static List<List<String>> getTagWithBodyByAttribute(String src, String attribute) throws Exception {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        String reg = "(<([\\w-]+)[^>]*?\\s" + attribute + "\\b[^>]*?>[^>]*?</\\1>)|(<([\\w-]+)[^>]*?\\s" + attribute + "\\b[^>]*?(>|(/>)))";
        Regular regular = regularList.get((Object)Regular.MATCH_MODE.CONTAIN);
        List<List<String>> list = regular.fetchs(src, reg);
        int idx = 0;
        for (List<String> tmp : list) {
            ArrayList<Object> item = new ArrayList<Object>();
            String start = tmp.get(0);
            Object all = null;
            String body = null;
            String end = null;
            String name = tmp.get(4);
            idx = src.indexOf(start, idx);
            if (!start.endsWith("/>")) {
                end = "</" + name + ">";
                int fr = idx + start.length();
                int to = src.indexOf(end, idx + start.length());
                if (to > fr && (body = src.substring(fr, to)).contains(end)) {
                    body = null;
                }
                if (null == body) {
                    end = null;
                    all = start;
                } else {
                    all = start + body + end;
                }
            } else {
                all = start;
            }
            item.add(all);
            item.add(start);
            item.add(end);
            item.add(body);
            item.add(name);
            result.add(item);
        }
        return result;
    }

    public static List<List<String>> getTagWithBodyByAttributeValue(String src, String attribute, String value) throws Exception {
        ArrayList<Object> item;
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        Regular regular = regularList.get((Object)Regular.MATCH_MODE.CONTAIN);
        String reg = "<([\\w-]+)[^>]*?\\s" + attribute + "\\b[\\s]*=[\\s]*(['\"])[^>]*?\\b" + value + "\\b[^>]*?\\2[^>]*?>[^>]*?</\\1>";
        List<List<String>> list = regular.fetchs(src, reg);
        boolean idx = false;
        for (List<String> tmp : list) {
            item = new ArrayList<Object>();
            String all = tmp.get(0);
            String name = tmp.get(1);
            String start = all.substring(0, all.indexOf(">") + 1);
            String end = "</" + name + ">";
            String body = RegularUtil.cut(all, start, end);
            item.add(all);
            item.add(start);
            item.add(end);
            item.add(body);
            item.add(name);
            result.add(item);
        }
        reg = "<([\\w-]+)[^>]*?\\s" + attribute + "\\b[\\s]*=[\\s]*(['\"])[^>]*?\\b" + value + "\\b[^>]*?\\2[^>]*?/>";
        list = regular.fetchs(src, reg);
        for (List<String> tmp : list) {
            item = new ArrayList();
            item.add(tmp.get(0));
            item.add(tmp.get(0));
            item.add(null);
            item.add(null);
            item.add(tmp.get(1));
            result.add(item);
        }
        return result;
    }

    public static String removeTagExcept(String src, String ... tags) {
        if (null == src || null == tags || tags.length == 0) {
            return src;
        }
        int size = tags.length;
        Object reg = "(?i)<(?!(\\!";
        for (int i = 0; i < size; ++i) {
            reg = (String)reg + "|";
            reg = (String)reg + "(/?\\s?" + tags[i] + "\\b)";
        }
        reg = (String)reg + "))[^>]+>";
        src = src.replaceAll((String)reg, "");
        return src;
    }

    public static String removeHtmlTagExcept(String src, String ... tags) {
        return RegularUtil.removeTagExcept(src, tags);
    }

    public static String removeTag(String src, String ... tags) {
        if (null == src) {
            return src;
        }
        if (null == tags || tags.length == 0) {
            src = src.replaceAll(Regular.PATTERN.HTML_TAG.getCode(), "");
        } else {
            for (String tag : tags) {
                String reg = "(?i)<" + tag + "[^>]*>.*?|</" + tag + ">";
                src = src.replaceAll(reg, "");
            }
        }
        return src;
    }

    public static String removeHtmlTag(String src, String ... tags) {
        return RegularUtil.removeTag(src, tags);
    }

    public static String removeTagWithBody(String src, String ... tags) {
        if (null == src) {
            return src;
        }
        if (null == tags || tags.length == 0) {
            src = src.replaceAll(Regular.PATTERN.HTML_TAG_WITH_BODY.getCode(), "");
        } else {
            for (String tag : tags) {
                String reg = "(?i)<" + tag + "[^>]*>[\\s\\S]*?</" + tag + ">";
                src = src.replaceAll(reg, "");
            }
        }
        return src;
    }

    public static String removeHtmlTagWithBody(String src, String ... tags) {
        return RegularUtil.removeTagWithBody(src, tags);
    }

    public static String removeEmptyTag(String src) {
        if (null == src) {
            return src;
        }
        String reg = "(?i)(<(\\w+)[^<]*?>)\\s*(</\\2>)";
        src = src.replaceAll(reg, "");
        return src;
    }

    public static String removeHtmlEmptyTag(String src) {
        return RegularUtil.removeEmptyTag(src);
    }

    public static String removeHtmlTagExceptSimple(String src) {
        return RegularUtil.removeHtmlTagExcept(src, "br", "b", "strong", "u", "i", "pre", "ul", "li", "p");
    }

    public static String removeAttribute(String src, String ... attributes) {
        if (null == src) {
            return src;
        }
        Object reg = null;
        if (null != attributes && attributes.length > 0) {
            for (String attribute : attributes) {
                reg = attribute + "\\s*=\\s*\"[\\s\\S]*\"";
                src = src.replaceAll((String)reg, "");
                reg = attribute + "\\s*=\\s*'[\\s\\S]*'";
                src = src.replaceAll((String)reg, "");
                src = src.replaceAll("\\s+>", ">");
            }
        } else {
            reg = "\\S+?\\s*?=\\s*?\"[\\s\\S]*?\"";
            src = src.replaceAll((String)reg, "");
            reg = "\\S+?\\s*?=\\s*?'[\\s\\S]*?'";
            src = src.replaceAll((String)reg, "");
            src = src.replaceAll("\\s+?>", ">");
        }
        return src;
    }

    public static List<String> fetchUrls(String src) throws Exception {
        List<String> urls = null;
        urls = RegularUtil.fetch(src, Regular.PATTERN.HTML_TAG_A.getCode(), Regular.MATCH_MODE.CONTAIN, 4);
        return urls;
    }

    public static String fetchUrl(String src) throws Exception {
        List<String> urls = RegularUtil.fetchUrls(src);
        if (null != urls && !urls.isEmpty()) {
            return urls.get(0);
        }
        return null;
    }

    public static List<String> fetchNumbers(String src) throws Exception {
        List<String> numbers = null;
        numbers = RegularUtil.fetch(src, "(\\-|\\+)?\\d+(\\.\\d+)?", Regular.MATCH_MODE.CONTAIN, 0);
        return numbers;
    }

    public static String fetchNumber(String src) throws Exception {
        List<String> numbers = RegularUtil.fetchNumbers(src);
        if (null != numbers && !numbers.isEmpty()) {
            return numbers.get(0);
        }
        return null;
    }

    public static List<List<String>> fetchPairedTag(String txt, String ... tags) throws Exception {
        List<List<String>> result = new ArrayList<List<String>>();
        if (null != tags && tags.length > 0) {
            Object tagNames = "";
            int size = tags.length;
            for (int i = 0; i < size; ++i) {
                tagNames = i == 0 ? (String)tagNames + tags[i] : (String)tagNames + "|" + tags[i];
            }
            String regx = "(?i)(<(" + (String)tagNames + ")[^<]*?>)([\\s\\S]*?)(</\\2>)";
            result = RegularUtil.fetchs(txt, regx);
        }
        return result;
    }

    public static List<List<String>> fetchSingleTag(String txt, String ... tags) throws Exception {
        List<List<String>> result = new ArrayList<List<String>>();
        if (null != tags && tags.length > 0) {
            Object tagNames = "";
            int size = tags.length;
            for (int i = 0; i < size; ++i) {
                tagNames = i == 0 ? (String)tagNames + tags[i] : (String)tagNames + "|" + tags[i];
            }
            String regx = "(?i)<(" + (String)tagNames + ")[\\s\\S]*?>";
            result = RegularUtil.fetchs(txt, regx);
        }
        return result;
    }

    public static List<String> fetchOutPairedTag(String txt) {
        String name;
        int index;
        ArrayList<String> tags = new ArrayList<String>();
        while ((index = txt.indexOf("<")) != -1 && !BasicUtil.isEmpty((Object)(name = RegularUtil.cut(txt, "<", ">")))) {
            String tmp;
            if (name.contains(" ")) {
                name = name.split(" ")[0];
            }
            String head = "<" + name;
            String foot = "</" + name + ">";
            String foot2 = "/>";
            int begin = txt.indexOf(head);
            int end = txt.indexOf(foot);
            int end2 = txt.indexOf(foot2);
            int fr = begin;
            int to = end;
            while (to >= 0 && (tmp = txt.substring(fr + head.length(), to)).contains(head)) {
                fr = txt.indexOf(head, fr + 1);
                end = to = txt.indexOf(foot, to + 1);
            }
            if (end < 0) break;
            String tag = txt.substring(begin, end + foot.length());
            tags.add(tag);
            txt = txt.substring(txt.indexOf(tag) + tag.length());
        }
        return tags;
    }

    public static List<String> fetchOutTag(String txt) {
        return RegularUtil.fetchOutTag(txt, "");
    }

    public static List<String> fetchOutTag(String txt, String namespace) {
        String name;
        int index;
        Object prefix = "";
        if (BasicUtil.isNotEmpty(namespace)) {
            prefix = namespace + ":";
        }
        ArrayList<String> tags = new ArrayList<String>();
        while ((index = txt.indexOf("<" + (String)prefix)) != -1 && !BasicUtil.isEmpty((Object)(name = RegularUtil.cut(txt, "<" + (String)prefix, ">")))) {
            if (name.contains(" ")) {
                name = name.split(" ")[0];
            }
            String head = "<" + (String)prefix + name;
            String foot_d = "</" + (String)prefix + name + ">";
            String foot_s = "/>";
            int begin = txt.indexOf(head);
            int end_d = txt.indexOf(foot_d, begin);
            int end_s = txt.indexOf(foot_s, begin);
            int end = end_d;
            Object foot = foot_d;
            boolean paired = true;
            if (end_s != -1) {
                String chk_s = txt.substring(begin, end_s).replace("\"", "'").replace("\u201d", "'").replace("\u2018", "'");
                if (!chk_s.contains(">")) {
                    end = end_s;
                    foot = foot_s;
                    paired = false;
                } else if (BasicUtil.charCount(chk_s = chk_s.substring(0, chk_s.lastIndexOf(">")), "'") % 2 == 1) {
                    end = end_s;
                    foot = foot_s;
                    paired = false;
                }
            }
            int fr = begin;
            int to = end;
            if (paired) {
                String tmp;
                while (to >= 0 && (tmp = txt.substring(fr + head.length(), to)).contains(head)) {
                    fr = txt.indexOf(head, fr + 1);
                    end = to = txt.indexOf(foot_d, to + 1);
                }
            }
            if (end < 0) break;
            String tag = txt.substring(begin, end + ((String)foot).length());
            tags.add(tag);
            txt = txt.substring(txt.indexOf(tag) + tag.length());
        }
        return tags;
    }

    public static List<List<String>> fetchAllTag(String txt, String ... tags) throws Exception {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        List<Object> items = new ArrayList();
        if (null != tags && tags.length > 0) {
            Object names = "";
            int size = tags.length;
            for (int i = 0; i < size; ++i) {
                names = i == 0 ? (String)names + tags[i] : (String)names + "|" + tags[i];
            }
            String regx = "(?i)((<(" + (String)names + ")\\s[^<]*?>)([\\s\\S]*?)(</\\3>))|(<(" + (String)names + ")\\s[\\s\\S]*?>)";
            items = RegularUtil.fetchs(txt, regx);
            for (List list : items) {
                ArrayList<String> rtn = new ArrayList<String>();
                if (null == list.get(7)) {
                    rtn.add((String)list.get(0));
                    rtn.add((String)list.get(2));
                    rtn.add((String)list.get(3));
                    rtn.add((String)list.get(4));
                    rtn.add((String)list.get(5));
                } else {
                    rtn.add((String)list.get(0));
                    rtn.add((String)list.get(0));
                    rtn.add((String)list.get(7));
                    rtn.add(null);
                    rtn.add(null);
                }
                result.add(rtn);
            }
        }
        return result;
    }

    public static boolean isFullTag(String txt) {
        List<String> tags = RegularUtil.fetchOutTag(txt);
        return !tags.isEmpty();
    }

    public static List<List<String>> fetchAttributeList(String txt, String attribute) {
        List<List<String>> result = new ArrayList<List<String>>();
        try {
            String regx = "(?i)[\\s'\"](" + attribute + ")\\s*=\\s*(['\"])([\\s\\S]*?)\\2";
            result = RegularUtil.fetchs(txt, regx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<String> fetchAttribute(String txt, String attribute) {
        List<String> result = new ArrayList<String>();
        List<List<String>> list = RegularUtil.fetchAttributeList(txt, attribute);
        if (!list.isEmpty()) {
            result = list.get(0);
        }
        return result;
    }

    public static List<String> fetchAttributeValues(String txt, String attribute) {
        ArrayList<String> result = new ArrayList<String>();
        List<List<String>> list = RegularUtil.fetchAttributeList(txt, attribute);
        for (List<String> attr : list) {
            if (attr.size() <= 3) continue;
            result.add(attr.get(3));
        }
        return result;
    }

    public static String fetchAttributeValue(String txt, String attribute) {
        List<String> values = RegularUtil.fetchAttributeValues(txt, attribute);
        if (!values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public static String fetchTagHead(String txt) {
        String stop;
        int chk;
        String sub;
        int cnt;
        String head = "";
        int fr = (txt = txt.replace("\"", "'")).indexOf("<");
        if (fr == -1) {
            return head;
        }
        int to = fr;
        do {
            if ((chk = txt.indexOf(stop = ">", to + 1)) == -1) {
                stop = "/>";
                chk = txt.indexOf(stop, to + 1);
            }
            if (chk != -1) continue;
            return head;
        } while ((cnt = BasicUtil.charCount(sub = txt.substring(fr, (to = chk) + stop.length()), "'")) % 2 != 0);
        return sub;
    }

    public static String fetchTagBody(String txt, String name) throws Exception {
        String tmp;
        int end;
        int to;
        String body = "";
        String head = "<" + name;
        String foot = "</" + name + ">";
        int begin = txt.indexOf(head);
        int fr = begin;
        if (fr > (to = (end = txt.indexOf(foot))) || fr == -1) {
            return null;
        }
        while ((tmp = txt.substring(fr + head.length(), to)).contains(head)) {
            fr = txt.indexOf(head, fr + 1);
            end = to = txt.indexOf(foot, to + 1);
        }
        body = txt.substring(begin + head.length(), end);
        body = RegularUtil.cut(body, ">", TAG_END);
        return body;
    }

    public static String cut(String text, String ... tags) {
        return RegularUtil.cut(false, text, tags);
    }

    public static String cut(boolean ignore, String text, String ... tags) {
        return RegularUtil.cut(ignore, text, false, tags);
    }

    public static String cut(String text, boolean contains, String ... tags) {
        return RegularUtil.cut(false, text, contains, tags);
    }

    public static String cut(boolean ignore, String text, boolean contains, String ... tags) {
        String up = text;
        if (ignore) {
            up = up.toUpperCase();
        }
        if (null == text || null == tags || tags.length < 2) {
            return null;
        }
        int _fr = -1;
        int _to = -1;
        String frTag = "";
        String toTag = tags[tags.length - 1];
        if (ignore && null != toTag) {
            toTag = toTag.toUpperCase();
        }
        int frLength = 0;
        int toLength = 0;
        for (int i = 0; i < tags.length - 1; ++i) {
            frTag = tags[i];
            if (ignore && null != frTag) {
                frTag = frTag.toUpperCase();
            }
            if (frTag.equalsIgnoreCase(TAG_BEGIN)) {
                _fr = 0;
                frLength = 0;
                continue;
            }
            _fr = i > 0 ? up.indexOf(frTag, _fr + tags[i - 1].length()) : up.indexOf(frTag, _fr);
            if (_fr == -1) {
                return null;
            }
            frLength = frTag.length();
        }
        if (frTag.equalsIgnoreCase(TAG_END)) {
            _to = text.length();
        } else if (toTag.equalsIgnoreCase(TAG_END)) {
            _to = text.length();
            toLength = 0;
        } else {
            _to = up.indexOf(toTag, _fr + frLength);
            toLength = toTag.length();
        }
        if (_to <= _fr) {
            return null;
        }
        String result = null;
        if (contains) {
            _fr = up.indexOf(tags[0]);
            result = text.substring(_fr, _to + toLength);
        } else {
            result = text.substring(_fr + frLength, _to);
        }
        return result;
    }

    public static List<String> cuts(String text, String ... tags) {
        return RegularUtil.cuts(false, text, tags);
    }

    public static List<String> cuts(boolean ignore, String text, String ... tags) {
        return RegularUtil.cuts(ignore, text, false, tags);
    }

    public static List<String> cuts(String text, boolean contains, String ... tags) {
        return RegularUtil.cuts(false, text, contains, tags);
    }

    public static List<String> cuts(boolean ignore, String text, boolean contains, String ... tags) {
        String item;
        ArrayList<String> list = new ArrayList<String>();
        String up = text;
        if (ignore) {
            up = up.toUpperCase();
        }
        while (null != (item = RegularUtil.cut(ignore, text, contains, tags))) {
            list.add(item);
            int idx = 0;
            for (int i = 0; i < tags.length; ++i) {
                if (idx > 0) {
                    ++idx;
                }
                String tag = tags[i];
                if (ignore) {
                    tag = tag.toUpperCase();
                }
                idx = up.indexOf(tag, idx);
            }
            if (idx <= 0) break;
            text = text.substring(idx);
            up = up.substring(idx);
        }
        return list;
    }

    public static boolean isDate(String str) {
        if (str == null) {
            return false;
        }
        str = str.replace("/", "-");
        return regularMatch.match(str, Regular.PATTERN.DATE.getCode());
    }

    public static boolean isDateTime(String str) {
        if (null == str) {
            return false;
        }
        str = str.replace("/", "-");
        return regularMatch.match(str, Regular.PATTERN.DATE_TIME.getCode());
    }

    public static boolean isUrl(String src) {
        if (null == src) {
            return false;
        }
        if (src.startsWith("http://") || src.startsWith("https://")) {
            return true;
        }
        if (src.startsWith("//")) {
            int index1 = (src = src.substring(2)).indexOf(".");
            if (index1 == -1) {
                return false;
            }
            int index2 = src.indexOf("/");
            if (index1 < index2) {
                return true;
            }
            if (index2 == -1) {
                return true;
            }
        }
        return false;
    }

    public static List<String> splitPlaceholder(String text) {
        ArrayList<String> list = new ArrayList<String>();
        int fr = 0;
        while (!text.isEmpty()) {
            int idx = text.indexOf("${", fr);
            if (idx == -1) {
                list.add(text);
                break;
            }
            if (!text.startsWith("${")) {
                String prefix = text.substring(0, idx);
                if (BasicUtil.isFullString(prefix)) {
                    list.add(prefix);
                    text = text.substring(idx);
                    fr = 0;
                    continue;
                }
                fr = idx + 1;
                continue;
            }
            if ((idx = text.indexOf("}", idx)) == -1) break;
            String head = text.substring(0, idx + 1);
            if (BasicUtil.isFullString(head)) {
                list.add(head);
                text = text.substring(idx + 1);
                fr = 0;
                continue;
            }
            fr = idx + 1;
        }
        return list;
    }

    static {
        regularMatch = new RegularMatch();
        regularMatchPrefix = new RegularMatchPrefix();
        regularContain = new RegularContain();
        regularList = new HashMap<Regular.MATCH_MODE, Regular>();
        log = LogProxy.get(RegularUtil.class);
        regularList.put(Regular.MATCH_MODE.MATCH, regularMatch);
        regularList.put(Regular.MATCH_MODE.PREFIX, regularMatchPrefix);
        regularList.put(Regular.MATCH_MODE.CONTAIN, regularContain);
    }
}

