/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;

public class MapUtil {
    private static final Log log = LogProxy.get(MapUtil.class);

    public static List<Map<String, Object>> extracts(Collection<Map<String, Object>> list, String ... keys) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (null != list) {
            for (Map<String, Object> obj : list) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                if (null == keys) continue;
                for (String key : keys) {
                    map.put(key, obj.get(key));
                }
                result.add(map);
            }
        }
        return result;
    }

    public static Collection<Map<String, Object>> distinct(Collection<Map<String, Object>> list, String ... keys) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (null != list) {
            for (Map<String, Object> obj : list) {
                if (null == keys || keys.length == 0) {
                    if (result.contains(obj)) continue;
                    result.add(MapUtil.extract(obj, keys));
                    continue;
                }
                if (!MapUtil.contain(result, obj, keys)) continue;
                result.add(MapUtil.extract(obj, keys));
            }
        }
        return result;
    }

    public static Collection<Object> distinctValue(Collection<Map<String, Object>> list, String key) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (null != list) {
            for (Map<String, Object> obj : list) {
                Object value = obj.get(key);
                if (result.contains(value)) continue;
                result.add(value);
            }
        }
        return result;
    }

    public static Collection<Map<String, Object>> distinct(Collection<Map<String, Object>> list, List<String> keys) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (null != list) {
            for (Map<String, Object> obj : list) {
                if (null == keys || keys.isEmpty()) {
                    if (result.contains(obj)) continue;
                    result.add(MapUtil.extract(obj, keys));
                    continue;
                }
                if (MapUtil.contain(result, obj, keys)) continue;
                result.add(MapUtil.extract(obj, keys));
            }
        }
        return result;
    }

    public static Map<String, Object> extract(Map<String, Object> src, List<String> keys) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : keys) {
            map.put(key, src.get(key));
        }
        return map;
    }

    public static Map<String, Object> extract(Map<String, Object> src, String ... keys) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : keys) {
            map.put(key, src.get(key));
        }
        return map;
    }

    public static boolean contain(Collection<Map<String, Object>> list, Map<String, Object> obj, String ... keys) {
        for (Map<String, Object> item : list) {
            if (!MapUtil.equals(item, obj, new String[0])) continue;
            return true;
        }
        return false;
    }

    public static boolean contain(Collection<Map<String, Object>> list, Map<String, Object> obj, List<String> keys) {
        for (Map<String, Object> item : list) {
            if (!MapUtil.equals(item, obj, keys)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(Map<String, Object> obj1, Map<String, Object> obj2, List<String> keys) {
        for (String key : keys) {
            Object v1 = obj1.get(key);
            Object v2 = obj2.get(key);
            if (null != v1 && v1.equals(v2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Map<String, Object> obj1, Map<String, Object> obj2, String ... keys) {
        return MapUtil.equals(obj1, obj2, BeanUtil.array2list(new String[][]{keys}));
    }

    public static String parseFinalValue(Map<String, Object> obj, String key) {
        if (null == obj) {
            return key;
        }
        Object value = key;
        if (BasicUtil.isNotEmpty(key)) {
            if (key.contains("${")) {
                try {
                    List<String> ks = RegularUtil.fetch(key, "\\${\\w+\\}", Regular.MATCH_MODE.CONTAIN, 0);
                    for (String k : ks) {
                        Object v = obj.get(k.replace("${", "").replace("}", ""));
                        if (null == v) {
                            v = "";
                        }
                        value = ((String)value).replace(k, v.toString());
                    }
                }
                catch (Exception e) {
                    log.error("parse final value exception:", e);
                }
            } else {
                value = "" + obj.get(key);
            }
        }
        return value;
    }

    public static Map<String, Object> copy(Map<String, Object> src, Map<String, Object> copy, List<String> keys) {
        if (null == copy) {
            return src;
        }
        if (null != keys) {
            for (String key : keys) {
                String[] ks = BeanUtil.parseKeyValue(key);
                src.put(ks[0], copy.get(ks[1]));
            }
        }
        return src;
    }

    public static Map<String, Object> copy(Map<String, Object> src, Map<String, Object> copy, String ... keys) {
        if (null == copy) {
            return src;
        }
        if (null != keys) {
            for (String key : keys) {
                String[] ks = BeanUtil.parseKeyValue(key);
                src.put(ks[0], copy.get(ks[1]));
            }
        }
        return src;
    }

    public static Map<String, Object> copy(Map<String, Object> src, Map<String, Object> copy) {
        return MapUtil.copy(src, copy, BeanUtil.getMapKeys(copy));
    }

    public static Map<String, Object> query(Collection<Map<String, Object>> datas, Map<String, Object> kvs) {
        List<Map<String, Object>> list = MapUtil.querys(datas, 0, 1, kvs);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static List<Map<String, Object>> querys(Collection<Map<String, Object>> datas, int begin, String ... params) {
        return MapUtil.querys(datas, begin, 0, params);
    }

    public static List<Map<String, Object>> querys(Collection<Map<String, Object>> datas, String ... params) {
        return MapUtil.querys(datas, 0, params);
    }

    public static List<Map<String, Object>> querys(Collection<Map<String, Object>> datas, int begin, int qty, String ... params) {
        LinkedHashMap<String, Object> kvs = new LinkedHashMap<String, Object>();
        int len = params.length;
        int i = 0;
        String srcFlagTag = "srcFlag";
        while (i < len) {
            String p1 = params[i];
            if (BasicUtil.isEmpty((Object)p1)) {
                ++i;
                continue;
            }
            if (p1.contains(":")) {
                String[] ks = BeanUtil.parseKeyValue(p1);
                kvs.put(ks[0], ks[1]);
                ++i;
                continue;
            }
            if (i + 1 < len) {
                String p2 = params[i + 1];
                if (BasicUtil.isEmpty((Object)p2) || !p2.contains(":")) {
                    kvs.put(p1, p2);
                    i += 2;
                    continue;
                }
                if (BasicUtil.checkEl(p2)) {
                    p2 = p2.substring(2, p2.length() - 1);
                    kvs.put(p1, p2);
                    kvs.put(p1 + srcFlagTag, "true");
                    i += 2;
                    continue;
                }
                String[] ks = BeanUtil.parseKeyValue(p2);
                kvs.put(ks[0], ks[1]);
                i += 2;
                continue;
            }
            ++i;
        }
        return MapUtil.querys(datas, begin, qty, kvs);
    }

    public static List<Map<String, Object>> querys(Collection<Map<String, Object>> datas, int begin, int qty, Map<String, Object> kvs) {
        ArrayList<Map<String, Object>> set = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : datas) {
            if (row.containsKey("_tmp_skip")) continue;
            boolean chk = true;
            for (String k : kvs.keySet()) {
                Object v = kvs.get(k);
                Object value = row.get(k);
                if (null == v) {
                    if (null != value) {
                        chk = false;
                        break;
                    }
                    chk = true;
                    break;
                }
                if (null == value) {
                    chk = false;
                    break;
                }
                Object str = "" + value;
                str = ((String)str).toLowerCase();
                if ((v = v.toString().toLowerCase()).equals(str)) continue;
                chk = false;
                break;
            }
            if (!chk) continue;
            set.add(row);
            if (qty <= 0 || set.size() < qty) continue;
            break;
        }
        return set;
    }

    private static String concatValue(Map<String, Object> row, String split) {
        StringBuilder builder = new StringBuilder();
        List<String> keys = BeanUtil.getMapKeys(row);
        for (String key : keys) {
            if (builder.length() > 0) {
                builder.append(split);
            }
            builder.append(row.get(key));
        }
        return builder.toString();
    }

    public static Collection<Map<String, Object>> pivot(Collection<Map<String, Object>> datas, List<String> pks, List<String> classKeys, List<String> valueKeys) {
        Collection<Map<String, Object>> result = MapUtil.distinct(datas, pks);
        Collection<Map<String, Object>> classValues = MapUtil.distinct(datas, classKeys);
        for (Map<String, Object> row : result) {
            for (Map<String, Object> classValue : classValues) {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                MapUtil.copy(params, row, pks);
                MapUtil.copy(params, classValue);
                Map<String, Object> valueRow = MapUtil.query(datas, params);
                if (null != valueRow) {
                    valueRow.put("_tmp_skip", "1");
                }
                String finalKey = MapUtil.concatValue(classValue, "-");
                if (null != valueKeys && !valueKeys.isEmpty()) {
                    if (valueKeys.size() == 1) {
                        if (null != valueRow) {
                            row.put(finalKey, valueRow.get(valueKeys.get(0)));
                            continue;
                        }
                        row.put(finalKey, null);
                        continue;
                    }
                    for (String valueKey : valueKeys) {
                        if (null != valueRow) {
                            row.put(finalKey + "-" + valueKey, valueRow.get(valueKey));
                            continue;
                        }
                        row.put(finalKey + "-" + valueKey, null);
                    }
                    continue;
                }
                if (null != valueRow) {
                    row.put(finalKey, valueRow);
                    continue;
                }
                row.put(finalKey, null);
            }
        }
        for (Map<String, Object> data : datas) {
            data.remove("_tmp_skip");
        }
        return result;
    }

    public static Collection<Map<String, Object>> pivot(Collection<Map<String, Object>> datas, String[] pks, String[] classKeys, String[] valueKeys) {
        return MapUtil.pivot(datas, BeanUtil.array2list(new String[][]{pks}), BeanUtil.array2list(new String[][]{classKeys}), BeanUtil.array2list(new String[][]{valueKeys}));
    }

    public static Collection<Map<String, Object>> pivot(Collection<Map<String, Object>> datas, String pk, String classKey, String valueKey) {
        List<String> pks = BeanUtil.array2list(new String[][]{pk.trim().split(",")});
        List<String> classKeys = BeanUtil.array2list(new String[][]{classKey.trim().split(",")});
        List<String> valueKeys = BeanUtil.array2list(new String[][]{valueKey.trim().split(",")});
        return MapUtil.pivot(datas, pks, classKeys, valueKeys);
    }

    public static Collection<Map<String, Object>> pivot(Collection<Map<String, Object>> datas, String pk, String classKey) {
        List<String> pks = BeanUtil.array2list(new String[][]{pk.trim().split(",")});
        List<String> classKeys = BeanUtil.array2list(new String[][]{classKey.trim().split(",")});
        ArrayList<String> valueKeys = new ArrayList<String>();
        return MapUtil.pivot(datas, pks, classKeys, valueKeys);
    }

    public static Collection<Map<String, Object>> pivot(Collection<Map<String, Object>> datas, List<String> pks, List<String> classKeys, String ... valueKeys) {
        ArrayList<String> list = new ArrayList<String>();
        if (null != valueKeys) {
            for (String item : valueKeys) {
                list.add(item);
            }
        }
        return MapUtil.pivot(datas, pks, classKeys, valueKeys);
    }
}

