/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.metadata.Column;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.util.BasicUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.NumberUtil;

public class LogUtil {
    private static final String SINGLE_CHAR = "abcdefghijklmnopqrstuvwxyz0123456789:,.?'\"_-=+!@#$%^&*{}[]()\\/ ";

    public static String format(String content, int color, int type) {
        boolean hasType;
        boolean bl = hasType = type != 1 && type != 3 && type != 4;
        if (hasType) {
            return String.format("\u001b[%dm%s\u001b[0m", color, content);
        }
        return String.format("\u001b[%d;%dm%s\u001b[0m", color, type, content);
    }

    public static String format(String content, int color) {
        return LogUtil.format(content, color, 0);
    }

    public static String format(int content, int color) {
        return LogUtil.format("" + content, color, 0);
    }

    public static String format(double content, int color) {
        return LogUtil.format("" + content, color, 0);
    }

    public static String format(long content, int color) {
        return LogUtil.format("" + content, color, 0);
    }

    public static String format(BigDecimal content, int color) {
        return LogUtil.format("" + content, color, 0);
    }

    public static String format(boolean content, int color) {
        return LogUtil.format("" + content, color, 0);
    }

    public static String param(List params) {
        StringBuilder builder = new StringBuilder();
        if (null != params && !params.isEmpty()) {
            builder.append("\n");
            int idx = 0;
            for (Object param : params) {
                builder.append("param").append(idx++).append("=").append(param);
                if (null != param) {
                    builder.append("(").append(ClassUtil.type(param)).append(")");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public static String param(List keys, List values) {
        StringBuilder builder;
        block6: {
            block4: {
                block5: {
                    builder = new StringBuilder();
                    if (null == keys || null == values || keys.isEmpty()) break block4;
                    builder.append("\n");
                    if (keys.size() != values.size()) break block5;
                    int size = keys.size();
                    for (int i = 0; i < size; ++i) {
                        Object key = keys.get(i);
                        Object value = values.get(i);
                        builder.append(keys.get(i)).append("=");
                        builder.append(value);
                        if (null != value) {
                            builder.append("(").append(ClassUtil.type(value)).append(")");
                        }
                        builder.append("\n");
                    }
                    break block6;
                }
                return LogUtil.param(values);
            }
            if (null == values) break block6;
            int idx = 0;
            builder.append("\n");
            for (Object value : values) {
                builder.append("param").append(idx++).append("=").append(value);
                if (null != value) {
                    builder.append("(").append(ClassUtil.type(value)).append(")");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public static String table(DataSet set) {
        return LogUtil.table(set, set.keys(), true, ConfigTable.LOG_QUERY_RESULT_ROWS, ConfigTable.LOG_QUERY_RESULT_TABLE_MAX_WIDTH);
    }

    public static String table(DataSet set, List<String> keys, boolean color, int rows, int width) {
        int view_width;
        StringBuilder result = new StringBuilder();
        int limit_width = width;
        int col_max_width = ConfigTable.LOG_QUERY_RESULT_CUT_WIDTH;
        int col_max_length = 90;
        boolean ellipsis = true;
        boolean br = true;
        HashMap<String, Integer> origin_widths = new HashMap<String, Integer>();
        HashMap<String, Integer> view_widths = new HashMap<String, Integer>();
        HashMap<String, Integer> zip_cols = new HashMap<String, Integer>();
        HashMap<String, Integer> cols_aligns = new HashMap<String, Integer>();
        for (String key : keys) {
            TypeMetadata tm;
            Column column = set.getMetadata(key);
            if (null == column || null == (tm = column.getTypeMetadata())) continue;
            Object tc = tm.getCategoryGroup();
            if (tc == TypeMetadata.CATEGORY_GROUP.DATETIME || tc == TypeMetadata.CATEGORY_GROUP.BOOLEAN) {
                cols_aligns.put(key.toUpperCase(), 0);
                continue;
            }
            if (tc != TypeMetadata.CATEGORY_GROUP.NUMBER) continue;
            cols_aligns.put(key.toUpperCase(), 1);
        }
        boolean has_pk = !set.getPrimaryKeys().isEmpty();
        int idx = 0;
        for (DataRow row : set) {
            if (idx++ >= rows && rows != -1) break;
            for (String key : keys) {
                Integer origin_width = (Integer)origin_widths.get(key.toUpperCase());
                if (null == origin_width) {
                    origin_width = 0;
                }
                String value = " " + row.getString(key) + " ";
                int key_width2 = LogUtil.len(key) + 2;
                int value_width = 0;
                if (null != value) {
                    value_width = LogUtil.len(value);
                    origin_width = NumberUtil.max(origin_width, value_width, key_width2);
                    if (value_width > key_width2 && LogUtil.isZip(row, key) && value_width > key_width2) {
                        zip_cols.put(key.toUpperCase(), value_width);
                    }
                }
                origin_widths.put(key.toUpperCase(), origin_width);
            }
        }
        double max_width = 0.0;
        for (Integer col_width : origin_widths.values()) {
            max_width += (double)col_width.intValue();
        }
        if ((double)limit_width > max_width) {
            limit_width = (int)max_width;
        }
        double rate = (double)limit_width / max_width;
        int exceed = 0;
        for (String key : keys) {
            int origin_width = (Integer)origin_widths.get(key.toUpperCase());
            int rate_width = (int)((double)origin_width * rate);
            view_width = origin_width;
            int n = LogUtil.len(key) + 2;
            if (zip_cols.containsKey(key.toUpperCase())) {
                if (rate_width < col_max_width) {
                    rate_width = col_max_width;
                }
                view_width = rate_width;
            }
            if (view_width < n) {
                view_width = n;
            }
            if (view_width > rate_width) {
                exceed += view_width - rate_width;
            }
            view_widths.put(key.toUpperCase(), view_width);
        }
        if (exceed > 0) {
            double zip_cols_width = 0.0;
            for (String key : zip_cols.keySet()) {
                zip_cols_width += (double)((Integer)zip_cols.get(key)).intValue();
            }
            for (String key : zip_cols.keySet()) {
                view_width = (Integer)view_widths.get(key);
                int n = LogUtil.len(key) + 2;
                if ((view_width -= (int)((double)view_width / zip_cols_width * (double)exceed)) < n) {
                    view_width = n;
                }
                view_widths.put(key, view_width);
            }
        }
        ArrayList tables = new ArrayList();
        ArrayList<String> table = new ArrayList<String>();
        int total = 0;
        for (String key : keys) {
            int n = (Integer)view_widths.get(key.toUpperCase());
            if ((total += n) > limit_width) {
                tables.add(table);
                table = new ArrayList();
                table.add(key);
                total = n;
                continue;
            }
            table.add(key);
        }
        if (!table.isEmpty()) {
            tables.add(table);
        }
        int tab_index = 0;
        result.append("[tables:").append(tables.size()).append("][rows:").append(set.size()).append("][cols:").append(keys.size()).append("]");
        if (BasicUtil.isNotEmpty(ConfigTable.LOG_QUERY_RESULT_ALT)) {
            result.append(ConfigTable.LOG_QUERY_RESULT_ALT);
        }
        result.append("\n");
        for (List list : tables) {
            StringBuilder builder = new StringBuilder();
            StringBuilder row_split = new StringBuilder();
            if (!has_pk) {
                row_split.append("---");
            }
            int col_size = list.size();
            for (int i = 0; i < col_size; ++i) {
                Integer view_width3 = (Integer)view_widths.get(((String)list.get(i)).toUpperCase());
                String left = "";
                String right = "+";
                if (i == 0) {
                    left = "+";
                }
                row_split.append(left);
                LogUtil.fill(row_split, view_width3, "-");
                row_split.append(right);
            }
            builder.append((CharSequence)row_split);
            builder.append("\n");
            StringBuilder title = new StringBuilder();
            if (!has_pk) {
                title.append(tab_index + 1 + "/" + tables.size());
                ++tab_index;
            }
            for (int i = 0; i < col_size; ++i) {
                String key = (String)list.get(i);
                int view_width4 = (Integer)view_widths.get(key.toUpperCase());
                String left = "";
                String right = "|";
                if (i == 0) {
                    left = "|";
                }
                title.append(left);
                String content = LogUtil.cell(" " + key + " ", view_width4, (Integer)cols_aligns.get(key.toUpperCase()));
                title.append(content);
                title.append(right);
            }
            if (color) {
                builder.append(LogUtil.format(title.toString(), 34));
            } else {
                builder.append((CharSequence)title);
            }
            builder.append("\n");
            builder.append((CharSequence)row_split);
            idx = 0;
            for (DataRow row : set) {
                if (idx >= rows && rows != -1) break;
                builder.append("\n");
                if (!has_pk) {
                    builder.append(LogUtil.cell("" + idx, 3, 1));
                }
                ++idx;
                for (int i = 0; i < col_size; ++i) {
                    String key = (String)list.get(i);
                    String value = " " + row.getString(key) + " ";
                    int view_width5 = (Integer)view_widths.get(key.toUpperCase());
                    String left = "";
                    String right = "|";
                    if (i == 0) {
                        left = "|";
                    }
                    builder.append(left);
                    Integer align = (Integer)cols_aligns.get(key.toUpperCase());
                    String content = LogUtil.cell(value, view_width5, align);
                    if (null != align && align == 1) {
                        content = LogUtil.format(content, 36);
                    }
                    builder.append(content);
                    builder.append(right);
                }
                builder.append("\n");
                builder.append((CharSequence)row_split);
            }
            builder.append("\n");
            builder.append((CharSequence)title);
            builder.append("\n");
            builder.append((CharSequence)row_split);
            builder.append("\n");
            builder.append("\n");
            result.append((CharSequence)builder);
        }
        return result.toString();
    }

    private static boolean isZip(DataRow row, String key) {
        TypeMetadata.CATEGORY_GROUP type;
        Column column = row.getMetadata(key);
        boolean zip = true;
        if (null != column && ((type = column.getTypeMetadata().getCategoryGroup()) == TypeMetadata.CATEGORY_GROUP.NUMBER || type == TypeMetadata.CATEGORY_GROUP.BOOLEAN || type == TypeMetadata.CATEGORY_GROUP.BYTES || type == TypeMetadata.CATEGORY_GROUP.DATETIME)) {
            zip = false;
        }
        return zip;
    }

    public static void fill(StringBuilder builder, int size, String ch) {
        for (int i = 0; i < size; ++i) {
            builder.append(ch);
        }
    }

    public static int len(String src) {
        String[] chrs = src.split("");
        int cnt = 0;
        for (String chr : chrs) {
            if (SINGLE_CHAR.contains(chr.toLowerCase())) {
                ++cnt;
                continue;
            }
            cnt += 2;
        }
        return cnt;
    }

    public static String cell(String src, int size, Integer align) {
        if (null == align) {
            align = -1;
        }
        StringBuilder result = new StringBuilder();
        String[] chrs = src.split("");
        int cnt = 0;
        for (String chr : chrs) {
            if (cnt >= size) break;
            if (SINGLE_CHAR.contains(chr.toLowerCase())) {
                ++cnt;
            } else {
                if (cnt + 2 > size) break;
                cnt += 2;
            }
            result.append(chr);
        }
        int dif = size - cnt;
        if (align == 1) {
            for (i = 0; i < dif; ++i) {
                result.insert(0, " ");
            }
        } else if (align == 0) {
            int i;
            int left = (int)Math.ceil(dif / 2);
            int right = dif - left;
            for (i = 0; i < left; ++i) {
                result.insert(0, " ");
            }
            for (i = 0; i < right; ++i) {
                result.append(" ");
            }
        } else {
            for (i = 0; i < dif; ++i) {
                result.append(" ");
            }
        }
        return result.toString();
    }
}

