/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.entity.Aggregation;
import org.anyline.entity.AggregationConfig;
import org.anyline.entity.DefaultGroupStore;
import org.anyline.entity.GroupStore;
import org.anyline.exception.AnylineException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Schema;
import org.anyline.metadata.TableAffiliation;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Type;
import org.anyline.metadata.View;
import org.anyline.metadata.differ.MetadataDiffer;
import org.anyline.metadata.differ.TableDiffer;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.SQLUtil;

public class Table<E extends Table>
extends Metadata<E>
implements Serializable {
    private static Map<Integer, Type> types = new HashMap<Integer, Type>();
    protected String keyword = "TABLE";
    protected Table inherit;
    protected Table master;
    protected Partition partition;
    protected Partition subPartition;
    protected String type;
    protected int srid;
    protected String typeCat;
    protected String typeSchema;
    protected String typeName;
    protected String selfReferencingColumn;
    protected String refGeneration;
    private String engineParameters;
    protected String charset;
    protected String collate;
    protected Long ttl;
    protected Date createTime;
    protected Date updateTime;
    protected Long dataRows;
    protected Long dataLength;
    protected Long increment;
    protected Long dataFree;
    protected Long indexLength;
    protected int temporary;
    protected int metadataScan = 1000;
    protected Skew skew;
    protected Store store;
    protected String location;
    protected int changePrimary = -1;
    protected LinkedHashMap<String, View> materializes;
    protected List<Key> keys;
    protected Distribution distribution;
    protected PrimaryKey primaryKey;
    protected LinkedHashMap<String, Column> columns = new LinkedHashMap();
    protected LinkedHashMap<String, Tag> tags = new LinkedHashMap();
    protected LinkedHashMap<String, Index> indexes = new LinkedHashMap();
    protected LinkedHashMap<String, Constraint> constraints = new LinkedHashMap();
    protected List<String> having = new ArrayList<String>();
    protected boolean sort = false;
    protected List<AggregationConfig> aggregations = new ArrayList<AggregationConfig>();
    protected GroupStore groups = new DefaultGroupStore();
    protected boolean autoDropColumn = ConfigTable.IS_DDL_AUTO_DROP_COLUMN;
    public static final String FIELD_KEYWORD = "KEYWORD";
    public static final String FIELD_PARTITION = "PARTITION";
    public static final String FIELD_TYPE = "TYPE";
    public static final String FIELD_SRID = "SRID";
    public static final String FIELD_TYPE_CAT = "TYPE_CAT";
    public static final String FIELD_TYPE_SCHEMA = "TYPE_SCHEMA";
    public static final String FIELD_SELF_REFERENCING_COLUMN = "SELF_REFERENCING_COLUMN";
    public static final String FIELD_REF_GENERATION = "REF_GENERATION";
    public static final String FIELD_ENGINE = "ENGINE";
    public static final String FIELD_ENGINE_PARAMETERS = "ENGINE_PARAMETERS";
    public static final String FIELD_CHARSET = "CHARSET";
    public static final String FIELD_COLLATE = "COLLATE";
    public static final String FIELD_TTL = "TTL";
    public static final String FIELD_CREATE_TIME = "CREATE_TIME";
    public static final String FIELD_UPDATE_TIME = "UPDATE_TIME";
    public static final String FIELD_DATA_ROWS = "DATA_ROWS";
    public static final String FIELD_DATA_LENGTH = "DATA_LENGTH";
    public static final String FIELD_INCREMENT = "INCREMENT";
    public static final String FIELD_DATA_FREE = "DATA_FREE";
    public static final String FIELD_INDEX_LENGTH = "INDEX_LENGTH";
    public static final String FIELD_TEMPORARY = "TEMPORARY";
    public static final String FIELD_METADATA_SCAN = "METADATA_SCAN";
    public static final String FIELD_CHANGE_PRIMARY = "CHANGE_PRIMARY";
    public static final String FIELD_MATERIALIZE = "MATERIALIZE";
    public static final String FIELD_KEY = "KEY";
    public static final String FIELD_DISTRIBUTION = "DISTRIBUTION";
    public static final String FIELD_PRIMARY_KEY = "PRIMARY_KEY";
    public static final String FIELD_COLUMN = "COLUMN";
    public static final String FIELD_TAG = "TAG";
    public static final String FIELD_INDEXE = "INDEXE";
    public static final String FIELD_CONSTRAINT = "CONSTRAINT";
    public static final String FIELD_SORT = "SORT";
    public static final String FIELD_SORT_CHECK = "SORT_CHECK";
    public static final String FIELD_SORT_CHECK_VALUE = "SORT_CHECK_VALUE";
    public static final String FIELD_MASTER_CHECK = "_MASTER_CHECK";
    public static final String FIELD_MASTER_CHECK_VALUE = "MASTER_CHECK_VALUE";

    public static Map<Integer, Type> types() {
        return types;
    }

    public static Type type(int type) {
        return Table.types().get(type);
    }

    public static List<Type> types(int types) {
        ArrayList<Type> list = new ArrayList<Type>();
        int count = 0;
        while (types >= 1) {
            int temp = types % 2;
            types = (types - temp) / 2;
            if (temp == 1) {
                Type t = null;
                t = count == 0 ? Table.type(1) : Table.type(2 << count - 1);
                if (null != t) {
                    list.add(t);
                }
            }
            ++count;
        }
        return list;
    }

    public Table() {
    }

    public Table(String name) {
        if (null != name) {
            String[] tmps;
            String tmp = name.replaceAll("\\s+", " ");
            String up = tmp.toUpperCase();
            if (up.contains(" AS ")) {
                if (up.contains(")")) {
                    String last;
                    tmps = tmp.split("\\)");
                    if (tmps.length > 1 && (last = tmps[tmps.length - 1]).contains(" AS ")) {
                        int split = last.lastIndexOf(" AS ");
                        String alias = last.substring(split + 4).trim();
                        this.setAlias(alias);
                        name = tmp.substring(0, tmp.length() - alias.length() - 4);
                    }
                } else {
                    int split = up.lastIndexOf(" AS ");
                    name = tmp.substring(0, split).trim();
                    String alias = tmp.substring(split + 4).trim();
                    this.setAlias(alias);
                }
            }
            if (name.contains(":") || name.contains(" ")) {
                this.name = name;
            } else if (name.contains(".")) {
                tmps = name.split("\\.");
                if (tmps.length == 2) {
                    this.schema = new Schema(tmps[0]);
                    this.name = tmps[1];
                } else if (tmps.length == 3) {
                    this.catalog = new Catalog(tmps[0]);
                    this.schema = new Schema(tmps[1]);
                    this.name = tmps[2];
                }
            } else {
                this.name = name;
            }
        } else {
            this.name = name;
        }
    }

    public Table(String schema, String table) {
        this(null, schema, table);
    }

    public Table(Schema schema, String table) {
        this(null, schema, table);
    }

    public Table(String catalog, String schema, String name) {
        if (BasicUtil.isNotEmpty(catalog)) {
            this.catalog = new Catalog(catalog);
        }
        if (BasicUtil.isNotEmpty(schema)) {
            this.schema = new Schema(schema);
        }
        this.name = name;
    }

    public Table(Catalog catalog, Schema schema, String name) {
        this.catalog = catalog;
        this.schema = schema;
        this.name = name;
    }

    public Table resetColumnLength(double rate, String ... types) {
        block0: for (Column column : this.columns.values()) {
            String type = column.getTypeName();
            Integer length = column.getLength();
            if (null == length || length <= 0) continue;
            int len = (int)((double)length.intValue() * rate);
            if (null != types && types.length > 0) {
                for (String tp : types) {
                    if (!tp.equalsIgnoreCase(type)) continue;
                    column.resetLength(len);
                    continue block0;
                }
                continue;
            }
            column.resetLength(len);
        }
        return this;
    }

    public Table group(String ... columns) {
        for (String column : columns) {
            this.groups.add(column);
        }
        return this;
    }

    public GroupStore groups() {
        return this.groups;
    }

    public List<String> having() {
        return this.having;
    }

    public Table having(String having) {
        this.having.add(having);
        return this;
    }

    public Table aggregation(Aggregation aggregation, String column, String result) {
        AggregationConfig config = new AggregationConfig(aggregation, column, result);
        this.aggregations.add(config);
        return this;
    }

    public Table aggregation(AggregationConfig ... configs) {
        for (AggregationConfig config : configs) {
            this.aggregations.add(config);
        }
        return this;
    }

    public List<AggregationConfig> aggregations() {
        return this.aggregations;
    }

    public static Table from(Class clazz) {
        return EntityAdapterProxy.table(clazz);
    }

    public Table setKeyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    public Distribution getDistribution() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getDistribution();
        }
        return this.distribution;
    }

    public Table setDistribution(Distribution distribution) {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).setDistribution(distribution);
        }
        this.distribution = distribution;
        return this;
    }

    public Table setCluster(Distribution distribution) {
        return this.setDistribution(distribution);
    }

    public Table setDistribution(Distribution.TYPE type, int buckets, String ... columns) {
        this.setDistribution(new Distribution(type, buckets, columns));
        return this;
    }

    public Table setDistribution(Distribution.TYPE type, String ... columns) {
        this.setDistribution(new Distribution(type, columns));
        return this;
    }

    @Override
    public E drop() {
        this.action = ACTION.DDL.TABLE_DROP;
        return (E)((Table)super.drop());
    }

    public int getPrimaryKeySize() {
        PrimaryKey pk = this.getPrimaryKey();
        if (null != pk) {
            return pk.getColumns().size();
        }
        return 0;
    }

    public List<Key> getKeys() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getKeys();
        }
        return this.keys;
    }

    public Table setKeys(List<Key> keys) {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).setKeys(keys);
        }
        this.keys = keys;
        return this;
    }

    public Table addKey(Key key) {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).addKey(key);
        }
        if (null == this.keys) {
            this.keys = new ArrayList<Key>();
        }
        this.keys.add(key);
        return this;
    }

    public Table addKey(Key.TYPE type, String ... columns) {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).addKey(type, columns);
        }
        if (null == this.keys) {
            this.keys = new ArrayList<Key>();
        }
        Key key = new Key();
        key.setType(type);
        key.setColumns(columns);
        this.keys.add(key);
        return this;
    }

    public Partition getPartition() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).partition;
        }
        return this.partition;
    }

    public Table partitionFor(Partition.TYPE type, Object ... values) {
        Partition partition = new Partition();
        partition.setType(type);
        partition.addValues(values);
        return this.setPartition(partition);
    }

    public Table setPartition(Partition partition) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setPartition(partition);
            return this;
        }
        this.partition = partition;
        return this;
    }

    public Table partitionBy(Partition.TYPE type, String ... columns) {
        Partition partition = new Partition();
        partition.setType(type);
        partition.setColumns(columns);
        return this.setPartition(partition);
    }

    public Partition getSubPartition() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).subPartition;
        }
        return this.subPartition;
    }

    public Table subPartitionFor(Partition.TYPE type, Object ... values) {
        Partition suPartition = new Partition();
        suPartition.setType(type);
        suPartition.addValues(values);
        return this.setSubPartition(suPartition);
    }

    public Table setSubPartition(Partition partition) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setSubPartition(partition);
            return this;
        }
        this.subPartition = partition;
        return this;
    }

    public Table subPartitionBy(Partition.TYPE type, String ... columns) {
        Partition partition = new Partition();
        partition.setType(type);
        partition.setColumns(columns);
        return this.setSubPartition(partition);
    }

    public String getMasterName() {
        if (null != this.master) {
            return this.master.getName();
        }
        return null;
    }

    public Table setMaster(String master) {
        this.master = new MasterTable(master);
        return this;
    }

    public Table getMaster() {
        return this.master;
    }

    public Table setPartitionOf(Table master) {
        this.master = master;
        return this;
    }

    public Table setMaster(Table master) {
        this.master = master;
        return this;
    }

    public LinkedHashMap<String, View> getMaterializes() {
        return this.materializes;
    }

    public Table setMaterializes(LinkedHashMap<String, View> materializes) {
        this.materializes = materializes;
        return this;
    }

    public Table addMaterializes(View view) {
        if (null == this.materializes) {
            this.materializes = new LinkedHashMap();
        }
        this.materializes.put(view.getName().toUpperCase(), view);
        return this;
    }

    public int getMetadataScan() {
        return this.metadataScan;
    }

    public void setMetadataScan(int metadataScan) {
        this.metadataScan = metadataScan;
    }

    public LinkedHashMap<String, Column> primarys() {
        LinkedHashMap<String, Column> pks = new LinkedHashMap<String, Column>();
        for (Map.Entry<String, Column> item : this.columns.entrySet()) {
            Column column = item.getValue();
            String key = item.getKey();
            if (column.isPrimaryKey() != 1) continue;
            pks.put(key, column);
        }
        return pks;
    }

    public Column primary() {
        for (Column column : this.columns.values()) {
            if (column.isPrimaryKey() != 1) continue;
            return column;
        }
        return null;
    }

    @Override
    public E clone() {
        Table clone = (Table)super.clone();
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        for (Column column : this.columns.values()) {
            Column col = (Column)column.clone();
            cols.put(col.getName().toUpperCase(), col);
        }
        clone.columns = cols;
        return (E)clone;
    }

    public Table addColumn(Column column) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).addColumn(column);
            return this;
        }
        column.setTable(this);
        if (null == this.columns) {
            this.columns = new LinkedHashMap();
        }
        this.columns.put(column.getName().toUpperCase(), column);
        return this;
    }

    public Long getTtl() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).ttl;
        }
        return this.ttl;
    }

    public Table setTtl(Long ttl) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setTtl(ttl);
            return this;
        }
        this.ttl = ttl;
        return this;
    }

    public Column addColumn(String name, String type, int precision, int scale) {
        Column column = new Column(name, type, precision, scale);
        this.addColumn(column);
        return column;
    }

    public Column addColumn(String name, String type, int precision) {
        Column column = new Column(name, type, precision);
        this.addColumn(column);
        return column;
    }

    public Column addColumn(String name, String type) {
        return this.addColumn(name, type, true, null);
    }

    public Column addColumn(String name, String type, String comment) {
        return (Column)this.addColumn(name, type, true, null).setComment(comment);
    }

    public Column addColumn(String name, TypeMetadata type) {
        return this.addColumn(name, type, true, null);
    }

    public Column addColumn(String name, String type, boolean nullable, Object def) {
        Column column = new Column();
        column.setName(name);
        column.nullable(nullable);
        column.setDefaultValue(def);
        column.setTypeName(type);
        this.addColumn(column);
        return column;
    }

    public Column addColumn(String name, TypeMetadata type, boolean nullable, Object def) {
        Column column = new Column();
        column.setName(name);
        column.nullable(nullable);
        column.setDefaultValue(def);
        column.setTypeMetadata(type);
        this.addColumn(column);
        return column;
    }

    public Table setPrimaryKey(String ... keys) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setPrimaryKey(keys);
            return this;
        }
        if (null != this.primaryKey) {
            for (Column column : this.primaryKey.getColumns().values()) {
                column.primary(false);
            }
        }
        this.primaryKey = new PrimaryKey();
        this.primaryKey.setTable(this);
        if (null != this.columns) {
            for (String key : keys) {
                Column column = this.columns.get(key.toUpperCase());
                if (null != column) {
                    column.primary(true);
                    this.primaryKey.addColumn(column);
                    continue;
                }
                this.primaryKey.addColumn(new Column(key));
            }
        } else {
            throw new AnylineException("\u8bf7\u5148\u8bbe\u7f6ecolumns");
        }
        return this;
    }

    public Table setPrimaryKey(PrimaryKey primaryKey) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setPrimaryKey(primaryKey);
            return this;
        }
        if (null != this.primaryKey) {
            for (Column column : this.primaryKey.getColumns().values()) {
                column.primary(false);
            }
        }
        if (null != this.columns) {
            for (Column column : this.columns.values()) {
                column.primary(false);
            }
        }
        this.primaryKey = primaryKey;
        if (null != primaryKey) {
            primaryKey.setTable(this);
        }
        this.checkColumnPrimary();
        return this;
    }

    public Table checkColumnPrimary() {
        LinkedHashMap<String, Column> pcs;
        if (null != this.primaryKey && null != (pcs = this.primaryKey.getColumns())) {
            for (Column column : pcs.values()) {
                Column col;
                column.primary(true);
                if (null == this.columns || null == (col = this.columns.get(column.getName().toUpperCase()))) continue;
                col.setPrimary(true);
            }
        }
        return this;
    }

    public Table createPrimaryKey() {
        if (null == this.primaryKey && null != this.columns) {
            for (Column column : this.columns.values()) {
                if (column.isPrimaryKey() != 1) continue;
                if (null == this.primaryKey) {
                    this.primaryKey = new PrimaryKey();
                }
                this.primaryKey.addColumn(column);
            }
        }
        return this;
    }

    public Table addTag(Tag tag) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).addTag(tag);
            return this;
        }
        tag.setTable(this);
        if (null == this.tags) {
            this.tags = new LinkedHashMap();
        }
        this.tags.put(tag.getName(), tag);
        return this;
    }

    public Tag addTag(String name, String type) {
        return this.addTag(name, type, true, null);
    }

    public Tag addTag(String name, String type, Object value) {
        Tag tag = new Tag(name, type, value);
        this.addTag(tag);
        return tag;
    }

    public Tag addTag(String name, String type, boolean nullable, Object def) {
        Tag tag = new Tag();
        tag.setName(name);
        tag.nullable(nullable);
        tag.setDefaultValue(def);
        tag.setTypeName(type);
        this.addTag(tag);
        return tag;
    }

    public String getName(boolean greedy) {
        Object result = "";
        if (greedy) {
            if (BasicUtil.isNotEmpty(this.catalog)) {
                result = this.catalog.getName() + ".";
            }
            if (BasicUtil.isNotEmpty(this.schema)) {
                result = (String)result + this.schema.getName() + ".";
            }
            result = (String)result + this.name;
        } else {
            result = this.name;
        }
        return result;
    }

    public String getType() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).type;
        }
        return this.type;
    }

    public Table setType(String type) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setType(type);
            return this;
        }
        this.type = type;
        return this;
    }

    public String getTypeCat() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).typeCat;
        }
        return this.typeCat;
    }

    public Table setTypeCat(String typeCat) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setTypeCat(typeCat);
            return this;
        }
        this.typeCat = typeCat;
        return this;
    }

    public String getTypeSchema() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).typeSchema;
        }
        return this.typeSchema;
    }

    public Table setTypeSchema(String typeSchema) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setTypeSchema(typeSchema);
            return this;
        }
        this.typeSchema = typeSchema;
        return this;
    }

    public String getTypeName() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).typeName;
        }
        return this.typeName;
    }

    public Table setTypeName(String typeName) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setTypeName(typeName);
            return this;
        }
        this.typeName = typeName;
        return this;
    }

    public String getSelfReferencingColumn() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).selfReferencingColumn;
        }
        return this.selfReferencingColumn;
    }

    public Table setSelfReferencingColumn(String selfReferencingColumn) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setSelfReferencingColumn(selfReferencingColumn);
            return this;
        }
        this.selfReferencingColumn = selfReferencingColumn;
        return this;
    }

    public String getRefGeneration() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).refGeneration;
        }
        return this.refGeneration;
    }

    public Table setRefGeneration(String refGeneration) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setRefGeneration(refGeneration);
            return this;
        }
        this.refGeneration = refGeneration;
        return this;
    }

    public List<Column> columns() {
        ArrayList<Column> list = new ArrayList<Column>();
        LinkedHashMap<String, Column> columns = this.getColumns();
        for (Column column : columns.values()) {
            list.add(column);
        }
        return list;
    }

    public LinkedHashMap<String, Column> getColumns() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getColumns();
        }
        if (null == this.columns) {
            this.columns = new LinkedHashMap();
        }
        return this.columns;
    }

    public List<String> getColumns(boolean name) {
        LinkedHashMap<String, Column> columns = this.getColumns();
        ArrayList<String> names = new ArrayList<String>();
        if (null != columns) {
            for (Column column : columns.values()) {
                names.add(column.getName());
            }
        }
        return names;
    }

    public <T extends Column> Table setColumns(LinkedHashMap<String, T> columns) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setColumns(columns);
            return this;
        }
        this.columns = columns;
        if (null != columns) {
            for (Column column : columns.values()) {
                column.setTable(this);
            }
        }
        return this;
    }

    public List<Tag> tags() {
        ArrayList<Tag> list = new ArrayList<Tag>();
        LinkedHashMap<String, Tag> tags = this.getTags();
        for (Tag tag : tags.values()) {
            list.add(tag);
        }
        return list;
    }

    public LinkedHashMap<String, Tag> getTags() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getTags();
        }
        if (null == this.tags) {
            this.tags = new LinkedHashMap();
        }
        return this.tags;
    }

    public Table setTags(LinkedHashMap<String, Tag> tags) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setTags(tags);
            return this;
        }
        this.tags = tags;
        if (null != tags) {
            for (Column column : tags.values()) {
                column.setTable(this);
            }
        }
        return this;
    }

    public Index getIndex(String name) {
        if (null != this.indexes && null != name) {
            return this.indexes.get(name.toUpperCase());
        }
        return null;
    }

    public <T extends Index> LinkedHashMap<String, T> getIndexes() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getIndexes();
        }
        if (null == this.indexes) {
            this.indexes = new LinkedHashMap();
        }
        return this.indexes;
    }

    public LinkedHashMap<String, Column> getPrimaryKeyColumns() {
        PrimaryKey pk = this.getPrimaryKey();
        if (null != pk) {
            return pk.getColumns();
        }
        return new LinkedHashMap<String, Column>();
    }

    public PrimaryKey getPrimaryKey() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getPrimaryKey();
        }
        if (null == this.primaryKey) {
            for (Column column : this.columns.values()) {
                if (column.isPrimaryKey() != 1) continue;
                if (null == this.primaryKey) {
                    this.primaryKey = new PrimaryKey();
                    this.primaryKey.setName("pk_" + this.getName());
                    this.primaryKey.setTable(this);
                }
                this.primaryKey.addColumn(column);
                if (null == column.getPrimaryType()) continue;
                this.primaryKey.setType(column.getPrimaryType());
            }
        }
        if (null == this.primaryKey) {
            for (Index index : this.indexes.values()) {
                if (!index.isPrimary()) continue;
                this.primaryKey = new PrimaryKey();
                this.primaryKey.setName(index.createName());
                this.primaryKey.setTable(this);
                this.primaryKey.setColumns(index.getColumns());
            }
        }
        return this.primaryKey;
    }

    public int getChangePrimary() {
        return this.changePrimary;
    }

    public void setChangePrimary(int changePrimary) {
        this.changePrimary = changePrimary;
    }

    public <T extends Index> Table setIndexes(LinkedHashMap<String, T> indexes) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setIndexes(indexes);
            return this;
        }
        this.indexes = indexes;
        for (Index index : indexes.values()) {
            index.setTable(this);
        }
        return this;
    }

    public Table add(Index index) {
        if (null == this.indexes) {
            this.indexes = new LinkedHashMap();
        }
        index.setTable(this);
        this.indexes.put(index.getName().toUpperCase(), index);
        return this;
    }

    public Table add(Constraint constraint) {
        if (null == this.constraints) {
            this.constraints = new LinkedHashMap();
        }
        constraint.setTable(this);
        this.constraints.put(constraint.getName().toUpperCase(), constraint);
        return this;
    }

    public <T extends Constraint> LinkedHashMap<String, T> getConstraints() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getConstraints();
        }
        if (null == this.constraints) {
            this.constraints = new LinkedHashMap();
        }
        return this.constraints;
    }

    public Table setConstraints(LinkedHashMap<String, Constraint> constraints) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setConstraints(constraints);
            return this;
        }
        this.constraints = constraints;
        return this;
    }

    public Column getColumn(String name) {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getColumn(name);
        }
        if (null == this.columns || null == name) {
            return null;
        }
        return this.columns.get(name.toUpperCase());
    }

    public Column getTag(String name) {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getTag(name);
        }
        return this.tags.get(name.toUpperCase());
    }

    public String getCharset() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).charset;
        }
        return this.charset;
    }

    public Table setCharset(String charset) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setCharset(charset);
            return this;
        }
        this.charset = charset;
        return this;
    }

    public String getCollate() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).collate;
        }
        return this.collate;
    }

    public Table setCollate(String collate) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setCollate(collate);
            return this;
        }
        this.collate = collate;
        return this;
    }

    public int getSrid() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).srid;
        }
        return this.srid;
    }

    public Table setSrid(int srid) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setSrid(srid);
            return this;
        }
        this.srid = srid;
        return this;
    }

    public Skew getSkew() {
        return this.skew;
    }

    public void setSkew(Skew skew) {
        this.skew = skew;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Long getDataFree() {
        return this.dataFree;
    }

    public Table setDataFree(Long dataFree) {
        this.dataFree = dataFree;
        return this;
    }

    public String getEngineParameters() {
        return this.engineParameters;
    }

    public Table setEngineParameters(String engineParameters) {
        this.engineParameters = engineParameters;
        return this;
    }

    public Table getInherit() {
        return this.inherit;
    }

    public Table setInherit(Table inherit) {
        this.inherit = inherit;
        return this;
    }

    public Table setInherit(String setInherit) {
        this.inherit = new Table<E>(setInherit);
        return this;
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    public boolean isAutoDropColumn() {
        return this.autoDropColumn;
    }

    public Table setAutoDropColumn(boolean autoDropColumn) {
        this.autoDropColumn = autoDropColumn;
        return this;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Table setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public Table setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public Long getDataRows() {
        return this.dataRows;
    }

    public Table setDataRows(Long dataRows) {
        this.dataRows = dataRows;
        return this;
    }

    public Long getDataLength() {
        return this.dataLength;
    }

    public int getTemporary() {
        return this.temporary;
    }

    public boolean isTemporary() {
        return this.temporary == 1;
    }

    public Table setTemporary(int temporary) {
        this.temporary = temporary;
        return this;
    }

    public Table setTemporary(boolean temporary) {
        this.temporary = temporary ? 1 : 0;
        return this;
    }

    public Table setDataLength(Long dataLength) {
        this.dataLength = dataLength;
        return this;
    }

    public Long getIncrement() {
        return this.increment;
    }

    public Table setIncrement(Long increment) {
        this.increment = increment;
        return this;
    }

    public Long getIndexLength() {
        return this.indexLength;
    }

    public Table setIndexLength(Long indexLength) {
        this.indexLength = indexLength;
        return this;
    }

    public boolean isSort() {
        return this.sort;
    }

    public Table setSort(boolean sort) {
        this.sort = sort;
        return this;
    }

    public Map<String, Object> map() {
        this.clearPropertyTable();
        return BeanUtil.object2map(this);
    }

    public String json() {
        this.clearPropertyTable();
        return BeanUtil.object2json(this);
    }

    public void clearPropertyTable() {
        if (null != this.columns) {
            for (Column column : this.columns.values()) {
                column.setTable((Table)null);
            }
        }
        if (null != this.tags) {
            for (Tag tag : this.tags.values()) {
                tag.setTable((Table)null);
            }
        }
        if (null != this.indexes) {
            for (Index index : this.indexes.values()) {
                index.setTable((Table)null);
            }
        }
        if (null != this.constraints) {
            for (Constraint constraint : this.constraints.values()) {
                constraint.setTable((Table)null);
            }
        }
        if (null != this.primaryKey) {
            this.primaryKey.setTable((Table)null);
        }
    }

    public Table sort(boolean nullFirst) {
        this.sort = true;
        if (null != this.columns) {
            Column.sort(this.columns, nullFirst);
        }
        return this;
    }

    public Table sort() {
        return this.sort(false);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getKeyword()).append(":");
        if (null != this.catalog && BasicUtil.isNotEmpty(this.catalog.getName())) {
            builder.append(this.catalog.getName()).append(".");
        }
        if (null != this.schema && BasicUtil.isNotEmpty(this.schema.getName())) {
            builder.append(this.schema.getName()).append(".");
        }
        builder.append(this.name);
        return builder.toString();
    }

    public boolean equals(Table table) {
        return this.equals(table, true);
    }

    public boolean equals(Table table, boolean ignoreCase) {
        return this.equals(table, ignoreCase, false);
    }

    public boolean equals(Table table, boolean ignoreCase, boolean ignoreSchema) {
        if (null == table) {
            return false;
        }
        if (!ignoreSchema) {
            boolean catalog_equals = BasicUtil.equals((Object)this.catalog, (Object)table.getCatalog(), ignoreCase);
            if (!catalog_equals) {
                return false;
            }
            boolean schema_equals = BasicUtil.equals((Object)this.schema, (Object)table.getSchema(), ignoreCase);
            if (!schema_equals) {
                return false;
            }
        }
        if (!BasicUtil.equals(BasicUtil.evl(this.getComment()), BasicUtil.evl(table.getComment()))) {
            return false;
        }
        boolean name_equals = BasicUtil.equals(this.name, table.getName());
        return name_equals;
    }

    public boolean primaryEquals(Table table) {
        if (null == table) {
            return false;
        }
        PrimaryKey pks = this.getPrimaryKey();
        PrimaryKey tpks = table.getPrimaryKey();
        if (null == pks) {
            return null == tpks;
        }
        return pks.equals(tpks);
    }

    public TableDiffer compare(Table table, MetadataDiffer.DIRECT direct) {
        Table direct_ = null;
        direct_ = direct == MetadataDiffer.DIRECT.DEST ? table : this;
        return TableDiffer.compare(this, table, direct_);
    }

    public TableDiffer compare(Table table) {
        return this.compare(table, MetadataDiffer.DIRECT.ORIGIN);
    }

    static {
        for (TYPE type : TYPE.values()) {
            types.put(type.value, type);
        }
    }

    public static class Distribution {
        private TYPE type;
        private int buckets = -1;
        private boolean autoBucket = true;
        private LinkedHashMap<String, Column> columns;
        private LinkedHashMap<String, String> orders;

        public Distribution() {
        }

        public Distribution(TYPE type, int buckets, String ... columns) {
            this.setBuckets(buckets);
            this.setType(type);
            this.setColumns(columns);
        }

        public Distribution(TYPE type, String ... columns) {
            this.setType(type);
            this.setColumns(columns);
        }

        public int getBuckets() {
            return this.buckets;
        }

        public Distribution setBuckets(int buckets) {
            this.buckets = buckets;
            this.setAutoBucket(false);
            return this;
        }

        public Distribution order(String column, String type) {
            if (null == this.orders) {
                this.orders = new LinkedHashMap();
            }
            this.orders.put(column, type);
            return this;
        }

        public Distribution order(String column) {
            return this.order(column, null);
        }

        public LinkedHashMap<String, String> orders() {
            return this.orders;
        }

        public boolean isAutoBucket() {
            return this.autoBucket;
        }

        public void setAutoBucket(boolean autoBucket) {
            this.autoBucket = autoBucket;
        }

        public TYPE getType() {
            return this.type;
        }

        public Distribution setType(TYPE type) {
            this.type = type;
            return this;
        }

        public LinkedHashMap<String, Column> getColumns() {
            return this.columns;
        }

        public Distribution setColumns(LinkedHashMap<String, Column> columns) {
            this.columns = columns;
            return this;
        }

        public Distribution setColumns(String ... columns) {
            if (null == this.columns) {
                this.columns = new LinkedHashMap();
            }
            List<String> list = SQLUtil.columns(columns);
            for (String column : list) {
                this.columns.put(column.toUpperCase(), new Column(column));
            }
            return this;
        }

        public static enum TYPE {
            HASH("HASH", "\u54c8\u5e0c\u5206\u6876"),
            RANDOM("RANDOM", "\u968f\u673a\u5206\u6876");

            final String code;
            final String name;

            private TYPE(String code, String name) {
                this.code = code;
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public String getCode() {
                return this.code;
            }
        }
    }

    public static class Key {
        private TYPE type;
        private LinkedHashMap<String, Column> columns;

        public TYPE getType() {
            return this.type;
        }

        public Key setType(TYPE type) {
            this.type = type;
            return this;
        }

        public LinkedHashMap<String, Column> getColumns() {
            return this.columns;
        }

        public Key setColumns(LinkedHashMap<String, Column> columns) {
            this.columns = columns;
            return this;
        }

        public Key setColumns(String ... columns) {
            if (null == this.columns) {
                this.columns = new LinkedHashMap();
            }
            List<String> list = SQLUtil.columns(columns);
            for (String column : list) {
                this.columns.put(column.toUpperCase(), new Column(column));
            }
            return this;
        }

        public static enum TYPE {
            DUPLICATE("DUPLICATE", "\u6392\u5e8f\u5217"),
            AGGREGATE("AGGREGATE", "\u7ef4\u5ea6\u5217"),
            UNIQUE("UNIQUE", "\u4e3b\u952e\u5217");

            final String code;
            final String name;

            private TYPE(String code, String name) {
                this.code = code;
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public String getCode() {
                return this.code;
            }
        }
    }

    public static class Partition
    extends TableAffiliation
    implements Serializable {
        private List<Slice> slices = new ArrayList<Slice>();
        private Object min;
        private Object max;
        private List<Object> values;
        private int modulus;
        private int remainder;
        private TYPE type;
        private LinkedHashMap<String, Column> columns;
        public static final String FIELD_NAME = "NAME";
        public static final String FIELD_TYPE = "TYPE";
        public static final String FIELD_COLUMN = "COLUMN";
        public static final String FIELD_MIN = "MIN";
        public static final String FIELD_MAX = "MAX";
        public static final String FIELD_VALUE = "VALUE";
        public static final String FIELD_LESS = "LESS";
        public static final String FIELD_INTERVAL = "INTERVAL";
        public static final String FIELD_UNIT = "UNIT";
        public static final String FIELD_MODULUS = "MODULUS";
        public static final String FIELD_REMAINDER = "REMAINDER";

        public Partition() {
        }

        public Partition(TYPE type) {
            this.type = type;
        }

        public Partition(TYPE type, String ... columns) {
            this.type = type;
            this.columns = new LinkedHashMap();
            for (String column : columns) {
                this.columns.put(column.toUpperCase(), new Column(column));
            }
        }

        public Partition addSlice(Slice slice) {
            this.slices.add(slice);
            return this;
        }

        public List<Slice> getSlices() {
            return this.slices;
        }

        public TYPE getType() {
            return this.type;
        }

        public Partition setType(TYPE type) {
            this.type = type;
            return this;
        }

        public LinkedHashMap<String, Column> getColumns() {
            return this.columns;
        }

        public Partition setColumns(LinkedHashMap<String, Column> columns) {
            this.columns = columns;
            return this;
        }

        public Partition setColumns(String ... columns) {
            this.columns = new LinkedHashMap();
            List<String> list = SQLUtil.columns(columns);
            for (String column : list) {
                this.columns.put(column.toUpperCase(), new Column(column));
            }
            return this;
        }

        public Partition addColumn(Column column) {
            if (null == this.columns) {
                this.columns = new LinkedHashMap();
            }
            this.columns.put(column.getName().toUpperCase(), column);
            return this;
        }

        public Partition addColumn(String column) {
            return this.addColumn(new Column(column));
        }

        public Partition setRange(Object min, Object max) {
            this.min = min;
            this.max = max;
            return this;
        }

        public Object getMin() {
            return this.min;
        }

        public Partition setSlices(List<Slice> slices) {
            this.slices = slices;
            return this;
        }

        public Partition setMin(Object min) {
            this.min = min;
            return this;
        }

        public Object getMax() {
            return this.max;
        }

        public Partition setMax(Object max) {
            this.max = max;
            return this;
        }

        public List<Object> getValues() {
            return this.values;
        }

        public Partition setValues(List<Object> values) {
            this.values = values;
            return this;
        }

        public Partition addValues(Object ... items) {
            if (null == this.values) {
                this.values = new ArrayList<Object>();
            }
            for (Object item : items) {
                if (item instanceof Collection) {
                    Collection cons = (Collection)item;
                    for (Object con : cons) {
                        this.addValues(con);
                    }
                    continue;
                }
                if (null != item && item.getClass().isArray()) {
                    int len = Array.getLength(item);
                    for (int i = 0; i < len; ++i) {
                        this.addValues(Array.get(item, i));
                    }
                    continue;
                }
                this.values.add(item);
            }
            return this;
        }

        public int getModulus() {
            return this.modulus;
        }

        public Partition setModulus(int modulus) {
            this.modulus = modulus;
            return this;
        }

        public Partition setHash(int modulus, int remainder) {
            this.modulus = modulus;
            this.remainder = remainder;
            return this;
        }

        public int getRemainder() {
            return this.remainder;
        }

        public Partition setRemainder(int remainder) {
            this.remainder = remainder;
            return this;
        }

        public static enum TYPE {
            LIST,
            RANGE,
            HASH;

        }

        public static class Slice
        extends TableAffiliation
        implements Serializable {
            private String name;
            private Object min;
            private Object max;
            private List<Object> values;
            private LinkedHashMap<String, Object> less;
            private int interval;
            private String unit;
            private int modulus;
            private int remainder;
            public static final String FIELD_NAME = "NAME";
            public static final String FIELD_FOR = "FOR";
            public static final String FIELD_MIN = "MIN";
            public static final String FIELD_MAX = "MAX";
            public static final String FIELD_VALUE = "VALUE";
            public static final String FIELD_LESS = "LESS";
            public static final String FIELD_INTERVAL = "INTERVAL";
            public static final String FIELD_UNIT = "UNIT";

            public Slice() {
            }

            public Slice(String name) {
                this.name = name;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public Slice setName(String name) {
                this.name = name;
                return this;
            }

            public Object getMin() {
                return this.min;
            }

            public Slice setMin(Object min) {
                this.min = min;
                return this;
            }

            public List<Object> getValues() {
                return this.values;
            }

            public Slice setValues(List<Object> values) {
                this.values = values;
                return this;
            }

            public Slice setValues(Object ... values) {
                if (null == this.values) {
                    this.values = new ArrayList<Object>();
                }
                if (null != values) {
                    for (Object value : values) {
                        this.values.add(value);
                    }
                }
                return this;
            }

            public Slice addValue(Object value) {
                if (null == value) {
                    return this;
                }
                if (null == this.values) {
                    this.values = new ArrayList<Object>();
                }
                if (value instanceof Collection) {
                    this.values.addAll((Collection)value);
                } else {
                    this.values.add(value);
                }
                return this;
            }

            public Slice addValues(Object ... values) {
                if (null != values) {
                    for (Object value : values) {
                        this.addValue(value);
                    }
                }
                return this;
            }

            public Object getMax() {
                return this.max;
            }

            public Slice setMax(Object max) {
                this.max = max;
                return this;
            }

            public int getModulus() {
                return this.modulus;
            }

            public Slice setModulus(int modulus) {
                this.modulus = modulus;
                return this;
            }

            public int getRemainder() {
                return this.remainder;
            }

            public Slice setRemainder(int remainder) {
                this.remainder = remainder;
                return this;
            }

            public int getInterval() {
                return this.interval;
            }

            public Slice setInterval(int interval) {
                this.interval = interval;
                return this;
            }

            public LinkedHashMap<String, Object> getLess() {
                return this.less;
            }

            public Slice setLess(String column, Object less) {
                if (null == this.less) {
                    this.less = new LinkedHashMap();
                }
                this.less.put(column.toUpperCase(), less);
                return this;
            }

            public String getUnit() {
                return this.unit;
            }

            public Slice setUnit(String unit) {
                this.unit = unit;
                return this;
            }
        }
    }

    public static class Skew {
        private LinkedHashMap<String, List<Object>> values = new LinkedHashMap();
        private String store;

        public Skew addValue(String column, Object ... values) {
            List<Object> list = this.values.get(column);
            if (null == list) {
                list = new ArrayList<Object>();
                this.values.put(column, list);
            }
            for (Object value : values) {
                list.add(value);
            }
            return this;
        }

        public LinkedHashMap<String, List<Object>> values() {
            return this.values;
        }

        public String store() {
            return this.store;
        }

        public Skew store(String store) {
            this.store = store;
            return this;
        }
    }

    public static class Store
    extends TableAffiliation {
        private String rowFormat;
        private String fileFormat;
        private String handler;

        public String getRowFormat() {
            return this.rowFormat;
        }

        public void setRowFormat(String rowFormat) {
            this.rowFormat = rowFormat;
        }

        public String getFileFormat() {
            return this.fileFormat;
        }

        public void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        public String getHandler() {
            return this.handler;
        }

        public void setHandler(String handler) {
            this.handler = handler;
        }
    }

    public static enum TYPE implements Type
    {
        NORMAL(1),
        VIEW(2),
        PARENT(4),
        MASTER(8),
        PARTITION(16),
        VERTEX(32),
        EDGE(64);

        public final int value;

        private TYPE(int value) {
            this.value = value;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    public static class Cluster
    extends Distribution {
    }

    static enum STRUCT {
        COLUMN(4),
        PRIMARY(8),
        FOREIGN(16),
        INDEX(32),
        CONSTRAINT(64),
        DDL(32768);

        public final int value;

        private STRUCT(int value) {
            this.value = value;
        }
    }
}

