/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity.generator;

import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.entity.generator.init.RandomGenerator;
import org.anyline.entity.generator.init.SnowflakeGenerator;
import org.anyline.entity.generator.init.TimeGenerator;
import org.anyline.entity.generator.init.TimestampGenerator;
import org.anyline.entity.generator.init.UUIDGenerator;
import org.anyline.metadata.Column;
import org.anyline.metadata.type.DatabaseType;

public interface PrimaryGenerator {
    public boolean create(Object var1, DatabaseType var2, String var3, List<String> var4, String var5);

    public boolean create(Object var1, DatabaseType var2, String var3, LinkedHashMap<String, Column> var4, String var5);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum GENERATOR implements PrimaryGenerator
    {
        DISABLE{

            @Override
            public boolean create(Object entity, DatabaseType type, String table, List<String> pks, String other) {
                return false;
            }

            @Override
            public boolean create(Object entity, DatabaseType type, String table, LinkedHashMap<String, Column> pks, String other) {
                return false;
            }
        }
        ,
        AUTO{

            @Override
            public boolean create(Object entity, DatabaseType type, String table, List<String> pks, String other) {
                return false;
            }

            @Override
            public boolean create(Object entity, DatabaseType type, String table, LinkedHashMap<String, Column> pks, String other) {
                return false;
            }
        }
        ,
        RANDOM{

            @Override
            public boolean create(Object entity, DatabaseType type, String table, List<String> pks, String other) {
                return new RandomGenerator().create(entity, type, table, pks, other);
            }

            @Override
            public boolean create(Object entity, DatabaseType type, String table, LinkedHashMap<String, Column> pks, String other) {
                return new RandomGenerator().create(entity, type, table, pks, other);
            }
        }
        ,
        SNOWFLAKE{

            @Override
            public boolean create(Object entity, DatabaseType type, String table, List<String> pks, String other) {
                return new SnowflakeGenerator().create(entity, type, table, pks, other);
            }

            @Override
            public boolean create(Object entity, DatabaseType type, String table, LinkedHashMap<String, Column> pks, String other) {
                return new SnowflakeGenerator().create(entity, type, table, pks, other);
            }
        }
        ,
        UUID{

            @Override
            public boolean create(Object entity, DatabaseType type, String table, List<String> pks, String other) {
                return new UUIDGenerator().create(entity, type, table, pks, other);
            }

            @Override
            public boolean create(Object entity, DatabaseType type, String table, LinkedHashMap<String, Column> pks, String other) {
                return new UUIDGenerator().create(entity, type, table, pks, other);
            }
        }
        ,
        TIME{

            @Override
            public boolean create(Object entity, DatabaseType type, String table, List<String> pks, String other) {
                return new TimeGenerator().create(entity, type, table, pks, other);
            }

            @Override
            public boolean create(Object entity, DatabaseType type, String table, LinkedHashMap<String, Column> pks, String other) {
                return new TimeGenerator().create(entity, type, table, pks, other);
            }
        }
        ,
        TIMESTAMP{

            @Override
            public boolean create(Object entity, DatabaseType type, String table, List<String> pks, String other) {
                return new TimestampGenerator().create(entity, type, table, pks, other);
            }

            @Override
            public boolean create(Object entity, DatabaseType type, String table, LinkedHashMap<String, Column> pks, String other) {
                return new TimestampGenerator().create(entity, type, table, pks, other);
            }
        };

    }
}

