/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.lzo;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoCompressor;
import org.anarres.lzo.LzoConstraint;
import org.anarres.lzo.LzoLibrary;
import org.anarres.lzo.lzo_uintp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LzoOutputStream
extends OutputStream {
    private static final Log LOG = LogFactory.getLog((String)LzoOutputStream.class.getName());
    protected final OutputStream out;
    private final LzoCompressor compressor;
    private final byte[] inputBuffer;
    private int inputBufferLen;
    private byte[] inputHoldoverBuffer;
    private int inputHoldoverBufferPos;
    private int inputHoldoverBufferLen;
    private final byte[] outputBuffer;
    private final lzo_uintp outputBufferLen = new lzo_uintp();

    public LzoOutputStream(@Nonnull OutputStream out, @Nonnull LzoCompressor compressor, @CheckForSigned int inputBufferSize) {
        if (inputBufferSize <= 0) {
            inputBufferSize = 65536;
        }
        this.out = out;
        this.compressor = compressor;
        this.inputBuffer = new byte[inputBufferSize];
        this.outputBuffer = new byte[inputBufferSize + compressor.getCompressionOverhead(inputBufferSize)];
        this.reset();
    }

    public LzoOutputStream(@Nonnull OutputStream out, @Nonnull LzoCompressor compressor) {
        this(out, compressor, 0);
    }

    public LzoOutputStream(@Nonnull OutputStream out) {
        this(out, LzoLibrary.getInstance().newCompressor(null, null));
    }

    @Nonnull
    public LzoCompressor getCompressor() {
        return this.compressor;
    }

    @Nonnull
    public LzoAlgorithm getAlgorithm() {
        return this.getCompressor().getAlgorithm();
    }

    @Nonnull
    public LzoConstraint[] getConstraints() {
        return this.getCompressor().getConstraints();
    }

    private void reset() {
        this.inputBufferLen = 0;
        this.inputHoldoverBuffer = null;
        this.inputHoldoverBufferPos = -1;
        this.inputHoldoverBufferLen = -1;
        this.outputBufferLen.value = 0;
    }

    private void logState(@Nonnull String when) {
        LOG.info((Object)"\n");
        LOG.info((Object)(when + " Input buffer length=" + this.inputBufferLen + "/" + this.inputBuffer.length));
        if (this.inputHoldoverBuffer == null) {
            LOG.info((Object)(when + " Input holdover = null"));
        } else {
            LOG.info((Object)(when + " Input holdover pos=" + this.inputHoldoverBufferPos + "; length=" + this.inputHoldoverBufferLen));
        }
        LOG.info((Object)(when + " Output buffer length=" + this.outputBufferLen + "/" + this.outputBuffer.length));
        this.testInvariants();
    }

    private boolean testInvariants() {
        if (this.inputHoldoverBuffer != null) {
            if (this.inputBufferLen != 0 && this.inputBufferLen != this.inputBuffer.length) {
                throw new IllegalStateException("Funny input buffer length " + this.inputBufferLen + " with array size " + this.inputBuffer.length + " and holdover.");
            }
            if (this.inputHoldoverBufferPos < 0) {
                throw new IllegalStateException("Using holdover buffer, but invalid holdover position " + this.inputHoldoverBufferPos);
            }
            if (this.inputHoldoverBufferLen < 0) {
                throw new IllegalStateException("Using holdover buffer, but invalid holdover length " + this.inputHoldoverBufferLen);
            }
        } else {
            if (this.inputHoldoverBufferPos != -1) {
                throw new IllegalStateException("No holdover buffer, but valid holdover position " + this.inputHoldoverBufferPos);
            }
            if (this.inputHoldoverBufferLen != -1) {
                throw new IllegalStateException("No holdover buffer, but valid holdover length " + this.inputHoldoverBufferLen);
            }
        }
        if (this.outputBufferLen.value < 0) {
            throw new IllegalStateException("Output buffer overrun length=" + this.outputBufferLen);
        }
        return true;
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException("Illegal range in buffer: Buffer length=" + b.length + ", offset=" + off + ", length=" + len);
        }
        if (this.inputHoldoverBuffer != null) {
            throw new IllegalStateException("Cannot accept input while holdover is present.");
        }
        this.inputHoldoverBuffer = Arrays.copyOfRange(b, off, off + len);
        this.inputHoldoverBufferPos = off;
        this.inputHoldoverBufferLen = len;
        this.compact();
        while (this.inputHoldoverBuffer != null || this.inputBufferLen == this.inputBuffer.length) {
            this.compress();
        }
    }

    public void flush() throws IOException {
        while (this.inputHoldoverBuffer != null || this.inputBufferLen > 0) {
            this.compress();
        }
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private void compact() {
        if (this.inputHoldoverBuffer == null) {
            assert (this.testInvariants());
            return;
        }
        int remaining = this.inputBuffer.length - this.inputBufferLen;
        if (this.inputHoldoverBufferLen <= remaining) {
            System.arraycopy(this.inputHoldoverBuffer, this.inputHoldoverBufferPos, this.inputBuffer, this.inputBufferLen, this.inputHoldoverBufferLen);
            this.inputBufferLen += this.inputHoldoverBufferLen;
            this.inputHoldoverBuffer = null;
            this.inputHoldoverBufferPos = -1;
            this.inputHoldoverBufferLen = -1;
        } else if (this.inputBufferLen != 0) {
            System.arraycopy(this.inputHoldoverBuffer, this.inputHoldoverBufferPos, this.inputBuffer, this.inputBufferLen, remaining);
            this.inputBufferLen += remaining;
            this.inputHoldoverBufferPos += remaining;
            this.inputHoldoverBufferLen -= remaining;
        }
        assert (this.testInvariants());
    }

    private void compress() throws IOException {
        int compressBufferLen;
        int compressBufferPos;
        byte[] compressBuffer;
        if (this.inputBufferLen > 0) {
            compressBuffer = (byte[])this.inputBuffer.clone();
            compressBufferPos = 0;
            compressBufferLen = this.inputBufferLen;
            this.inputBufferLen = 0;
        } else if (this.inputHoldoverBuffer != null) {
            compressBuffer = (byte[])this.inputHoldoverBuffer.clone();
            compressBufferPos = this.inputHoldoverBufferPos;
            compressBufferLen = Math.min(this.inputBuffer.length, this.inputHoldoverBufferLen);
            assert (compressBufferLen == this.inputBuffer.length) : "Compressing less than one block of holdover.";
            this.inputHoldoverBufferPos += compressBufferLen;
            this.inputHoldoverBufferLen -= compressBufferLen;
        } else {
            throw new IllegalStateException("compress() called with no input.");
        }
        this.compact();
        this.outputBufferLen.value = this.outputBuffer.length;
        try {
            int code = this.compressor.compress(compressBuffer, compressBufferPos, compressBufferLen, this.outputBuffer, 0, this.outputBufferLen);
            if (code != 0) {
                this.logState("LZO error: " + code);
                throw new IllegalArgumentException(this.compressor.toErrorString(code));
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.logState("IndexOutOfBoundsException: " + e);
            throw new IOException(e);
        }
        this.writeBlock(compressBuffer, compressBufferPos, compressBufferLen, this.outputBuffer, 0, this.outputBufferLen.value);
    }

    protected void writeBlock(@Nonnull byte[] inputData, @Nonnegative int inputPos, @Nonnegative int inputLen, @Nonnull byte[] outputData, @Nonnegative int outputPos, @Nonnegative int outputLen) throws IOException {
        this.writeInt(inputLen);
        this.writeInt(outputLen);
        this.out.write(outputData, outputPos, outputLen);
    }

    protected void writeInt(int v) throws IOException {
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v & 0xFF);
    }
}

