/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.model.impl;

import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.impl.TaskImpl;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;
import org.activiti.runtime.api.model.impl.ListConverter;
import org.activiti.runtime.api.model.impl.ModelConverter;

public class APITaskConverter
extends ListConverter<Task, org.activiti.api.task.model.Task>
implements ModelConverter<Task, org.activiti.api.task.model.Task> {
    public org.activiti.api.task.model.Task from(Task internalTask) {
        TaskImpl task = new TaskImpl(internalTask.getId(), internalTask.getName(), this.calculateStatus(internalTask));
        task.setProcessDefinitionId(internalTask.getProcessDefinitionId());
        task.setProcessInstanceId(internalTask.getProcessInstanceId());
        task.setAssignee(internalTask.getAssignee());
        task.setClaimedDate(internalTask.getClaimTime());
        task.setCreatedDate(internalTask.getCreateTime());
        task.setDueDate(internalTask.getDueDate());
        task.setDescription(internalTask.getDescription());
        task.setOwner(internalTask.getOwner());
        task.setParentTaskId(internalTask.getParentTaskId());
        task.setPriority(internalTask.getPriority());
        return task;
    }

    private Task.TaskStatus calculateStatus(Task source) {
        if (source instanceof TaskEntity && (((TaskEntity)source).isDeleted() || ((TaskEntity)source).isCanceled())) {
            return Task.TaskStatus.CANCELLED;
        }
        if (source.isSuspended()) {
            return Task.TaskStatus.SUSPENDED;
        }
        if (source.getAssignee() != null && !source.getAssignee().isEmpty()) {
            return Task.TaskStatus.ASSIGNED;
        }
        return Task.TaskStatus.CREATED;
    }
}

