/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class SplitSubClassAxioms
extends AbstractCompositeOntologyChange {
    public SplitSubClassAxioms(Collection<OWLOntology> ontologies, OWLDataFactory dataFactory) {
        super(dataFactory);
        ontologies.forEach(o -> o.axioms(AxiomType.SUBCLASS_OF).forEach(ax -> this.split((OWLOntology)o, (OWLSubClassOfAxiom)ax)));
    }

    protected void split(OWLOntology o, OWLSubClassOfAxiom ax) {
        ConjunctSplitter splitter = new ConjunctSplitter();
        ax.getSuperClass().accept(splitter);
        if (splitter.result.size() > 1) {
            this.addChange(new RemoveAxiom(o, ax));
            splitter.result.forEach(desc -> this.addChange(new AddAxiom(o, this.df.getOWLSubClassOfAxiom(ax.getSubClass(), (OWLClassExpression)desc))));
        }
    }

    private static class ConjunctSplitter
    implements OWLClassExpressionVisitor {
        final Set<OWLClassExpression> result = new HashSet<OWLClassExpression>();

        ConjunctSplitter() {
        }

        @Override
        public void doDefault(Object object) {
            this.result.add((OWLClassExpression)object);
        }

        @Override
        public void visit(OWLObjectIntersectionOf ce) {
            ce.operands().forEach(op -> op.accept(this));
        }
    }
}

