/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.dom;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSStyleSheetImpl;
import com.gargoylesoftware.css.dom.DOMExceptionImpl;
import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.util.LangUtils;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class CSSUnknownRuleImpl
extends AbstractCSSRuleImpl {
    private String text_;

    public CSSUnknownRuleImpl(CSSStyleSheetImpl parentStyleSheet, AbstractCSSRuleImpl parentRule, String text) {
        super(parentStyleSheet, parentRule);
        this.text_ = text;
    }

    @Override
    public String getCssText() {
        if (null == this.text_) {
            return "";
        }
        return this.text_;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            CSSOMParser parser = new CSSOMParser();
            AbstractCSSRuleImpl r = parser.parseRule(cssText);
            if (!(r instanceof CSSUnknownRuleImpl)) {
                throw new DOMExceptionImpl(13, 7);
            }
            this.text_ = ((CSSUnknownRuleImpl)r).text_;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public String toString() {
        return this.getCssText();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSUnknownRuleImpl)) {
            return false;
        }
        CSSUnknownRuleImpl cur = (CSSUnknownRuleImpl)obj;
        return super.equals(obj) && LangUtils.equals(this.getCssText(), cur.getCssText());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.text_);
        return hash;
    }
}

