/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class HTMLAllCollection
extends HTMLCollection {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF68})
    public HTMLAllCollection() {
    }

    public HTMLAllCollection(DomNode parentScope) {
        super(parentScope, false);
    }

    @Override
    public Object item(Object index) {
        BrowserVersion browser;
        Double numb;
        if (index instanceof String) {
            String name = (String)index;
            Object result = this.namedItem(name);
            if (null != result && !Undefined.isUndefined((Object)result)) {
                return result;
            }
            numb = Double.NaN;
            browser = this.getBrowserVersion();
            if (!browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_DO_NOT_CONVERT_STRINGS_TO_NUMBER)) {
                numb = ScriptRuntime.toNumber((Object)index);
            }
            if (numb.isNaN()) {
                return null;
            }
        } else {
            numb = ScriptRuntime.toNumber((Object)index);
            browser = this.getBrowserVersion();
        }
        if (numb < 0.0) {
            return null;
        }
        if (!browser.hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_ITEM_FUNCT_SUPPORTS_DOUBLE_INDEX_ALSO) && (Double.isInfinite(numb) || numb != Math.floor(numb))) {
            return null;
        }
        Object object = this.get(numb.intValue(), (Scriptable)this);
        if (object == NOT_FOUND) {
            return null;
        }
        return object;
    }

    @Override
    public final Object namedItem(String name) {
        List<DomNode> elements = this.getElements();
        ArrayList<DomElement> matching = new ArrayList<DomElement>();
        BrowserVersion browser = this.getBrowserVersion();
        for (DomNode next : elements) {
            DomElement elem;
            if (!(next instanceof DomElement) || !name.equals((elem = (DomElement)next).getAttributeDirect("name")) && !name.equals(elem.getId())) continue;
            matching.add(elem);
        }
        if (matching.size() == 1 || matching.size() > 1 && browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_NO_COLLECTION_FOR_MANY_HITS)) {
            return this.getScriptableForElement(matching.get(0));
        }
        if (matching.isEmpty()) {
            if (browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_NULL_IF_NAMED_ITEM_NOT_FOUND)) {
                return null;
            }
            return Undefined.instance;
        }
        DomNode domNode = this.getDomNodeOrNull();
        ArrayList<DomNode> nodes = new ArrayList<DomNode>(matching);
        HTMLCollection collection = new HTMLCollection(domNode, nodes);
        collection.setAvoidObjectDetection(true);
        return collection;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        BrowserVersion browser = this.getBrowserVersion();
        boolean nullIfNotFound = false;
        if (browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_INTEGER_INDEX)) {
            if (args[0] instanceof Number) {
                double val = ((Number)args[0]).doubleValue();
                if (val != (double)((int)val)) {
                    return null;
                }
                if (val >= 0.0) {
                    nullIfNotFound = true;
                }
            } else {
                String val = Context.toString((Object)args[0]);
                try {
                    args[0] = Integer.parseInt(val);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        Object value = super.call(cx, scope, thisObj, args);
        if (nullIfNotFound && Undefined.isUndefined((Object)value)) {
            return null;
        }
        return value;
    }

    @Override
    protected boolean supportsParentheses() {
        return true;
    }
}

