/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.WindowProxy;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class MessageEvent
extends Event {
    private Object data_;
    private String origin_;
    private String lastEventId_;
    private Window source_;
    private Object ports_;

    public MessageEvent() {
        this.setType("message");
        this.origin_ = "";
        this.lastEventId_ = "";
        this.data_ = Undefined.instance;
    }

    public MessageEvent(Object data) {
        this();
        this.data_ = data;
    }

    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF68})
    public void jsConstructor(String type, ScriptableObject details) {
        super.jsConstructor(type, details);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONMESSAGE_DEFAULT_DATA_NULL)) {
            this.data_ = null;
        }
        String origin = "";
        String lastEventId = "";
        if (details != null && !Undefined.isUndefined((Object)details)) {
            Object detailLastEventId;
            this.data_ = details.get((Object)"data");
            String detailOrigin = (String)details.get((Object)"origin");
            if (detailOrigin != null) {
                origin = detailOrigin;
            }
            if ((detailLastEventId = details.get((Object)"lastEventId")) != null) {
                lastEventId = Context.toString((Object)detailLastEventId);
            }
            this.source_ = null;
            Object detailSource = details.get((Object)"source");
            if (detailSource instanceof Window) {
                this.source_ = (Window)detailSource;
            } else if (detailSource instanceof WindowProxy) {
                this.source_ = ((WindowProxy)detailSource).getDelegee();
            }
            this.ports_ = details.get((Object)"ports");
        }
        this.origin_ = origin;
        this.lastEventId_ = lastEventId;
    }

    @JsxFunction
    public void initMessageEvent(String type, boolean canBubble, boolean cancelable, Object data, String origin, String lastEventId, Window source, Object ports) {
        this.initEvent(type, canBubble, cancelable);
        this.data_ = data;
        this.origin_ = origin;
        this.lastEventId_ = lastEventId;
        this.source_ = source;
        if (!(Undefined.isUndefined((Object)ports) || ports instanceof NativeArray || ports instanceof Scriptable && ScriptableObject.hasProperty((Scriptable)((Scriptable)ports), (String)"length"))) {
            throw ScriptRuntime.typeError((String)"Argument 8 of MessageEvent.initMessageEvent can't be converted to a sequence.");
        }
        this.ports_ = ports;
    }

    @JsxGetter
    public Object getData() {
        return this.data_;
    }

    @JsxGetter
    public String getOrigin() {
        return this.origin_;
    }

    public void setOrigin(String origin) {
        this.origin_ = origin;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF68})
    public String getLastEventId() {
        return this.lastEventId_;
    }

    @JsxGetter
    public Window getSource() {
        return this.source_;
    }

    @JsxGetter
    public Object getPorts() {
        return this.ports_;
    }
}

