/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ES6Iterator;
import net.sourceforge.htmlunit.corejs.javascript.IdScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
public class URLSearchParams
extends SimpleScriptable {
    public static final String URL_SEARCH_PARMS_TAG = "URLSearchParams";
    private final List<Map.Entry<String, String>> params_ = new LinkedList<Map.Entry<String, String>>();

    public URLSearchParams() {
    }

    @JsxConstructor
    public URLSearchParams(Object params) {
        if (params == null || Undefined.isUndefined((Object)params)) {
            return;
        }
        this.splitQuery(Context.toString((Object)params));
    }

    private void splitQuery(String params) {
        String[] parts;
        if (StringUtils.isEmpty((CharSequence)(params = StringUtils.stripStart((String)params, (String)"?")))) {
            return;
        }
        for (String part : parts = StringUtils.split((String)params, (char)'&')) {
            this.params_.add(URLSearchParams.splitQueryParameter(part));
        }
    }

    private static Map.Entry<String, String> splitQueryParameter(String singleParam) {
        int idx = singleParam.indexOf(61);
        if (idx > -1) {
            String key = singleParam.substring(0, idx);
            String value = null;
            if (idx < singleParam.length()) {
                value = singleParam.substring(idx + 1);
            }
            return new AbstractMap.SimpleEntry<String, Object>(key, value);
        }
        String key = singleParam;
        Object value = null;
        return new AbstractMap.SimpleEntry<String, Object>(key, value);
    }

    @JsxFunction
    public void append(String name, String value) {
        this.params_.add(new AbstractMap.SimpleEntry<String, String>(name, value));
    }

    @JsxFunction
    public void delete(String name) {
        Iterator<Map.Entry<String, String>> iter = this.params_.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!entry.getKey().equals(name)) continue;
            iter.remove();
        }
    }

    @JsxFunction
    public String get(String name) {
        for (Map.Entry<String, String> param : this.params_) {
            if (!param.getKey().equals(name)) continue;
            return param.getValue();
        }
        return null;
    }

    @JsxFunction
    public Scriptable getAll(String name) {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, String> param : this.params_) {
            if (!param.getKey().equals(name)) continue;
            result.add(param.getValue());
        }
        return Context.getCurrentContext().newArray((Scriptable)URLSearchParams.getWindow((Scriptable)this), result.toArray());
    }

    @JsxFunction
    public void set(String name, String value) {
        Iterator<Map.Entry<String, String>> iter = this.params_.iterator();
        boolean change = true;
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!entry.getKey().equals(name)) continue;
            if (change) {
                entry.setValue(value);
                change = false;
                continue;
            }
            iter.remove();
        }
        if (change) {
            this.append(name, value);
        }
    }

    @JsxFunction
    public boolean has(String name) {
        for (Map.Entry<String, String> param : this.params_) {
            if (!param.getKey().equals(name)) continue;
            return true;
        }
        return false;
    }

    @JsxFunction
    public Object entries() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_URL_SEARCH_PARMS_ITERATOR_SIMPLE_NAME)) {
            return new NativeParamsIterator(this.getParentScope(), "Iterator", NativeParamsIterator.Type.BOTH, this.params_.iterator());
        }
        return new NativeParamsIterator(this.getParentScope(), "URLSearchParams Iterator", NativeParamsIterator.Type.BOTH, this.params_.iterator());
    }

    @JsxFunction
    public Object keys() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_URL_SEARCH_PARMS_ITERATOR_SIMPLE_NAME)) {
            return new NativeParamsIterator(this.getParentScope(), "Iterator", NativeParamsIterator.Type.KEYS, this.params_.iterator());
        }
        return new NativeParamsIterator(this.getParentScope(), "URLSearchParams Iterator", NativeParamsIterator.Type.KEYS, this.params_.iterator());
    }

    @JsxFunction
    public Object values() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_URL_SEARCH_PARMS_ITERATOR_SIMPLE_NAME)) {
            return new NativeParamsIterator(this.getParentScope(), "Iterator", NativeParamsIterator.Type.VALUES, this.params_.iterator());
        }
        return new NativeParamsIterator(this.getParentScope(), "URLSearchParams Iterator", NativeParamsIterator.Type.VALUES, this.params_.iterator());
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        StringBuilder paramStr = new StringBuilder();
        String delim = "";
        for (Map.Entry<String, String> param : this.params_) {
            paramStr.append(delim);
            delim = "&";
            paramStr.append(param.getKey());
            paramStr.append('=');
            String value = param.getValue();
            if (value == null) continue;
            paramStr.append(param.getValue());
        }
        return paramStr.toString();
    }

    public void fillRequest(WebRequest webRequest) {
        webRequest.setRequestBody(null);
        webRequest.setEncodingType(FormEncodingType.URL_ENCODED);
        if (this.params_.size() > 0) {
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            for (Map.Entry<String, String> entry : this.params_) {
                params.add(new NameValuePair(entry.getKey(), entry.getValue()));
            }
            webRequest.setRequestParameters(params);
        }
    }

    public static class NativeParamsIterator
    extends ES6Iterator {
        private Type type_;
        private String className_;
        private transient Iterator<Map.Entry<String, String>> iterator_ = Collections.emptyIterator();

        public static void init(ScriptableObject scope, String className) {
            ES6Iterator.init((ScriptableObject)scope, (boolean)false, (IdScriptableObject)new NativeParamsIterator(className), (String)URLSearchParams.URL_SEARCH_PARMS_TAG);
        }

        public NativeParamsIterator(String className) {
            this.iterator_ = Collections.emptyIterator();
            this.type_ = Type.BOTH;
            this.className_ = className;
        }

        public NativeParamsIterator(Scriptable scope, String className, Type type, Iterator<Map.Entry<String, String>> iterator) {
            super(scope, URLSearchParams.URL_SEARCH_PARMS_TAG);
            this.iterator_ = iterator;
            this.type_ = type;
            this.className_ = className;
        }

        public String getClassName() {
            return this.className_;
        }

        protected boolean isDone(Context cx, Scriptable scope) {
            return !this.iterator_.hasNext();
        }

        protected Object nextValue(Context cx, Scriptable scope) {
            Map.Entry<String, String> e = this.iterator_.next();
            switch (this.type_) {
                case KEYS: {
                    return e.getKey();
                }
                case VALUES: {
                    return e.getValue();
                }
                case BOTH: {
                    return cx.newArray(scope, new Object[]{e.getKey(), e.getValue()});
                }
            }
            throw new AssertionError();
        }

        static enum Type {
            KEYS,
            VALUES,
            BOTH;

        }
    }
}

