/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import java.util.LinkedList;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class Event
extends SimpleScriptable {
    protected static final String KEY_CURRENT_EVENT = "Event#current";
    public static final String TYPE_SUBMIT = "submit";
    public static final String TYPE_CHANGE = "change";
    public static final String TYPE_LOAD = "load";
    public static final String TYPE_UNLOAD = "unload";
    public static final String TYPE_POPSTATE = "popstate";
    public static final String TYPE_FOCUS = "focus";
    public static final String TYPE_FOCUS_IN = "focusin";
    public static final String TYPE_FOCUS_OUT = "focusout";
    public static final String TYPE_BLUR = "blur";
    public static final String TYPE_KEY_DOWN = "keydown";
    public static final String TYPE_KEY_PRESS = "keypress";
    public static final String TYPE_INPUT = "input";
    public static final String TYPE_KEY_UP = "keyup";
    public static final String TYPE_RESET = "reset";
    public static final String TYPE_BEFORE_UNLOAD = "beforeunload";
    public static final String TYPE_DOM_DOCUMENT_LOADED = "DOMContentLoaded";
    public static final String TYPE_PROPERTY_CHANGE = "propertychange";
    public static final String TYPE_HASH_CHANGE = "hashchange";
    public static final String TYPE_READY_STATE_CHANGE = "readystatechange";
    public static final String TYPE_ERROR = "error";
    public static final String TYPE_MESSAGE = "message";
    public static final String TYPE_CLOSE = "close";
    public static final String TYPE_OPEN = "open";
    @JsxConstant(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public static final short NONE = 0;
    @JsxConstant
    public static final short CAPTURING_PHASE = 1;
    @JsxConstant
    public static final short AT_TARGET = 2;
    @JsxConstant
    public static final short BUBBLING_PHASE = 3;
    @JsxConstant(value={SupportedBrowser.FF})
    public static final int ALT_MASK = 1;
    @JsxConstant(value={SupportedBrowser.FF})
    public static final int CONTROL_MASK = 2;
    @JsxConstant(value={SupportedBrowser.FF})
    public static final int SHIFT_MASK = 4;
    @JsxConstant(value={SupportedBrowser.FF})
    public static final int META_MASK = 8;
    private Object srcElement_;
    private EventTarget target_;
    private Scriptable currentTarget_;
    private String type_ = "";
    private int keyCode_;
    private boolean shiftKey_;
    private boolean ctrlKey_;
    private boolean altKey_;
    private String propertyName_;
    private boolean stopPropagation_;
    private boolean stopImmediatePropagation_;
    private boolean preventDefault_;
    private short eventPhase_;
    private boolean bubbles_ = true;
    private boolean cancelable_ = true;
    private final long timeStamp_ = System.currentTimeMillis();

    public Event(DomNode domNode, String type) {
        this((EventTarget)domNode.getScriptableObject(), type);
        this.setDomNode(domNode, false);
    }

    public Event(EventTarget target, String type) {
        this.srcElement_ = target;
        this.target_ = target;
        this.currentTarget_ = target;
        this.type_ = type;
        this.setParentScope((Scriptable)target);
        this.setPrototype(this.getPrototype(this.getClass()));
        if (TYPE_CHANGE.equals(type)) {
            this.cancelable_ = false;
        } else if (TYPE_LOAD.equals(type)) {
            this.bubbles_ = false;
            this.cancelable_ = false;
        } else if (TYPE_ERROR.equals(type)) {
            this.bubbles_ = false;
        }
    }

    public static Event createPropertyChangeEvent(DomNode domNode, String propertyName) {
        Event event = new Event(domNode, TYPE_PROPERTY_CHANGE);
        event.propertyName_ = propertyName;
        return event;
    }

    public Event() {
    }

    public void eventCreated() {
        this.setBubbles(false);
        this.setCancelable(false);
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public void jsConstructor(String type, ScriptableObject details) {
        boolean bubbles = false;
        boolean cancelable = false;
        if (details != null && !Undefined.isUndefined((Object)details)) {
            Boolean detailCancelable;
            Boolean detailBubbles = (Boolean)details.get((Object)"bubbles");
            if (detailBubbles != null) {
                bubbles = detailBubbles;
            }
            if ((detailCancelable = (Boolean)details.get((Object)"cancelable")) != null) {
                cancelable = detailCancelable;
            }
        }
        this.initEvent(type, bubbles, cancelable);
    }

    public void startFire() {
        Context context = Context.getCurrentContext();
        LinkedList<Event> events = (LinkedList<Event>)context.getThreadLocal((Object)KEY_CURRENT_EVENT);
        if (events == null) {
            events = new LinkedList<Event>();
            context.putThreadLocal((Object)KEY_CURRENT_EVENT, events);
        }
        events.add(this);
    }

    public void endFire() {
        ((LinkedList)Context.getCurrentContext().getThreadLocal((Object)KEY_CURRENT_EVENT)).removeLast();
    }

    @JsxGetter(value={SupportedBrowser.IE, SupportedBrowser.CHROME})
    public Object getSrcElement() {
        return this.srcElement_;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setSrcElement(Object srcElement) {
        this.srcElement_ = srcElement;
    }

    @JsxGetter
    public Object getTarget() {
        return this.target_;
    }

    public void setTarget(EventTarget target) {
        this.target_ = target;
    }

    @JsxGetter
    public Scriptable getCurrentTarget() {
        return this.currentTarget_;
    }

    public void setCurrentTarget(Scriptable target) {
        this.currentTarget_ = target;
    }

    @JsxGetter
    public String getType() {
        return this.type_;
    }

    @JsxSetter
    public void setType(String type) {
        this.type_ = type;
    }

    public void setEventType(String eventType) {
        this.type_ = eventType;
    }

    @JsxGetter
    public long getTimeStamp() {
        return this.timeStamp_;
    }

    protected void setKeyCode(int keyCode) {
        this.keyCode_ = keyCode;
    }

    public int getKeyCode() {
        return this.keyCode_;
    }

    public boolean isShiftKey() {
        return this.shiftKey_;
    }

    protected void setShiftKey(boolean shiftKey) {
        this.shiftKey_ = shiftKey;
    }

    public boolean isCtrlKey() {
        return this.ctrlKey_;
    }

    protected void setCtrlKey(boolean ctrlKey) {
        this.ctrlKey_ = ctrlKey;
    }

    public boolean isAltKey() {
        return this.altKey_;
    }

    protected void setAltKey(boolean altKey) {
        this.altKey_ = altKey;
    }

    @JsxGetter
    public int getEventPhase() {
        return this.eventPhase_;
    }

    public void setEventPhase(short phase) {
        if (phase != 1 && phase != 2 && phase != 3) {
            throw new IllegalArgumentException("Illegal phase specified: " + phase);
        }
        this.eventPhase_ = phase;
    }

    @JsxGetter
    public boolean isBubbles() {
        return this.bubbles_;
    }

    protected void setBubbles(boolean bubbles) {
        this.bubbles_ = bubbles;
    }

    @JsxGetter
    public boolean isCancelable() {
        return this.cancelable_;
    }

    protected void setCancelable(boolean cancelable) {
        this.cancelable_ = cancelable;
    }

    @JsxGetter
    public boolean isDefaultPrevented() {
        return this.cancelable_ && this.preventDefault_;
    }

    @JsxGetter
    public boolean isCancelBubble() {
        return this.stopPropagation_;
    }

    @JsxSetter
    public void setCancelBubble(boolean newValue) {
        this.stopPropagation_ = newValue;
    }

    @JsxFunction
    public void stopPropagation() {
        this.stopPropagation_ = true;
    }

    public boolean isPropagationStopped() {
        return this.stopPropagation_;
    }

    @JsxFunction
    public void stopImmediatePropagation() {
        this.stopImmediatePropagation_ = true;
        this.stopPropagation();
    }

    public boolean isImmediatePropagationStopped() {
        return this.stopImmediatePropagation_;
    }

    void handlePropertyHandlerReturnValue(Object returnValue) {
        if (Boolean.FALSE.equals(returnValue)) {
            this.preventDefault();
        }
    }

    public String getPropertyName() {
        return this.propertyName_;
    }

    @JsxFunction
    public void initEvent(String type, boolean bubbles, boolean cancelable) {
        this.type_ = type;
        this.bubbles_ = bubbles;
        this.cancelable_ = cancelable;
    }

    @JsxFunction
    public void preventDefault() {
        if (this.isCancelable()) {
            this.preventDefault_ = true;
        }
    }

    public boolean isAborted(ScriptResult result) {
        return ScriptResult.isFalse(result) || this.preventDefault_;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(40);
        builder.append("Event ").append(this.getType()).append(" (").append("Current Target: ").append(this.currentTarget_).append(");");
        return builder.toString();
    }

    public boolean processLabelAfterBubbling() {
        return false;
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Object getReturnValue() {
        return !this.preventDefault_;
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setReturnValue(Object newValue) {
        if (this.isCancelable()) {
            boolean bool;
            boolean bl = bool = !ScriptRuntime.toBoolean((Object)newValue);
            if (bool) {
                this.preventDefault_ = bool;
            }
        }
    }
}

