/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSFontFaceRuleImpl;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class CSSFontFaceRule
extends CSSRule {
    private static final Pattern REPLACEMENT_1 = Pattern.compile("font-family: ([^;]*);");
    private static final Pattern REPLACEMENT_2 = Pattern.compile("src: url\\(([^;]*)\\);");

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF60})
    public CSSFontFaceRule() {
    }

    protected CSSFontFaceRule(CSSStyleSheet stylesheet, CSSFontFaceRuleImpl rule) {
        super(stylesheet, (AbstractCSSRuleImpl)rule);
    }

    @Override
    public short getType() {
        return 5;
    }

    @Override
    public String getCssText() {
        String cssText = super.getCssText();
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.CSS_FONTFACERULE_CSSTEXT_CRLF)) {
            cssText = StringUtils.replace((String)cssText, (String)"{", (String)"{\r\n\t");
            cssText = StringUtils.replace((String)cssText, (String)"}", (String)";\r\n}\r\n");
            cssText = StringUtils.replace((String)cssText, (String)"; ", (String)";\r\n\t");
        } else if (browserVersion.hasFeature(BrowserVersionFeatures.CSS_FONTFACERULE_CSSTEXT_NO_CRLF)) {
            cssText = StringUtils.replace((String)cssText, (String)"{", (String)"{ ");
            cssText = StringUtils.replace((String)cssText, (String)"}", (String)"; }");
            cssText = StringUtils.replace((String)cssText, (String)"; ", (String)"; ");
            cssText = REPLACEMENT_1.matcher(cssText).replaceFirst("font-family: $1;");
            cssText = REPLACEMENT_2.matcher(cssText).replaceFirst("src: url(\"$1\");");
        } else {
            cssText = StringUtils.replace((String)cssText, (String)"{", (String)"{\n  ");
            cssText = StringUtils.replace((String)cssText, (String)"}", (String)";\n}");
            cssText = StringUtils.replace((String)cssText, (String)"; ", (String)";\n  ");
            cssText = REPLACEMENT_1.matcher(cssText).replaceFirst("font-family: \"$1\";");
            cssText = REPLACEMENT_2.matcher(cssText).replaceFirst("src: url(\"$1\");");
        }
        return cssText;
    }
}

