/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering;

import com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering.RenderingBackend;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AwtRenderingBackend
implements RenderingBackend {
    private static final Log LOG = LogFactory.getLog(AwtRenderingBackend.class);
    private final BufferedImage image_;
    private final Graphics2D graphics2D_;
    private AffineTransform transformation_;
    private int lineWidth_;
    private Color fillColor_;
    private Color strokeColor_;
    private List<Path2D> subPaths_;
    private Deque<SaveState> savedStates_;

    public AwtRenderingBackend(int imageWidth, int imageHeight) {
        this.image_ = new BufferedImage(imageWidth, imageHeight, 2);
        this.graphics2D_ = this.image_.createGraphics();
        this.graphics2D_.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics2D_.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.graphics2D_.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.reset();
        this.graphics2D_.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        this.graphics2D_.setColor(Color.black);
        this.graphics2D_.clearRect(0, 0, imageWidth, imageHeight);
        this.subPaths_ = new ArrayList<Path2D>();
        this.savedStates_ = new ArrayDeque<SaveState>();
    }

    private void reset() {
        this.fillColor_ = Color.black;
        this.strokeColor_ = Color.black;
        this.lineWidth_ = 1;
        this.transformation_ = new AffineTransform();
    }

    @Override
    public void beginPath() {
        this.subPaths_.clear();
    }

    @Override
    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        Path2D subPath = this.getCurrentSubPath();
        if (subPath != null) {
            Point2D cp1 = this.transformation_.transform(new Point2D.Double(cp1x, cp1y), null);
            Point2D cp2 = this.transformation_.transform(new Point2D.Double(cp2x, cp2y), null);
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            subPath.curveTo(cp1.getX(), cp1.getY(), cp2.getX(), cp2.getY(), p.getX(), p.getY());
        }
    }

    @Override
    public void arc(double x, double y, double radius, double startAngle, double endAngle, boolean anticlockwise) {
        Path2D subPath = this.getCurrentSubPath();
        if (subPath != null) {
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            double startAngleDegree = startAngle * 180.0 / Math.PI;
            double endAngleDegree = endAngle * 180.0 / Math.PI;
            double extendAngle = startAngleDegree - endAngleDegree;
            extendAngle = Math.min(360.0, Math.abs(extendAngle));
            if (anticlockwise && extendAngle < 360.0) {
                extendAngle -= 360.0;
            }
            Arc2D.Double arc = new Arc2D.Double(p.getX() - radius, p.getY() - radius, radius * 2.0, radius * 2.0, startAngleDegree, extendAngle * -1.0, 0);
            subPath.append(arc, false);
        }
    }

    @Override
    public void clearRect(int x, int y, int w, int h) {
        this.graphics2D_.setTransform(this.transformation_);
        this.graphics2D_.setColor(this.fillColor_);
        this.graphics2D_.clearRect(x, y, w, h);
    }

    @Override
    public void drawImage(ImageReader imageReader, int dxI, int dyI) throws IOException {
        if (imageReader.getNumImages(true) != 0) {
            BufferedImage img = imageReader.read(0);
            this.graphics2D_.setTransform(this.transformation_);
            this.graphics2D_.setColor(this.fillColor_);
            this.graphics2D_.drawImage(img, dxI, dyI, this.image_.getWidth(), this.image_.getHeight(), null);
        }
    }

    @Override
    public String encodeToString(String type) throws IOException {
        String imageType = type;
        if (imageType != null && imageType.startsWith("image/")) {
            imageType = imageType.substring(6);
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)this.image_, imageType, bos);
            byte[] imageBytes = bos.toByteArray();
            String string = new String(new Base64().encode(imageBytes), StandardCharsets.US_ASCII);
            return string;
        }
    }

    @Override
    public void fill() {
        this.graphics2D_.setTransform(new AffineTransform());
        this.graphics2D_.setStroke(new BasicStroke(this.getLineWidth()));
        this.graphics2D_.setColor(this.fillColor_);
        for (Path2D path2d : this.subPaths_) {
            this.graphics2D_.fill(path2d);
        }
    }

    @Override
    public void fillRect(int x, int y, int w, int h) {
        this.graphics2D_.setTransform(this.transformation_);
        this.graphics2D_.setColor(this.fillColor_);
        this.graphics2D_.fillRect(x, y, w, h);
    }

    @Override
    public void fillText(String text, int x, int y) {
        this.graphics2D_.setTransform(new AffineTransform());
        FontMetrics metrics = this.graphics2D_.getFontMetrics();
        int width = metrics.stringWidth(text);
        int ascent = metrics.getAscent();
        float posX = x - width / 2;
        float posY = y + ascent / 2;
        this.graphics2D_.setTransform(this.transformation_);
        this.graphics2D_.setColor(this.fillColor_);
        this.graphics2D_.drawString(text, posX, posY);
    }

    @Override
    public byte[] getBytes(int width, int height, int sx, int sy) {
        byte[] array = new byte[width * height * 4];
        int index = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int color = this.image_.getRGB(sx + x, sy + y);
                array[index++] = (byte)((color & 0xFF0000) >> 16);
                array[index++] = (byte)((color & 0xFF00) >> 8);
                array[index++] = (byte)(color & 0xFF);
                array[index++] = (byte)((color & 0xFF000000) >>> 24);
            }
        }
        return array;
    }

    @Override
    public void lineTo(double x, double y) {
        Path2D subPath = this.getCurrentSubPath();
        if (subPath != null) {
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            subPath.lineTo(p.getX(), p.getY());
        }
    }

    @Override
    public void moveTo(double x, double y) {
        Path2D.Double subPath = new Path2D.Double();
        Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
        ((Path2D)subPath).moveTo(p.getX(), p.getY());
        this.subPaths_.add(subPath);
    }

    @Override
    public void quadraticCurveTo(double cpx, double cpy, double x, double y) {
        Path2D subPath = this.getCurrentSubPath();
        if (subPath != null) {
            Point2D cp = this.transformation_.transform(new Point2D.Double(cpx, cpy), null);
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            subPath.quadTo(cp.getX(), cp.getY(), p.getX(), p.getY());
        }
    }

    @Override
    public void rect(double x, double y, double w, double h) {
        Path2D subPath = this.getCurrentSubPath();
        if (subPath != null) {
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            Rectangle2D.Double rect = new Rectangle2D.Double(p.getX(), p.getY(), w, h);
            subPath.append(rect, false);
        }
    }

    @Override
    public void setFillStyle(String fillStyle) {
        String tmpFillStyle = fillStyle.replaceAll("\\s", "");
        Color color = null;
        if (tmpFillStyle.startsWith("rgb(")) {
            String[] colors = tmpFillStyle.substring(4, tmpFillStyle.length() - 1).split(",");
            color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
        } else if (tmpFillStyle.startsWith("rgba(")) {
            String[] colors = tmpFillStyle.substring(5, tmpFillStyle.length() - 1).split(",");
            color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]), (int)(Float.parseFloat(colors[3]) * 255.0f));
        } else if (tmpFillStyle.length() > 0 && tmpFillStyle.charAt(0) == '#') {
            color = Color.decode(tmpFillStyle);
        } else {
            try {
                Field f = Color.class.getField(tmpFillStyle);
                color = (Color)f.get(null);
            }
            catch (Exception e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Can not find color '" + tmpFillStyle + '\''));
                }
                color = Color.black;
            }
        }
        this.fillColor_ = color;
    }

    @Override
    public void setStrokeStyle(String strokeStyle) {
        String tmpFillStyle = strokeStyle.replaceAll("\\s", "");
        Color color = null;
        if (tmpFillStyle.startsWith("rgb(")) {
            String[] colors = tmpFillStyle.substring(4, tmpFillStyle.length() - 1).split(",");
            color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
        } else if (tmpFillStyle.startsWith("rgba(")) {
            String[] colors = tmpFillStyle.substring(5, tmpFillStyle.length() - 1).split(",");
            color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]), (int)(Float.parseFloat(colors[3]) * 255.0f));
        } else if (tmpFillStyle.length() > 0 && tmpFillStyle.charAt(0) == '#') {
            color = Color.decode(tmpFillStyle);
        } else {
            try {
                Field f = Color.class.getField(tmpFillStyle);
                color = (Color)f.get(null);
            }
            catch (Exception e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Can not find color '" + tmpFillStyle + '\''));
                }
                color = Color.black;
            }
        }
        this.strokeColor_ = color;
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth_;
    }

    @Override
    public void restore() {
        if (this.savedStates_.isEmpty()) {
            return;
        }
        this.savedStates_.pop().applyOn(this);
    }

    @Override
    public void rotate(double angle) {
        this.transformation_.rotate(angle);
    }

    @Override
    public void save() {
        this.savedStates_.push(new SaveState(this));
        this.reset();
    }

    @Override
    public void setLineWidth(int lineWidth) {
        this.lineWidth_ = lineWidth;
    }

    @Override
    public void setTransform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.transformation_ = new AffineTransform(m11, m12, m21, m22, dx, dy);
    }

    @Override
    public void stroke() {
        this.graphics2D_.setTransform(new AffineTransform());
        this.graphics2D_.setStroke(new BasicStroke(this.getLineWidth()));
        this.graphics2D_.setColor(this.strokeColor_);
        for (Path2D path2d : this.subPaths_) {
            this.graphics2D_.draw(path2d);
        }
    }

    @Override
    public void strokeRect(int x, int y, int w, int h) {
        this.graphics2D_.setTransform(this.transformation_);
        this.graphics2D_.setColor(this.strokeColor_);
        this.graphics2D_.drawRect(x, y, w, h);
    }

    @Override
    public void transform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.transformation_.concatenate(new AffineTransform(m11, m12, m21, m22, dx, dy));
    }

    @Override
    public void translate(int x, int y) {
        this.transformation_.translate(x, y);
    }

    private Path2D getCurrentSubPath() {
        if (this.subPaths_.isEmpty()) {
            Path2D.Double subPath = new Path2D.Double();
            this.subPaths_.add(subPath);
            return subPath;
        }
        return this.subPaths_.get(this.subPaths_.size() - 1);
    }

    private static final class SaveState {
        private AffineTransform transformation_;
        private int lineWidth_;
        private Color fillColor_;
        private Color strokeColor_;

        private SaveState(AwtRenderingBackend backend) {
            this.transformation_ = backend.transformation_;
            this.lineWidth_ = backend.lineWidth_;
            this.fillColor_ = backend.fillColor_;
            this.strokeColor_ = backend.strokeColor_;
        }

        private void applyOn(AwtRenderingBackend backend) {
            backend.transformation_ = this.transformation_;
            backend.lineWidth_ = this.lineWidth_;
            backend.fillColor_ = this.fillColor_;
            backend.strokeColor_ = this.strokeColor_;
        }
    }
}

