/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.WebSocketCookieStore;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.event.CloseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.event.MessageEvent;
import java.io.IOException;
import java.net.CookieStore;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.client.WebSocketClient;

@JsxClass
public class WebSocket
extends EventTarget
implements AutoCloseable {
    private static final Log LOG = LogFactory.getLog(WebSocket.class);
    @JsxConstant
    public static final int CONNECTING = 0;
    @JsxConstant
    public static final int OPEN = 1;
    @JsxConstant
    public static final int CLOSING = 2;
    @JsxConstant
    public static final int CLOSED = 3;
    private Function closeHandler_;
    private Function errorHandler_;
    private Function messageHandler_;
    private Function openHandler_;
    private URI url_;
    private int readyState_ = 0;
    private String binaryType_ = "blob";
    private HtmlPage containingPage_;
    private WebSocketClient client_;
    private volatile Session incomingSession_;
    private Session outgoingSession_;
    private WebSocketListener listener_;
    private boolean srcElementSet_;
    private boolean originSet_;

    public WebSocket() {
    }

    public void setWebSocketListener(WebSocketListener listener) {
        this.listener_ = listener;
    }

    public WebSocketListener getWebSocketListener() {
        return this.listener_;
    }

    private WebSocket(final String url, Window window) {
        try {
            WebWindow webWindow = window.getWebWindow();
            this.containingPage_ = (HtmlPage)webWindow.getEnclosedPage();
            this.setParentScope((Scriptable)window);
            this.setDomNode(this.containingPage_.getDocumentElement(), false);
            WebClient webClient = webWindow.getWebClient();
            this.srcElementSet_ = webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.WEBSOCKET_SRC_ELEMENT_SET);
            this.originSet_ = webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.WEBSOCKET_ORIGIN_SET);
            WebClientOptions options = webClient.getOptions();
            this.client_ = options.isUseInsecureSSL() ? new WebSocketClient(new SslContextFactory(true), null, null) : new WebSocketClient();
            this.client_.getHttpClient().setCookieStore((CookieStore)new WebSocketCookieStore(webClient));
            WebSocketPolicy policy = this.client_.getPolicy();
            int size = options.getWebSocketMaxBinaryMessageSize();
            if (size > 0) {
                policy.setMaxBinaryMessageSize(size);
            }
            if ((size = options.getWebSocketMaxBinaryMessageBufferSize()) > 0) {
                policy.setMaxBinaryMessageBufferSize(size);
            }
            if ((size = options.getWebSocketMaxTextMessageSize()) > 0) {
                policy.setMaxTextMessageSize(size);
            }
            if ((size = options.getWebSocketMaxTextMessageBufferSize()) > 0) {
                policy.setMaxTextMessageBufferSize(size);
            }
            this.client_.start();
            this.containingPage_.addAutoCloseable(this);
            this.url_ = new URI(url);
            webClient.getInternals().created(this);
            final Future connectFuture = this.client_.connect((Object)new WebSocketImpl(), this.url_);
            this.client_.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            WebSocket.this.setReadyState(0);
                            WebSocket.this.incomingSession_ = (Session)connectFuture.get();
                        }
                        catch (Exception e) {
                            if (!LOG.isErrorEnabled()) break block2;
                            LOG.error((Object)("WS connect error for url '" + url + "':"), (Throwable)e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("WebSocket Error: 'url' parameter '" + url + "' is invalid."), (Throwable)e);
            }
            throw Context.reportRuntimeError((String)("WebSocket Error: 'url' parameter '" + url + "' is invalid."));
        }
    }

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (args.length < 1 || args.length > 2) {
            throw Context.reportRuntimeError((String)"WebSocket Error: constructor must have one or two String parameters.");
        }
        if (Undefined.isUndefined((Object)args[0])) {
            throw Context.reportRuntimeError((String)"WebSocket Error: 'url' parameter is undefined.");
        }
        if (!(args[0] instanceof String)) {
            throw Context.reportRuntimeError((String)"WebSocket Error: 'url' parameter must be a String.");
        }
        String url = (String)args[0];
        if (StringUtils.isBlank((CharSequence)url)) {
            throw Context.reportRuntimeError((String)"WebSocket Error: 'url' parameter must be not empty.");
        }
        return new WebSocket(url, WebSocket.getWindow((Scriptable)ctorObj));
    }

    @JsxGetter
    public Function getOnclose() {
        return this.closeHandler_;
    }

    @JsxSetter
    public void setOnclose(Function closeHandler) {
        this.closeHandler_ = closeHandler;
    }

    @JsxGetter
    public Function getOnerror() {
        return this.errorHandler_;
    }

    @JsxSetter
    public void setOnerror(Function errorHandler) {
        this.errorHandler_ = errorHandler;
    }

    @JsxGetter
    public Function getOnmessage() {
        return this.messageHandler_;
    }

    @JsxSetter
    public void setOnmessage(Function messageHandler) {
        this.messageHandler_ = messageHandler;
    }

    @JsxGetter
    public Function getOnopen() {
        return this.openHandler_;
    }

    @JsxSetter
    public void setOnopen(Function openHandler) {
        this.openHandler_ = openHandler;
    }

    @JsxGetter
    public int getReadyState() {
        return this.readyState_;
    }

    private void setReadyState(int readyState) {
        this.readyState_ = readyState;
    }

    @JsxGetter
    public String getUrl() {
        if (this.url_ == null) {
            throw ScriptRuntime.typeError((String)"invalid call");
        }
        return this.url_.toString();
    }

    @JsxGetter
    public String getProtocol() {
        return "";
    }

    @JsxGetter
    public long getBufferedAmount() {
        return 0L;
    }

    @JsxGetter
    public String getBinaryType() {
        return this.binaryType_;
    }

    @JsxSetter
    public void setBinaryType(String type) {
        if ("arraybuffer".equals(type) || "blob".equals(type)) {
            this.binaryType_ = type;
        }
    }

    @Override
    public void close() throws IOException {
        this.close(null, null);
    }

    @JsxFunction
    public void close(Object code, Object reason) {
        block7: {
            if (this.readyState_ != 3) {
                if (this.incomingSession_ != null) {
                    this.incomingSession_.close();
                }
                if (this.outgoingSession_ != null) {
                    this.outgoingSession_.close();
                }
            }
            try {
                if (this.client_ == null) break block7;
                try {
                    this.client_.stop();
                }
                catch (UpgradeException e) {
                    LOG.error((Object)"WS stop error (connection was not established so far)", (Throwable)e);
                }
                this.client_ = null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @JsxFunction
    public void send(Object content) {
        block4: {
            try {
                if (content instanceof String) {
                    this.outgoingSession_.getRemote().sendString((String)content);
                    break block4;
                }
                if (content instanceof NativeArrayBuffer) {
                    byte[] bytes = ((NativeArrayBuffer)content).getBuffer();
                    ByteBuffer buffer = ByteBuffer.wrap(bytes);
                    this.outgoingSession_.getRemote().sendBytes(buffer);
                    break block4;
                }
                throw new IllegalStateException("Not Yet Implemented: WebSocket.send() was used to send non-string value");
            }
            catch (IOException e) {
                LOG.error((Object)"WS send error", (Throwable)e);
            }
        }
    }

    private class WebSocketImpl
    extends WebSocketAdapter {
        private WebSocketImpl() {
        }

        public void onWebSocketConnect(Session session) {
            if (WebSocket.this.listener_ != null) {
                WebSocket.this.listener_.onWebSocketConnect(session);
            }
            super.onWebSocketConnect(session);
            WebSocket.this.setReadyState(1);
            WebSocket.this.outgoingSession_ = session;
            Event openEvent = new Event();
            openEvent.setType("open");
            if (WebSocket.this.srcElementSet_) {
                openEvent.setSrcElement(WebSocket.this);
            }
            this.fire(openEvent);
            this.callFunction(WebSocket.this.openHandler_, new Object[]{openEvent});
        }

        public void onWebSocketClose(int statusCode, String reason) {
            if (WebSocket.this.listener_ != null) {
                WebSocket.this.listener_.onWebSocketClose(statusCode, reason);
            }
            super.onWebSocketClose(statusCode, reason);
            WebSocket.this.setReadyState(3);
            WebSocket.this.outgoingSession_ = null;
            CloseEvent closeEvent = new CloseEvent();
            closeEvent.setCode(statusCode);
            closeEvent.setReason(reason);
            closeEvent.setWasClean(true);
            this.fire(closeEvent);
            this.callFunction(WebSocket.this.closeHandler_, new Object[]{closeEvent});
        }

        public void onWebSocketText(String message) {
            if (WebSocket.this.listener_ != null) {
                WebSocket.this.listener_.onWebSocketText(message);
            }
            super.onWebSocketText(message);
            MessageEvent msgEvent = new MessageEvent(message);
            if (WebSocket.this.originSet_) {
                msgEvent.setOrigin(WebSocket.this.getUrl());
            }
            if (WebSocket.this.srcElementSet_) {
                msgEvent.setSrcElement(WebSocket.this);
            }
            this.fire(msgEvent);
            this.callFunction(WebSocket.this.messageHandler_, new Object[]{msgEvent});
        }

        public void onWebSocketBinary(byte[] data, int offset, int length) {
            if (WebSocket.this.listener_ != null) {
                WebSocket.this.listener_.onWebSocketBinary(data, offset, length);
            }
            super.onWebSocketBinary(data, offset, length);
            NativeArrayBuffer buffer = new NativeArrayBuffer((double)length);
            System.arraycopy(data, offset, buffer.getBuffer(), 0, length);
            buffer.setParentScope(WebSocket.this.getParentScope());
            buffer.setPrototype(ScriptableObject.getClassPrototype((Scriptable)WebSocket.this.getWindow(), (String)buffer.getClassName()));
            MessageEvent msgEvent = new MessageEvent(buffer);
            if (WebSocket.this.originSet_) {
                msgEvent.setOrigin(WebSocket.this.getUrl());
            }
            if (WebSocket.this.srcElementSet_) {
                msgEvent.setSrcElement(WebSocket.this);
            }
            this.fire(msgEvent);
            this.callFunction(WebSocket.this.messageHandler_, new Object[]{msgEvent});
        }

        public void onWebSocketError(Throwable cause) {
            if (WebSocket.this.listener_ != null) {
                WebSocket.this.listener_.onWebSocketError(cause);
            }
            super.onWebSocketError(cause);
            WebSocket.this.setReadyState(3);
            WebSocket.this.outgoingSession_ = null;
            Event errorEvent = new Event();
            errorEvent.setType("error");
            if (WebSocket.this.srcElementSet_) {
                errorEvent.setSrcElement(WebSocket.this);
            }
            this.fire(errorEvent);
            this.callFunction(WebSocket.this.errorHandler_, new Object[]{errorEvent});
            CloseEvent closeEvent = new CloseEvent();
            closeEvent.setCode(1006);
            closeEvent.setReason(cause.getMessage());
            closeEvent.setWasClean(false);
            this.fire(closeEvent);
            this.callFunction(WebSocket.this.closeHandler_, new Object[]{closeEvent});
        }

        private void fire(Event evt) {
            evt.setTarget(WebSocket.this);
            evt.setParentScope(WebSocket.this.getParentScope());
            evt.setPrototype(WebSocket.this.getPrototype(evt.getClass()));
            JavaScriptEngine engine = (JavaScriptEngine)WebSocket.this.containingPage_.getWebClient().getJavaScriptEngine();
            engine.getContextFactory().call(cx -> {
                WebSocket.this.executeEventLocally(evt);
                return null;
            });
        }

        private void callFunction(Function function, Object[] args) {
            if (function == null) {
                return;
            }
            Scriptable scope = function.getParentScope();
            JavaScriptEngine engine = (JavaScriptEngine)WebSocket.this.containingPage_.getWebClient().getJavaScriptEngine();
            engine.callFunction(WebSocket.this.containingPage_, function, scope, (Scriptable)WebSocket.this, args);
        }
    }
}

