/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlBreak;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlListItem;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlOrderedList;
import com.gargoylesoftware.htmlunit.html.HtmlPreformattedText;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableFooter;
import com.gargoylesoftware.htmlunit.html.HtmlTableHeader;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.HtmlUnorderedList;
import com.gargoylesoftware.htmlunit.html.TableRowGroup;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class HtmlSerializer {
    protected static final String AS_TEXT_BLOCK_SEPARATOR = "\u00a7bs\u00a7";
    private static final int AS_TEXT_BLOCK_SEPARATOR_LENGTH = "\u00a7bs\u00a7".length();
    protected static final String AS_TEXT_NEW_LINE = "\u00a7nl\u00a7";
    private static final int AS_TEXT_NEW_LINE_LENGTH = "\u00a7nl\u00a7".length();
    protected static final String AS_TEXT_BLANK = "\u00a7blank\u00a7";
    protected static final String AS_TEXT_TAB = "\u00a7tab\u00a7";
    private static final Pattern TEXT_AREA_PATTERN = Pattern.compile("\r?\n");
    private boolean ignoreMaskedElements_ = true;

    public String asText(DomNode node) {
        StringBuilder builder = new StringBuilder();
        this.appendNode(builder, node);
        String response = builder.toString();
        return this.cleanUp(response);
    }

    protected String cleanUp(String text) {
        String resultText = HtmlSerializer.reduceWhitespace(text);
        String ls = System.lineSeparator();
        resultText = StringUtils.replaceEach((String)resultText, (String[])new String[]{AS_TEXT_BLANK, AS_TEXT_NEW_LINE, AS_TEXT_BLOCK_SEPARATOR, AS_TEXT_TAB}, (String[])new String[]{" ", ls, ls, "\t"});
        return resultText;
    }

    private static String reduceWhitespace(String text) {
        int end;
        String resultText = HtmlSerializer.trim(text);
        resultText = HtmlSerializer.reduceWhiteSpaceAroundBlockSeparator(resultText);
        int start = 0;
        while (resultText.startsWith(AS_TEXT_BLOCK_SEPARATOR, start)) {
            start += AS_TEXT_BLOCK_SEPARATOR_LENGTH;
        }
        for (end = resultText.length() - AS_TEXT_BLOCK_SEPARATOR_LENGTH; end > start && resultText.startsWith(AS_TEXT_BLOCK_SEPARATOR, end); end -= AS_TEXT_BLOCK_SEPARATOR_LENGTH) {
        }
        resultText = resultText.substring(start, end + AS_TEXT_BLOCK_SEPARATOR_LENGTH);
        resultText = HtmlSerializer.trim(resultText);
        StringBuilder builder = new StringBuilder(resultText.length());
        boolean whitespace = false;
        for (char ch : resultText.toCharArray()) {
            if (ch == '\u00a0') {
                builder.append(' ');
                whitespace = false;
                continue;
            }
            if (whitespace) {
                if (HtmlSerializer.isSpace(ch)) continue;
                builder.append(ch);
                whitespace = false;
                continue;
            }
            if (HtmlSerializer.isSpace(ch)) {
                whitespace = true;
                builder.append(' ');
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    private static boolean isSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\f' || ch == '\r';
    }

    private static String trim(String string) {
        int end;
        int start;
        int length = string.length();
        if (length == 0) {
            return string;
        }
        for (start = 0; start != length && HtmlSerializer.isSpace(string.charAt(start)); ++start) {
        }
        if (start == length) {
            return "";
        }
        for (end = length; end > start && HtmlSerializer.isSpace(string.charAt(end - 1)); --end) {
        }
        if (end == length && start == 0) {
            return string;
        }
        return string.substring(start, end);
    }

    private static String reduceWhiteSpaceAroundBlockSeparator(String text) {
        int p0 = text.indexOf(AS_TEXT_BLOCK_SEPARATOR);
        if (p0 == -1) {
            return text;
        }
        int length = text.length();
        if (length <= AS_TEXT_BLOCK_SEPARATOR_LENGTH) {
            return text;
        }
        StringBuilder result = new StringBuilder(length);
        int start = 0;
        while (p0 != -1) {
            int p1 = p0 + AS_TEXT_BLOCK_SEPARATOR_LENGTH;
            while (p0 != start && HtmlSerializer.isSpace(text.charAt(p0 - 1))) {
                --p0;
            }
            if (p0 >= AS_TEXT_NEW_LINE_LENGTH && text.startsWith(AS_TEXT_NEW_LINE, p0 - AS_TEXT_NEW_LINE_LENGTH)) {
                p0 -= AS_TEXT_NEW_LINE_LENGTH;
            }
            result.append(text.substring(start, p0)).append(AS_TEXT_BLOCK_SEPARATOR);
            while (p1 < length && HtmlSerializer.isSpace(text.charAt(p1))) {
                ++p1;
            }
            start = p1;
            p0 = text.indexOf(AS_TEXT_BLOCK_SEPARATOR, start);
            while (p0 != -1 && p0 == start) {
                p0 = text.indexOf(AS_TEXT_BLOCK_SEPARATOR, start += AS_TEXT_BLOCK_SEPARATOR_LENGTH);
            }
        }
        if (start < length) {
            result.append(text.substring(start));
        }
        return result.toString();
    }

    protected void appendChildren(StringBuilder builder, DomNode node) {
        for (DomNode child : node.getChildren()) {
            this.appendNode(builder, child);
        }
    }

    protected void appendNode(StringBuilder builder, DomNode node) {
        if (node instanceof DomText) {
            this.appendText(builder, (DomText)node);
        } else if (node instanceof DomComment) {
            this.appendComment(builder, (DomComment)node);
        } else if (node instanceof HtmlApplet && node.getPage().getWebClient().getOptions().isAppletEnabled()) {
            this.appendApplet(builder, (HtmlApplet)node);
        } else if (node instanceof HtmlBreak) {
            this.appendBreak(builder, (HtmlBreak)node);
        } else if (node instanceof HtmlHiddenInput) {
            this.appendHiddenInput(builder, (HtmlHiddenInput)node);
        } else if (node instanceof HtmlScript) {
            this.appendScript(builder, (HtmlScript)node);
        } else if (node instanceof HtmlStyle) {
            this.appendStyle(builder, (HtmlStyle)node);
        } else if (node instanceof HtmlNoFrames) {
            this.appendNoFrames(builder, (HtmlNoFrames)node);
        } else if (node instanceof HtmlTextArea) {
            this.appendTextArea(builder, (HtmlTextArea)node);
        } else if (node instanceof HtmlTitle) {
            this.appendTitle(builder, (HtmlTitle)node);
        } else if (node instanceof HtmlTableRow) {
            this.appendTableRow(builder, (HtmlTableRow)node);
        } else if (node instanceof HtmlSelect) {
            this.appendSelect(builder, (HtmlSelect)node);
        } else if (node instanceof HtmlSubmitInput) {
            this.appendSubmitInput(builder, (HtmlSubmitInput)node);
        } else if (node instanceof HtmlResetInput) {
            this.appendResetInput(builder, (HtmlResetInput)node);
        } else if (node instanceof HtmlCheckBoxInput) {
            this.doAppendCheckBoxInput(builder, (HtmlCheckBoxInput)node);
        } else if (node instanceof HtmlRadioButtonInput) {
            this.doAppendRadioButtonInput(builder, (HtmlRadioButtonInput)node);
        } else if (node instanceof HtmlInput) {
            this.appendInput(builder, (HtmlInput)node);
        } else if (node instanceof HtmlTable) {
            this.appendTable(builder, (HtmlTable)node);
        } else if (node instanceof HtmlOrderedList) {
            this.appendOrderedList(builder, (HtmlOrderedList)node);
        } else if (node instanceof HtmlUnorderedList) {
            this.appendUnorderedList(builder, (HtmlUnorderedList)node);
        } else if (node instanceof HtmlPreformattedText) {
            this.appendPreformattedText(builder, (HtmlPreformattedText)node);
        } else if (node instanceof HtmlInlineFrame) {
            this.appendInlineFrame(builder, (HtmlInlineFrame)node);
        } else if (node instanceof HtmlNoScript && node.getPage().getWebClient().getOptions().isJavaScriptEnabled()) {
            this.appendNoScript(builder, (HtmlNoScript)node);
        } else {
            this.appendDomNode(builder, node);
        }
    }

    protected void appendDomNode(StringBuilder builder, DomNode domNode) {
        boolean block;
        Object scriptableObject = domNode.getScriptableObject();
        if (domNode instanceof HtmlBody) {
            block = false;
        } else if (scriptableObject instanceof Element) {
            Element element = (Element)scriptableObject;
            String display = element.getWindow().getComputedStyle(element, null).getDisplay(true);
            block = "block".equals(display);
        } else {
            block = false;
        }
        if (block) {
            builder.append(AS_TEXT_BLOCK_SEPARATOR);
        }
        this.appendChildren(builder, domNode);
        if (block) {
            builder.append(AS_TEXT_BLOCK_SEPARATOR);
        }
    }

    protected void appendHiddenInput(StringBuilder builder, HtmlHiddenInput htmlHiddenInput) {
    }

    protected void appendScript(StringBuilder builder, HtmlScript htmlScript) {
    }

    protected void appendStyle(StringBuilder builder, HtmlStyle htmlStyle) {
    }

    protected void appendNoScript(StringBuilder builder, HtmlNoScript htmlNoScript) {
    }

    protected void appendNoFrames(StringBuilder builder, HtmlNoFrames htmlNoFrames) {
    }

    protected void appendSubmitInput(StringBuilder builder, HtmlSubmitInput htmlSubmitInput) {
        builder.append(htmlSubmitInput.asText());
    }

    protected void appendInput(StringBuilder builder, HtmlInput htmlInput) {
        builder.append(htmlInput.getValueAttribute());
    }

    protected void appendResetInput(StringBuilder builder, HtmlResetInput htmlResetInput) {
        builder.append(htmlResetInput.asText());
    }

    protected void appendUnorderedList(StringBuilder builder, HtmlUnorderedList htmlUnorderedList) {
        builder.append(AS_TEXT_BLOCK_SEPARATOR);
        boolean first = true;
        for (DomNode item : htmlUnorderedList.getChildren()) {
            if (!first) {
                builder.append(AS_TEXT_BLOCK_SEPARATOR);
            }
            first = false;
            this.appendNode(builder, item);
        }
        builder.append(AS_TEXT_BLOCK_SEPARATOR);
    }

    protected void appendTitle(StringBuilder builder, HtmlTitle htmlTitle) {
        DomNode child = htmlTitle.getFirstChild();
        if (child instanceof DomText) {
            builder.append(((DomText)child).getData());
            builder.append(AS_TEXT_BLOCK_SEPARATOR);
        }
    }

    protected void appendTableRow(StringBuilder builder, HtmlTableRow htmlTableRow) {
        boolean first = true;
        for (HtmlTableCell cell : htmlTableRow.getCells()) {
            if (!first) {
                builder.append(AS_TEXT_TAB);
            } else {
                first = false;
            }
            this.appendChildren(builder, cell);
        }
    }

    protected void appendTextArea(StringBuilder builder, HtmlTextArea htmlTextArea) {
        if (this.isVisible(htmlTextArea)) {
            String text = htmlTextArea.getText();
            text = StringUtils.stripEnd((String)text, null);
            text = TEXT_AREA_PATTERN.matcher(text).replaceAll(AS_TEXT_NEW_LINE);
            text = StringUtils.replace((String)text, (String)"\r", (String)AS_TEXT_NEW_LINE);
            text = StringUtils.replace((String)text, (String)" ", (String)AS_TEXT_BLANK);
            builder.append(text);
        }
    }

    protected void appendTable(StringBuilder builder, HtmlTable htmlTable) {
        DomNode firstChild;
        builder.append(AS_TEXT_BLOCK_SEPARATOR);
        String caption = htmlTable.getCaptionText();
        if (caption != null) {
            builder.append(caption);
            builder.append(AS_TEXT_BLOCK_SEPARATOR);
        }
        boolean first = true;
        HtmlTableHeader tableHeader = htmlTable.getHeader();
        if (tableHeader != null) {
            first = this.appendTableRows(builder, tableHeader.getRows(), true, null, null);
        }
        HtmlTableFooter tableFooter = htmlTable.getFooter();
        List<HtmlTableRow> tableRows = htmlTable.getRows();
        first = this.appendTableRows(builder, tableRows, first, tableHeader, tableFooter);
        if (tableFooter != null) {
            first = this.appendTableRows(builder, tableFooter.getRows(), first, null, null);
        } else if (tableRows.isEmpty() && (firstChild = htmlTable.getFirstChild()) != null) {
            this.appendNode(builder, firstChild);
        }
        builder.append(AS_TEXT_BLOCK_SEPARATOR);
    }

    protected boolean appendTableRows(StringBuilder builder, List<HtmlTableRow> rows, boolean first, TableRowGroup skipParent1, TableRowGroup skipParent2) {
        for (HtmlTableRow row : rows) {
            if (row.getParentNode() == skipParent1 || row.getParentNode() == skipParent2) continue;
            if (!first) {
                builder.append(AS_TEXT_BLOCK_SEPARATOR);
            }
            first = false;
            this.appendTableRow(builder, row);
        }
        return first;
    }

    protected void appendSelect(StringBuilder builder, HtmlSelect htmlSelect) {
        List<HtmlOption> options = htmlSelect.isMultipleSelectEnabled() ? htmlSelect.getOptions() : htmlSelect.getSelectedOptions();
        Iterator<HtmlOption> i = options.iterator();
        while (i.hasNext()) {
            HtmlOption currentOption = i.next();
            this.appendNode(builder, currentOption);
            if (!i.hasNext()) continue;
            builder.append(AS_TEXT_BLOCK_SEPARATOR);
        }
    }

    protected void appendOrderedList(StringBuilder builder, HtmlOrderedList htmlOrderedList) {
        builder.append(AS_TEXT_BLOCK_SEPARATOR);
        boolean first = true;
        int i = 1;
        for (DomNode item : htmlOrderedList.getChildren()) {
            if (!first) {
                builder.append(AS_TEXT_BLOCK_SEPARATOR);
            }
            first = false;
            if (item instanceof HtmlListItem) {
                builder.append(Integer.toString(i++));
                builder.append(". ");
                this.appendChildren(builder, item);
                continue;
            }
            this.appendNode(builder, item);
        }
        builder.append(AS_TEXT_BLOCK_SEPARATOR);
    }

    protected void appendPreformattedText(StringBuilder builder, HtmlPreformattedText htmlPreformattedText) {
        if (this.isVisible(htmlPreformattedText)) {
            builder.append(AS_TEXT_BLOCK_SEPARATOR);
            String text = htmlPreformattedText.getTextContent();
            text = StringUtils.replace((String)text, (String)"\t", (String)AS_TEXT_TAB);
            text = StringUtils.replace((String)text, (String)" ", (String)AS_TEXT_BLANK);
            text = TEXT_AREA_PATTERN.matcher(text).replaceAll(AS_TEXT_NEW_LINE);
            text = StringUtils.replace((String)text, (String)"\r", (String)AS_TEXT_NEW_LINE);
            builder.append(text);
            builder.append(AS_TEXT_BLOCK_SEPARATOR);
        }
    }

    protected void appendInlineFrame(StringBuilder builder, HtmlInlineFrame htmlInlineFrame) {
        if (this.isVisible(htmlInlineFrame)) {
            builder.append(AS_TEXT_BLOCK_SEPARATOR);
            Page page = htmlInlineFrame.getEnclosedPage();
            if (page instanceof SgmlPage) {
                builder.append(((SgmlPage)page).asText());
            }
            builder.append(AS_TEXT_BLOCK_SEPARATOR);
        }
    }

    protected void appendText(StringBuilder builder, DomText domText) {
        DomNode parent = domText.getParentNode();
        if (parent == null || parent instanceof HtmlTitle || this.isVisible(parent)) {
            builder.append(domText.getData());
        }
    }

    protected void appendComment(StringBuilder builder, DomComment domComment) {
    }

    protected void appendApplet(StringBuilder builder, HtmlApplet htmlApplet) {
    }

    protected void appendBreak(StringBuilder builder, HtmlBreak htmlBreak) {
        builder.append(AS_TEXT_NEW_LINE);
    }

    protected void doAppendCheckBoxInput(StringBuilder builder, HtmlCheckBoxInput htmlCheckBoxInput) {
        if (htmlCheckBoxInput.isChecked()) {
            builder.append("checked");
        } else {
            builder.append("unchecked");
        }
    }

    protected void doAppendRadioButtonInput(StringBuilder builder, HtmlRadioButtonInput htmlRadioButtonInput) {
        if (htmlRadioButtonInput.isChecked()) {
            builder.append("checked");
        } else {
            builder.append("unchecked");
        }
    }

    private boolean isVisible(DomNode node) {
        return !this.ignoreMaskedElements_ || node.isDisplayed();
    }

    public void setIgnoreMaskedElements(boolean ignore) {
        this.ignoreMaskedElements_ = ignore;
    }
}

