/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.css.dom.CSSStyleSheetImpl;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.HeaderUtils;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.utils.DateUtils;

public class Cache
implements Serializable {
    private int maxSize_ = 40;
    private static final Pattern DATE_HEADER_PATTERN = Pattern.compile("-?\\d+");
    private static final long DELAY = 600000L;
    private final Map<String, Entry> entries_ = Collections.synchronizedMap(new HashMap(this.maxSize_));

    public boolean cacheIfPossible(WebRequest request, WebResponse response, Object toCache) {
        if (this.isCacheable(request, response)) {
            URL url = request.getUrl();
            if (url == null) {
                return false;
            }
            Entry entry = new Entry(UrlUtils.normalize(url), response, toCache);
            this.entries_.put(entry.key_, entry);
            this.deleteOverflow();
            return true;
        }
        return false;
    }

    public void cache(String css, CSSStyleSheetImpl styleSheet) {
        Entry entry = new Entry(css, null, styleSheet);
        this.entries_.put(entry.key_, entry);
        this.deleteOverflow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteOverflow() {
        Map<String, Entry> map = this.entries_;
        synchronized (map) {
            while (this.entries_.size() > this.maxSize_) {
                Entry oldestEntry = Collections.min(this.entries_.values());
                this.entries_.remove(oldestEntry.key_);
                if (oldestEntry.response_ == null) continue;
                oldestEntry.response_.cleanUp();
            }
        }
    }

    protected boolean isCacheable(WebRequest request, WebResponse response) {
        return HttpMethod.GET == response.getWebRequest().getHttpMethod() && this.isCacheableContent(response);
    }

    protected boolean isCacheableContent(WebResponse response) {
        if (HeaderUtils.containsNoStore(response)) {
            return false;
        }
        Date lastModified = Cache.parseDateHeader(response, "Last-Modified");
        Date expires = null;
        if (!HeaderUtils.containsMaxAgeOrSMaxage(response)) {
            expires = Cache.parseDateHeader(response, "Expires");
        }
        long now = this.getCurrentTimestamp();
        return expires != null && expires.getTime() - now > 600000L || expires == null && lastModified != null && now - lastModified.getTime() > 600000L;
    }

    protected long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    protected static Date parseDateHeader(WebResponse response, String headerName) {
        String value = response.getResponseHeaderValue(headerName);
        if (value == null) {
            return null;
        }
        Matcher matcher = DATE_HEADER_PATTERN.matcher(value);
        if (matcher.matches()) {
            return new Date();
        }
        return DateUtils.parseDate((String)value);
    }

    public WebResponse getCachedResponse(WebRequest request) {
        Entry cachedEntry = this.getCacheEntry(request);
        if (cachedEntry == null) {
            return null;
        }
        return cachedEntry.response_;
    }

    public Object getCachedObject(WebRequest request) {
        Entry cachedEntry = this.getCacheEntry(request);
        if (cachedEntry == null) {
            return null;
        }
        return cachedEntry.value_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getCacheEntry(WebRequest request) {
        if (HttpMethod.GET != request.getHttpMethod()) {
            return null;
        }
        URL url = request.getUrl();
        if (url == null) {
            return null;
        }
        String normalizedUrl = UrlUtils.normalize(url);
        Entry cachedEntry = this.entries_.get(normalizedUrl);
        if (cachedEntry == null) {
            return null;
        }
        if (cachedEntry.isStillFresh(this.getCurrentTimestamp())) {
            Map<String, Entry> map = this.entries_;
            synchronized (map) {
                cachedEntry.touch();
            }
            return cachedEntry;
        }
        this.entries_.remove(UrlUtils.normalize(url));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSStyleSheetImpl getCachedStyleSheet(String css) {
        Entry cachedEntry = this.entries_.get(css);
        if (cachedEntry == null) {
            return null;
        }
        Map<String, Entry> map = this.entries_;
        synchronized (map) {
            cachedEntry.touch();
        }
        return (CSSStyleSheetImpl)cachedEntry.value_;
    }

    public int getMaxSize() {
        return this.maxSize_;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("Illegal value for maxSize: " + maxSize);
        }
        this.maxSize_ = maxSize;
        this.deleteOverflow();
    }

    public int getSize() {
        return this.entries_.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Entry> map = this.entries_;
        synchronized (map) {
            for (Entry entry : this.entries_.values()) {
                if (entry.response_ == null) continue;
                entry.response_.cleanUp();
            }
            this.entries_.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOutdated() {
        Map<String, Entry> map = this.entries_;
        synchronized (map) {
            long now = this.getCurrentTimestamp();
            Iterator<Map.Entry<String, Entry>> iter = this.entries_.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Entry> entry = iter.next();
                if (entry.getValue().response_ != null && entry.getValue().isStillFresh(now)) continue;
                iter.remove();
            }
        }
    }

    private static class Entry
    implements Comparable<Entry>,
    Serializable {
        private final String key_;
        private WebResponse response_;
        private Object value_;
        private long lastAccess_;
        private long createdAt_;

        Entry(String key, WebResponse response, Object value) {
            this.key_ = key;
            this.response_ = response;
            this.value_ = value;
            this.lastAccess_ = this.createdAt_ = System.currentTimeMillis();
        }

        @Override
        public int compareTo(Entry other) {
            if (this.lastAccess_ < other.lastAccess_) {
                return -1;
            }
            if (this.lastAccess_ == other.lastAccess_) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object obj) {
            return obj instanceof Entry && this.lastAccess_ == ((Entry)obj).lastAccess_;
        }

        public int hashCode() {
            return Long.valueOf(this.lastAccess_).hashCode();
        }

        public void touch() {
            this.lastAccess_ = System.currentTimeMillis();
        }

        private boolean isStillFresh(long now) {
            long freshnessLifetime = 0L;
            if (!HeaderUtils.containsPrivate(this.response_) && HeaderUtils.containsSMaxage(this.response_)) {
                freshnessLifetime = HeaderUtils.sMaxage(this.response_);
            } else if (HeaderUtils.containsMaxAge(this.response_)) {
                freshnessLifetime = HeaderUtils.maxAge(this.response_);
            } else if (this.response_.getResponseHeaderValue("Expires") != null) {
                Date expires = Cache.parseDateHeader(this.response_, "Expires");
                if (expires != null) {
                    return expires.getTime() - now > 600000L;
                }
            } else {
                return true;
            }
            return now - this.createdAt_ < freshnessLifetime * 1000L;
        }
    }
}

