/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Iterator;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClass
public class NodeList
extends AbstractList {
    private static final String ITERATOR_NAME = "Iterator";
    private static Iterator ITERATOR_PROTOTYPE_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public NodeList() {
    }

    public NodeList(DomNode domNode, boolean attributeChangeSensitive) {
        super(domNode, attributeChangeSensitive);
    }

    public NodeList(DomNode domNode, List<DomNode> initialElements) {
        super(domNode, initialElements);
    }

    private NodeList(ScriptableObject parentScope) {
        this.setParentScope((Scriptable)parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public static NodeList staticNodeList(HtmlUnitScriptable parentScope, final List<DomNode> elements) {
        return new NodeList((ScriptableObject)parentScope){

            @Override
            public List<DomNode> getElements() {
                return elements;
            }
        };
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public Iterator keys() {
        int length = this.getElements().size();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < length; ++i) {
            list.add(i);
        }
        Iterator object = new Iterator(ITERATOR_NAME, list.iterator());
        object.setParentScope(this.getParentScope());
        NodeList.setIteratorPrototype((Scriptable)object);
        return object;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public Iterator values() {
        List<DomNode> list = this.getElements();
        Iterator object = new Iterator(ITERATOR_NAME, list.iterator());
        object.setParentScope(this.getParentScope());
        NodeList.setIteratorPrototype((Scriptable)object);
        return object;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public Iterator entries() {
        List<DomNode> elements = this.getElements();
        Context context = Context.getCurrentContext();
        Scriptable scope = this.getParentScope();
        ArrayList<Scriptable> list = new ArrayList<Scriptable>();
        for (int i = 0; i < elements.size(); ++i) {
            Object[] array = new Object[]{i, elements.get(i).getScriptableObject()};
            list.add(context.newArray(scope, array));
        }
        Iterator object = new Iterator(ITERATOR_NAME, list.iterator());
        object.setParentScope(scope);
        NodeList.setIteratorPrototype((Scriptable)object);
        return object;
    }

    private static void setIteratorPrototype(Scriptable scriptable) {
        if (ITERATOR_PROTOTYPE_ == null) {
            ITERATOR_PROTOTYPE_ = new Iterator(ITERATOR_NAME, null);
        }
        scriptable.setPrototype((Scriptable)ITERATOR_PROTOTYPE_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public void forEach(Object callback) {
        List<DomNode> nodes = this.getElements();
        Context context = Context.enter();
        try {
            Function function = (Function)callback;
            Scriptable scope = this.getParentScope();
            for (int i = 0; i < nodes.size(); ++i) {
                function.call(context, scope, (Scriptable)this, new Object[]{nodes.get(i).getScriptableObject(), i, this});
            }
        }
        finally {
            Context.exit();
        }
    }
}

