/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Iterator;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Delegator;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
public class WeakSet
extends SimpleScriptable {
    private transient Set<Object> set_ = Collections.newSetFromMap(new WeakHashMap());

    public WeakSet() {
    }

    @JsxConstructor
    public WeakSet(Object iterable) {
        if (iterable == Undefined.instance) {
            return;
        }
        if (iterable instanceof NativeArray) {
            NativeArray array = (NativeArray)iterable;
            int i = 0;
            while ((long)i < array.getLength()) {
                Object value2 = ScriptableObject.getProperty((Scriptable)array, (int)i);
                if (Undefined.instance != value2 && value2 instanceof ScriptableObject) {
                    this.add(ScriptableObject.getProperty((Scriptable)array, (int)i));
                }
                ++i;
            }
            return;
        }
        if (iterable instanceof Scriptable) {
            Scriptable scriptable = (Scriptable)iterable;
            if (Iterator.iterate(Context.getCurrentContext(), (Scriptable)this, scriptable, value -> {
                if (Undefined.instance != value && value instanceof ScriptableObject) {
                    this.add(value);
                }
            })) {
                return;
            }
        }
        throw Context.reportRuntimeError((String)("TypeError: object is not iterable (" + iterable.getClass().getName() + ")"));
    }

    @JsxFunction
    public WeakSet add(Object value) {
        if (value instanceof Delegator) {
            value = ((Delegator)value).getDelegee();
        }
        if (!(value instanceof ScriptableObject)) {
            throw Context.reportRuntimeError((String)"TypeError: key is not an object");
        }
        this.set_.add(value);
        return this;
    }

    @JsxFunction
    public void clear() {
        this.set_.clear();
    }

    @JsxFunction
    public boolean delete(Object key) {
        return this.set_.remove(key);
    }

    @JsxFunction
    public boolean has(Object value) {
        return this.set_.contains(value);
    }
}

