/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.background.BasicJavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxStaticFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.BaseFunction;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.JavaScriptException;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.TopLevel;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
public class Promise
extends SimpleScriptable {
    private PromiseState state_ = PromiseState.PENDING;
    private Object value_;
    private boolean race_;
    private Promise[] all_;
    private List<BasicJavaScriptJob> settledJobs_;
    private List<Promise> dependentPromises_;

    public Promise() {
    }

    public Promise(Window window) {
        this.setParentScope((Scriptable)window);
        this.setPrototype(window.getPrototype(Promise.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsxConstructor
    public Promise(Object object) {
        if (!(object instanceof Function)) {
            throw ScriptRuntime.typeError((String)"Promise resolver is not a function");
        }
        Function fun = (Function)object;
        final Window window = Promise.getWindow((Scriptable)fun);
        this.setParentScope((Scriptable)window);
        this.setPrototype(window.getPrototype(this.getClass()));
        final Promise thisPromise = this;
        BaseFunction resolve = new BaseFunction((Scriptable)window, ScriptableObject.getFunctionPrototype((Scriptable)window)){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                thisPromise.settle(true, args.length != 0 ? args[0] : Undefined.instance, window);
                return thisPromise;
            }
        };
        BaseFunction reject = new BaseFunction((Scriptable)window, ScriptableObject.getFunctionPrototype((Scriptable)window)){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                thisPromise.settle(false, args.length != 0 ? args[0] : Undefined.instance, window);
                return thisPromise;
            }
        };
        Context cx = Context.getCurrentContext();
        try {
            ArrayDeque<Window> stack = (ArrayDeque<Window>)cx.getThreadLocal((Object)"startingScope");
            if (null == stack) {
                stack = new ArrayDeque<Window>();
                cx.putThreadLocal((Object)"startingScope", stack);
            }
            stack.push(window);
            try {
                fun.call(cx, (Scriptable)window, (Scriptable)window, new Object[]{resolve, reject});
            }
            finally {
                stack.pop();
            }
            window.getWebWindow().getWebClient().getJavaScriptEngine().processPostponedActions();
        }
        catch (JavaScriptException e) {
            thisPromise.settle(false, e.getValue(), window);
        }
    }

    @JsxStaticFunction
    public static Promise resolve(Context context, Scriptable thisObj, Object[] args, Function function) {
        return Promise.create(thisObj, args, PromiseState.FULFILLED);
    }

    @JsxStaticFunction
    public static Promise reject(Context context, Scriptable thisObj, Object[] args, Function function) {
        return Promise.create(thisObj, args, PromiseState.REJECTED);
    }

    private static Promise create(Scriptable thisObj, Object[] args, PromiseState state) {
        Promise promise;
        if (args.length != 0 && args[0] instanceof Promise && state == PromiseState.FULFILLED) {
            return (Promise)args[0];
        }
        if (args.length > 0) {
            Object arg = args[0];
            if (arg instanceof NativeObject) {
                NativeObject nativeObject = (NativeObject)arg;
                promise = new Promise(nativeObject.get("then", (Scriptable)nativeObject));
            } else {
                promise = new Promise();
                promise.value_ = arg;
                promise.state_ = state;
            }
        } else {
            promise = new Promise();
            promise.value_ = Undefined.instance;
            promise.state_ = state;
        }
        promise.setParentScope(thisObj.getParentScope());
        promise.setPrototype(Promise.getWindow(thisObj).getPrototype(promise.getClass()));
        return promise;
    }

    private void settle(boolean fulfilled, Object newValue, Window window) {
        if (this.state_ != PromiseState.PENDING) {
            return;
        }
        if (this.all_ != null) {
            this.settleAll(window);
            return;
        }
        this.settleThis(fulfilled, newValue, window);
    }

    private void settleThis(boolean fulfilled, Object newValue, Window window) {
        this.value_ = newValue;
        this.state_ = fulfilled ? PromiseState.FULFILLED : PromiseState.REJECTED;
        if (this.settledJobs_ != null) {
            for (BasicJavaScriptJob job : this.settledJobs_) {
                window.getWebWindow().getJobManager().addJob(job, window.getDocument().getPage());
            }
            this.settledJobs_ = null;
        }
        if (this.dependentPromises_ != null) {
            for (Promise promise : this.dependentPromises_) {
                promise.settle(fulfilled, newValue, window);
            }
            this.dependentPromises_ = null;
        }
    }

    private void settleAll(Window window) {
        if (this.race_) {
            for (Promise promise : this.all_) {
                if (promise.state_ == PromiseState.REJECTED) {
                    this.settleThis(false, promise.value_, window);
                    return;
                }
                if (promise.state_ != PromiseState.FULFILLED) continue;
                this.settleThis(true, promise.value_, window);
                return;
            }
            return;
        }
        ArrayList<Object> values = new ArrayList<Object>(this.all_.length);
        for (Promise promise : this.all_) {
            if (promise.state_ == PromiseState.REJECTED) {
                this.settleThis(false, promise.value_, window);
                return;
            }
            if (promise.state_ == PromiseState.PENDING) {
                return;
            }
            values.add(promise.value_);
        }
        NativeArray jsValues = new NativeArray(values.toArray());
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)jsValues, (Scriptable)window, (TopLevel.Builtins)TopLevel.Builtins.Array);
        this.settleThis(true, jsValues, window);
    }

    @JsxStaticFunction
    public static Promise all(Context context, Scriptable thisObj, Object[] args, Function function) {
        return Promise.all(false, thisObj, args);
    }

    @JsxStaticFunction
    public static Promise race(Context context, Scriptable thisObj, Object[] args, Function function) {
        return Promise.all(true, thisObj, args);
    }

    private static Promise all(boolean race, Scriptable thisObj, Object[] args) {
        Window window = Promise.getWindow(thisObj);
        Promise returnPromise = new Promise(window);
        if (args.length == 0) {
            returnPromise.all_ = new Promise[0];
        } else if (args[0] instanceof NativeArray) {
            NativeArray array = (NativeArray)args[0];
            int length = (int)array.getLength();
            returnPromise.all_ = new Promise[length];
            for (int i = 0; i < length; ++i) {
                Object o = array.get(i);
                if (o instanceof Promise) {
                    returnPromise.all_[i] = (Promise)o;
                    if (returnPromise.all_[i].dependentPromises_ == null) {
                        returnPromise.all_[i].dependentPromises_ = new ArrayList<Promise>(2);
                    }
                    returnPromise.all_[i].dependentPromises_.add(returnPromise);
                    continue;
                }
                returnPromise.all_[i] = Promise.create(thisObj, new Object[]{o}, PromiseState.FULFILLED);
            }
        }
        returnPromise.race_ = race;
        returnPromise.settleAll(window);
        return returnPromise;
    }

    @JsxFunction
    public Promise then(final Object onFulfilled, final Object onRejected) {
        final Window window = this.getWindow();
        final Promise returnPromise = new Promise(window);
        final Promise thisPromise = this;
        BasicJavaScriptJob job = new BasicJavaScriptJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block21: {
                    Context cx = Context.enter();
                    try {
                        Function toExecute = null;
                        if (thisPromise.state_ == PromiseState.FULFILLED && onFulfilled instanceof Function) {
                            toExecute = (Function)onFulfilled;
                        } else if (thisPromise.state_ == PromiseState.REJECTED && onRejected instanceof Function) {
                            toExecute = (Function)onRejected;
                        }
                        try {
                            Object callbackResult;
                            if (toExecute == null) {
                                Promise dummy = new Promise();
                                dummy.state_ = thisPromise.state_;
                                dummy.value_ = thisPromise.value_;
                                callbackResult = dummy;
                            } else {
                                ArrayDeque<Window> stack = (ArrayDeque<Window>)cx.getThreadLocal((Object)"startingScope");
                                if (null == stack) {
                                    stack = new ArrayDeque<Window>();
                                    cx.putThreadLocal((Object)"startingScope", stack);
                                }
                                stack.push(window);
                                try {
                                    callbackResult = toExecute.call(cx, (Scriptable)window, (Scriptable)thisPromise, new Object[]{Promise.this.value_});
                                }
                                finally {
                                    stack.pop();
                                }
                                window.getWebWindow().getWebClient().getJavaScriptEngine().processPostponedActions();
                            }
                            if (callbackResult instanceof Promise) {
                                Object resultPromise = callbackResult;
                                if (((Promise)resultPromise).state_ == PromiseState.FULFILLED) {
                                    returnPromise.settle(true, ((Promise)resultPromise).value_, window);
                                } else if (((Promise)resultPromise).state_ == PromiseState.REJECTED) {
                                    returnPromise.settle(false, ((Promise)resultPromise).value_, window);
                                } else {
                                    if (((Promise)resultPromise).dependentPromises_ == null) {
                                        ((Promise)resultPromise).dependentPromises_ = new ArrayList(2);
                                    }
                                    ((Promise)resultPromise).dependentPromises_.add(returnPromise);
                                }
                                break block21;
                            }
                            returnPromise.settle(true, callbackResult, window);
                        }
                        catch (JavaScriptException e) {
                            returnPromise.settle(false, e.getValue(), window);
                        }
                    }
                    finally {
                        Context.exit();
                    }
                }
            }

            @Override
            public String toString() {
                return super.toString() + " Promise.then";
            }
        };
        if (this.state_ == PromiseState.FULFILLED || this.state_ == PromiseState.REJECTED) {
            window.getWebWindow().getJobManager().addJob(job, window.getDocument().getPage());
        } else {
            if (this.settledJobs_ == null) {
                this.settledJobs_ = new ArrayList<BasicJavaScriptJob>(2);
            }
            this.settledJobs_.add(job);
        }
        return returnPromise;
    }

    @JsxFunction(functionName="catch")
    public Promise catch_js(Object onRejected) {
        return this.then(null, onRejected);
    }

    private static enum PromiseState {
        PENDING,
        FULFILLED,
        REJECTED;

    }
}

