/* Generated By:JavaCC: Do not edit this line. SACParserCSS3.java */
package com.steadystate.css.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SimpleSelector;

import com.steadystate.css.parser.media.MediaQuery;
import com.steadystate.css.dom.Property;
import com.steadystate.css.dom.CSSValueImpl;


/**
 * @author <a href="mailto:davidsch@users.sourceforge.net">David Schweinsberg</a>
 * @author waldbaer
 * @author Ahmed Ashour
 * @author rbri
 * @version $Id: SACParserCSS21.jj,v 1.9 2010-05-19 13:26:51 waldbaer Exp $
 */
public class SACParserCSS3 extends AbstractSACParser implements Parser, SACParserCSS3Constants {

    public SACParserCSS3() {
        this((CharStream) null);
    }

    public String getParserVersion() {
        return "http://www.w3.org/Style/CSS/";
    }

    protected String getGrammarUri()
    {
        return "http://www.w3.org/TR/WD-css3-syntax-20030813";
    }

    protected Token getToken()
    {
        return token;
    }

//
// stylesheet
//  : [ CHARSET_SYM STRING ';' ]?
//    [S|CDO|CDC]* [ import [S|CDO|CDC]* ]*
//    [ [ ruleset | media | page | font_face ] [S|CDO|CDC]* ]*
//  ;
//
  final public void styleSheet() throws ParseException {
    try {
          handleStartDocument();
      styleSheetRuleList();
      jj_consume_token(0);
    } finally {
        handleEndDocument();
    }
  }

  final public void styleSheetRuleList() throws ParseException {
  boolean ruleFound = false;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
      case CDO:
      case CDC:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        jj_consume_token(S);
        break;
      case CDO:
        jj_consume_token(CDO);
        break;
      case CDC:
        jj_consume_token(CDC);
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHARSET_SYM:
      charsetRule();
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
        case CDO:
        case CDC:
          ;
          break;
        default:
          jj_la1[2] = jj_gen;
          break label_2;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          jj_consume_token(S);
          break;
        case CDO:
          jj_consume_token(CDO);
          break;
        case CDC:
          jj_consume_token(CDC);
          break;
        default:
          jj_la1[3] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IMPORT_SYM:
      case PAGE_SYM:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case ATKEYWORD:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORT_SYM:
        importRule(ruleFound);
        break;
      case IDENT:
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case PAGE_SYM:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case ATKEYWORD:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
        case DOT:
        case COLON:
        case ASTERISK:
        case LSQUARE:
        case HASH:
          styleRule();
          break;
        case MEDIA_SYM:
          mediaRule();
          break;
        case PAGE_SYM:
          pageRule();
          break;
        case FONT_FACE_SYM:
          fontFaceRule();
          break;
        case ATKEYWORD:
          unknownAtRule();
          break;
        default:
          jj_la1[6] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                ruleFound = true;
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
        case CDO:
        case CDC:
          ;
          break;
        default:
          jj_la1[8] = jj_gen;
          break label_4;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          jj_consume_token(S);
          break;
        case CDO:
          jj_consume_token(CDO);
          break;
        case CDC:
          jj_consume_token(CDC);
          break;
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

//
// This is used by ASTStyleSheet.insertRule to parse a single rule
//
  final public void styleSheetRuleSingle() throws ParseException {
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_5;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHARSET_SYM:
      charsetRule();
      break;
    case IMPORT_SYM:
      importRule(false);
      break;
    case IDENT:
    case DOT:
    case COLON:
    case ASTERISK:
    case LSQUARE:
    case HASH:
      styleRule();
      break;
    case MEDIA_SYM:
      mediaRule();
      break;
    case PAGE_SYM:
      pageRule();
      break;
    case FONT_FACE_SYM:
      fontFaceRule();
      break;
    case ATKEYWORD:
      unknownAtRule();
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_6;
      }
      jj_consume_token(S);
    }
  }

  final public void charsetRule() throws ParseException {
  Token t;
  Locator locator;
    try {
      jj_consume_token(CHARSET_SYM);
            locator = getLocator();
      jj_consume_token(S);
      t = jj_consume_token(STRING);
      jj_consume_token(SEMICOLON);
            handleCharset(t.toString(), locator);
    } catch (ParseException e) {
        getErrorHandler().error(toCSSParseException("invalidCharsetRule", e));
    }
  }

  final public void unknownAtRule() throws ParseException {
    String s;
    Locator locator;
    try {
      jj_consume_token(ATKEYWORD);
            locator = getLocator();
            s = skip();
            handleIgnorableAtRule(s, locator);
    } catch (ParseException e) {
        getErrorHandler().error(toCSSParseException("invalidUnknownRule", e));
    }
  }

//
// import
//  : IMPORT_SYM S*
//    [STRING|URI] S* [ medium [ COMMA S* medium]* ]? ';' S*
//  ;
//
  final public void importRule(final boolean nonImportRuleFoundBefore) throws ParseException {
    Token t;
    SACMediaListImpl ml = new SACMediaListImpl();
    Locator locator;
    try {
            ParseException e = null;
            if (nonImportRuleFoundBefore)
            {
                e = generateParseException();
            }
      jj_consume_token(IMPORT_SYM);
            locator = getLocator();
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[13] = jj_gen;
          break label_7;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        t = jj_consume_token(STRING);
        break;
      case URI:
        t = jj_consume_token(URI);
        break;
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[15] = jj_gen;
          break label_8;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
      case ONLY:
      case IDENT:
      case LROUND:
        mediaList(ml);
        break;
      default:
        jj_la1[16] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
            if (nonImportRuleFoundBefore)
            {
                getErrorHandler().error(toCSSParseException("invalidImportRuleIgnored2", e));
            }
            else
            {
                handleImportStyle(unescape(t.image, false), ml, null, locator);
            }
    } catch (CSSParseException e) {
        getErrorHandler().error(e);
        error_skipAtRule();
    } catch (ParseException e) {
        getErrorHandler().error(toCSSParseException("invalidImportRule", e));
        error_skipAtRule();
    }
  }

//
// media
//  : MEDIA_SYM S* medium [ COMMA S* medium ]* '{' S* ruleset* '}' S*
//  ;
//
  final public void mediaRule() throws ParseException {
    boolean start = false;
    SACMediaListImpl ml = new SACMediaListImpl();
    Locator locator;
    try {
      jj_consume_token(MEDIA_SYM);
            locator = getLocator();
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[17] = jj_gen;
          break label_9;
        }
        jj_consume_token(S);
      }
      mediaList(ml);
            start = true;
            handleStartMedia(ml, locator);
      jj_consume_token(LBRACE);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[18] = jj_gen;
          break label_10;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IMPORT_SYM:
      case PAGE_SYM:
      case ATKEYWORD:
        mediaRuleList();
        break;
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
    } catch (CSSParseException e) {
        getErrorHandler().error(e);
        error_skipblock();
    } catch (ParseException e) {
        CSSParseException cpe = toCSSParseException("invalidMediaRule", e);
        getErrorHandler().error(cpe);
        getErrorHandler().warning(createSkipWarning("ignoringRule", cpe));
        error_skipblock();
    } finally {
        if (start) {
            handleEndMedia(ml);
        }
    }
  }

  final public void mediaList(SACMediaListImpl ml) throws ParseException {
    MediaQuery mq;
    try {
      mq = mediaQuery();
            ml.setLocator(getLocator());
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[20] = jj_gen;
          break label_11;
        }
        jj_consume_token(COMMA);
        label_12:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[21] = jj_gen;
            break label_12;
          }
          jj_consume_token(S);
        }
                             ml.add(mq);
        mq = mediaQuery();
      }
          ml.add(mq);
    } catch (ParseException e) {
        {if (true) throw toCSSParseException("invalidMediaList", e);}
    }
  }

//
// media_query
//   : [ONLY | NOT]? S* media_type S* [ AND S* expression ]*
//   | expression [ AND S* expression ]*
//   ;
//
  final public MediaQuery mediaQuery() throws ParseException {
    String s;
    MediaQuery mq;
    Property p;
    boolean only = false;
    boolean not = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
    case ONLY:
    case IDENT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
      case ONLY:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ONLY:
          jj_consume_token(ONLY);
                   only = true;
          break;
        case NOT:
          jj_consume_token(NOT);
                  not = true;
          break;
        default:
          jj_la1[22] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_13:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[23] = jj_gen;
            break label_13;
          }
          jj_consume_token(S);
        }
        break;
      default:
        jj_la1[24] = jj_gen;
        ;
      }
      s = medium();
        mq = new MediaQuery(s, only, not); mq.setLocator(getLocator());
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AND:
          ;
          break;
        default:
          jj_la1[25] = jj_gen;
          break label_14;
        }
        jj_consume_token(AND);
        label_15:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[26] = jj_gen;
            break label_15;
          }
          jj_consume_token(S);
        }
        p = mediaExpression();
            mq.addMediaProperty(p);
      }
      break;
    case LROUND:
      p = mediaExpression();
          s = "all";
          handleMedium(s, null);
          mq = new MediaQuery(s, only, not);
          mq.setLocator(getLocator());
          mq.addMediaProperty(p);
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AND:
          ;
          break;
        default:
          jj_la1[27] = jj_gen;
          break label_16;
        }
        jj_consume_token(AND);
        label_17:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[28] = jj_gen;
            break label_17;
          }
          jj_consume_token(S);
        }
        p = mediaExpression();
            mq.addMediaProperty(p);
      }
      break;
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return mq;}
    throw new Error("Missing return statement in function");
  }

//
// expression
//   : '(' S* media_feature S* [ ':' S* expr ]? ')' S*
//   ;
//
  final public Property mediaExpression() throws ParseException {
  String p;
  LexicalUnit e = null;
  Property prop;
    jj_consume_token(LROUND);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[30] = jj_gen;
        break label_18;
      }
      jj_consume_token(S);
    }
    p = property();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      jj_consume_token(COLON);
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[31] = jj_gen;
          break label_19;
        }
        jj_consume_token(S);
      }
      e = expr();
      break;
    default:
      jj_la1[32] = jj_gen;
      ;
    }
    jj_consume_token(RROUND);
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[33] = jj_gen;
        break label_20;
      }
      jj_consume_token(S);
    }
        if(e==null)
        {
          prop = new Property(p, null, false);
        }
        else
        {
          prop = new Property(p, new CSSValueImpl(e), false);
        }
        {if (true) return prop;}
    throw new Error("Missing return statement in function");
  }

  final public void mediaRuleList() throws ParseException {
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
        styleRule();
        break;
      case PAGE_SYM:
        pageRule();
        break;
      case IMPORT_SYM:
        importRule(true);
        break;
      case ATKEYWORD:
        unknownAtRule();
        break;
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[35] = jj_gen;
          break label_22;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IMPORT_SYM:
      case PAGE_SYM:
      case ATKEYWORD:
        ;
        break;
      default:
        jj_la1[36] = jj_gen;
        break label_21;
      }
    }
  }

//
// medium
//   : IDENT S*
//   ;
//
  final public String medium() throws ParseException {
  Token t;
  String medium;
    t = jj_consume_token(IDENT);
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[37] = jj_gen;
        break label_23;
      }
      jj_consume_token(S);
    }
        medium = unescape(t.image, false);
        handleMedium(medium, createLocator(t));
        {if (true) return medium;}
    throw new Error("Missing return statement in function");
  }

//
// page
//  : PAGE_SYM S* pseudo_page? S*
//    '{' S* declaration [ ';' S* declaration ]* '}' S*
//  ;
//
  final public void pageRule() throws ParseException {
    String s = null;
    boolean start = false;
    Locator locator;
    try {
      jj_consume_token(PAGE_SYM);
            locator = getLocator();
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[38] = jj_gen;
          break label_24;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        s = pseudoPage();
        label_25:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[39] = jj_gen;
            break label_25;
          }
          jj_consume_token(S);
        }
        break;
      default:
        jj_la1[40] = jj_gen;
        ;
      }
      jj_consume_token(LBRACE);
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[41] = jj_gen;
          break label_26;
        }
        jj_consume_token(S);
      }
            start = true;
            handleStartPage(null, s, locator);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case ASTERISK:
        declaration();
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[43] = jj_gen;
          break label_27;
        }
        jj_consume_token(SEMICOLON);
        label_28:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[44] = jj_gen;
            break label_28;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
        case ASTERISK:
          declaration();
          break;
        default:
          jj_la1[45] = jj_gen;
          ;
        }
      }
      jj_consume_token(RBRACE);
    } catch (CSSParseException e) {
        getErrorHandler().error(e);
        error_skipblock();
    } catch (ParseException e) {
        CSSParseException cpe = toCSSParseException("invalidPageRule", e);
        getErrorHandler().error(cpe);
        getErrorHandler().warning(createSkipWarning("ignoringRule", cpe));
        error_skipblock();
    } finally {
        if (start) {
            handleEndPage(null, s);
        }
    }
  }

//
// pseudoPage
//   : ':' IDENT
//   ;
//
  final public String pseudoPage() throws ParseException {
  Token t;
    jj_consume_token(COLON);
    t = jj_consume_token(IDENT);
                        {if (true) return unescape(t.image, false);}
    throw new Error("Missing return statement in function");
  }

//
// font_face
//  : FONT_FACE_SYM S*
//    '{' S* declaration [ ';' S* declaration ]* '}' S*
//  ;
//
  final public void fontFaceRule() throws ParseException {
    boolean start = false;
    Locator locator;
    try {
      jj_consume_token(FONT_FACE_SYM);
            locator = getLocator();
      label_29:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[46] = jj_gen;
          break label_29;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LBRACE);
      label_30:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[47] = jj_gen;
          break label_30;
        }
        jj_consume_token(S);
      }
                            start = true; handleStartFontFace(locator);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case ASTERISK:
        declaration();
        break;
      default:
        jj_la1[48] = jj_gen;
        ;
      }
      label_31:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[49] = jj_gen;
          break label_31;
        }
        jj_consume_token(SEMICOLON);
        label_32:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[50] = jj_gen;
            break label_32;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
        case ASTERISK:
          declaration();
          break;
        default:
          jj_la1[51] = jj_gen;
          ;
        }
      }
      jj_consume_token(RBRACE);
    } catch (ParseException e) {
        {if (true) throw toCSSParseException("invalidFontFaceRule", e);}
    } finally {
        if (start) {
            handleEndFontFace();
        }
    }
  }

//
// operator
//  : '/' S* | COMMA S* | /* empty */
//  ;
//
  final public LexicalUnit operator(LexicalUnit prev) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SLASH:
      jj_consume_token(SLASH);
      label_33:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[52] = jj_gen;
          break label_33;
        }
        jj_consume_token(S);
      }
                       {if (true) return new LexicalUnitImpl(prev, LexicalUnit.SAC_OPERATOR_SLASH);}
      break;
    case COMMA:
      jj_consume_token(COMMA);
      label_34:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[53] = jj_gen;
          break label_34;
        }
        jj_consume_token(S);
      }
                       {if (true) return LexicalUnitImpl.createComma(prev);}
      break;
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

//
// combinator
//  : PLUS S*
//  | GREATER S*
//  | S
//  ;
//
  final public char combinator() throws ParseException {
  char c = ' ';
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
             c='+';
      label_35:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[55] = jj_gen;
          break label_35;
        }
        jj_consume_token(S);
      }
      break;
    case GREATER:
      jj_consume_token(GREATER);
                c='>';
      label_36:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[56] = jj_gen;
          break label_36;
        }
        jj_consume_token(S);
      }
      break;
    case TILDE:
      jj_consume_token(TILDE);
              c='~';
      label_37:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[57] = jj_gen;
          break label_37;
        }
        jj_consume_token(S);
      }
      break;
    case S:
      jj_consume_token(S);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case GREATER:
      case TILDE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
          jj_consume_token(PLUS);
                     c='+';
          break;
        case GREATER:
          jj_consume_token(GREATER);
                                            c='>';
          break;
        case TILDE:
          jj_consume_token(TILDE);
                                                                 c='~';
          break;
        default:
          jj_la1[58] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_38:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[59] = jj_gen;
            break label_38;
          }
          jj_consume_token(S);
        }
        break;
      default:
        jj_la1[60] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return c;}
    throw new Error("Missing return statement in function");
  }

//
// unary_operator
//  : '-' | PLUS
//  ;
//
  final public char unaryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      jj_consume_token(MINUS);
              {if (true) return '-';}
      break;
    case PLUS:
      jj_consume_token(PLUS);
                                       {if (true) return '+';}
      break;
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

//
// property
//   : IDENT S*
//   ;
//
  final public String property() throws ParseException {
    Token t;
    t = jj_consume_token(IDENT);
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[63] = jj_gen;
        break label_39;
      }
      jj_consume_token(S);
    }
      {if (true) return unescape(t.image, false);}
    throw new Error("Missing return statement in function");
  }

//
// ruleset
//  : selector [ COMMA S* selector ]*
//    '{' S* declaration [ ';' S* declaration ]* '}' S*
//  ;
//
  final public void styleRule() throws ParseException {
    SelectorList selList = null;
    boolean start = false;
    Token t;
    try {
            t = getToken();
      selList = selectorList();
      jj_consume_token(LBRACE);
      label_40:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[64] = jj_gen;
          break label_40;
        }
        jj_consume_token(S);
      }
            start = true;
            handleStartSelector(selList, createLocator(t.next));
      styleDeclaration();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RBRACE:
        jj_consume_token(RBRACE);
        break;
      case 0:
        jj_consume_token(0);
        break;
      default:
        jj_la1[65] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (CSSParseException e) {
        getErrorHandler().error(e);
        getErrorHandler().warning(createSkipWarning("ignoringRule", e));
        error_skipblock();
    } catch (ParseException e) {
        CSSParseException cpe = toCSSParseException("invalidStyleRule", e);
        getErrorHandler().error(cpe);
        getErrorHandler().warning(createSkipWarning("ignoringFollowingDeclarations", cpe));
        error_skipblock();
    } finally {
        if (start) {
            handleEndSelector(selList);
        }
    }
  }

  final public SelectorList parseSelectorsInternal() throws ParseException {
    SelectorList selectors;
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[66] = jj_gen;
        break label_41;
      }
      jj_consume_token(S);
    }
    selectors = selectorList();
    jj_consume_token(0);
        {if (true) return selectors;}
    throw new Error("Missing return statement in function");
  }

  final public SelectorList selectorList() throws ParseException {
    SelectorListImpl selList = new SelectorListImpl();
    Selector sel;
    sel = selector();
        if (sel instanceof Locatable)
        {
            selList.setLocator(((Locatable) sel).getLocator());
        }
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[67] = jj_gen;
        break label_42;
      }
      jj_consume_token(COMMA);
      label_43:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[68] = jj_gen;
          break label_43;
        }
        jj_consume_token(S);
      }
                         selList.add(sel);
      sel = selector();
    }
        selList.add(sel);
        {if (true) return selList;}
    throw new Error("Missing return statement in function");
  }

//
// selector
//   : simple_selector_sequence [ combinator simple_selector_sequence ]*
//   ;
//
  final public Selector selector() throws ParseException {
    Selector sel;
    char comb;
    try {
      sel = simpleSelector(null, ' ');
      label_44:
      while (true) {
        if (jj_2_1(2)) {
          ;
        } else {
          break label_44;
        }
        comb = combinator();
        sel = simpleSelector(sel, comb);
      }
      label_45:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[69] = jj_gen;
          break label_45;
        }
        jj_consume_token(S);
      }
            {if (true) return sel;}
    } catch (ParseException e) {
        {if (true) throw toCSSParseException("invalidSelector", e);}
    }
    throw new Error("Missing return statement in function");
  }

//
// simple_selector
//  : element_name [ HASH | class | attrib | pseudo ]*
//  | [ HASH | class | attrib | pseudo ]+
//  ;
//
  final public Selector simpleSelector(Selector sel, char comb) throws ParseException {
    SimpleSelector simpleSel = null;
    Condition c = null;
    SimpleSelector pseudoElementSel = null;
    Object o = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case ASTERISK:
        simpleSel = elementName();
        label_46:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DOT:
          case COLON:
          case LSQUARE:
          case HASH:
            ;
            break;
          default:
            jj_la1[70] = jj_gen;
            break label_46;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case HASH:
            c = hash(c, null != pseudoElementSel);
            break;
          case DOT:
            c = _class(c, null != pseudoElementSel);
            break;
          case LSQUARE:
            c = attrib(c, null != pseudoElementSel);
            break;
          case COLON:
            o = pseudo(c, null != pseudoElementSel);
                       if (o instanceof Condition)
                       {   c = (Condition) o;
                       } else {
                           pseudoElementSel = (SimpleSelector) o;
                       }
            break;
          default:
            jj_la1[71] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      case DOT:
      case COLON:
      case LSQUARE:
      case HASH:
                simpleSel = getSelectorFactory().createElementSelector(null, null);
        label_47:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case HASH:
            c = hash(c, null != pseudoElementSel);
            break;
          case DOT:
            c = _class(c, null != pseudoElementSel);
            break;
          case LSQUARE:
            c = attrib(c, null != pseudoElementSel);
            break;
          case COLON:
            o = pseudo(c, null != pseudoElementSel);
                       if (o instanceof Condition)
                       {   c = (Condition) o;
                       } else {
                           pseudoElementSel = (SimpleSelector) o;
                       }
            break;
          default:
            jj_la1[72] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DOT:
          case COLON:
          case LSQUARE:
          case HASH:
            ;
            break;
          default:
            jj_la1[73] = jj_gen;
            break label_47;
          }
        }
        break;
      default:
        jj_la1[74] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            if (c != null) {
                simpleSel = getSelectorFactory().createConditionalSelector(simpleSel, c);
            }

            if (sel == null) {
                sel = simpleSel;
            } else {
                switch (comb) {
                case ' ':
                    sel = getSelectorFactory().createDescendantSelector(sel, simpleSel);
                    break;
                case '+':
                    sel = getSelectorFactory().createDirectAdjacentSelector(sel.getSelectorType(), sel, simpleSel);
                    break;
                case '>':
                    sel = getSelectorFactory().createChildSelector(sel, simpleSel);
                    break;
                case '~':
                    sel = ((com.steadystate.css.parser.selectors.SelectorFactoryImpl) getSelectorFactory())
                        .createGeneralAdjacentSelector(sel.getSelectorType(), sel, simpleSel);
                    break;
                }
            }
            if (pseudoElementSel != null)
            {
                sel = getSelectorFactory().createDescendantSelector(sel, pseudoElementSel);
            }

            {if (true) return sel;}
    } catch (ParseException e) {
        {if (true) throw toCSSParseException("invalidSimpleSelector", e);}
    }
    throw new Error("Missing return statement in function");
  }

//
// class
//   : '.' IDENT
//   ;
//
  final public Condition _class(Condition pred, boolean pseudoElementFound) throws ParseException {
    Token t;
    Locator locator;
    ParseException pe = null;
    try {
          if (pseudoElementFound) { pe = generateParseException(); }
      jj_consume_token(DOT);
            locator = getLocator();
      t = jj_consume_token(IDENT);
            if (pseudoElementFound) { {if (true) throw pe;} }
            Condition c = getConditionFactory().createClassCondition(null, unescape(t.image, false));
            if (c instanceof Locatable)
            {
                ((Locatable) c).setLocator(locator);
            }
            {if (true) return (pred == null) ? c : getConditionFactory().createAndCondition(pred, c);}
    } catch (ParseException e) {
        {if (true) throw toCSSParseException("invalidClassSelector", e);}
    }
    throw new Error("Missing return statement in function");
  }

//
// element_name
//   : IDENT | '*'
//   ;
//
  final public SimpleSelector elementName() throws ParseException {
    Token t;
    SimpleSelector sel;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        t = jj_consume_token(IDENT);
            sel = getSelectorFactory().createElementSelector(null, unescape(t.image, false));
            if (sel instanceof Locatable)
            {
                ((Locatable) sel).setLocator(getLocator());
            }
            {if (true) return sel;}
        break;
      case ASTERISK:
        jj_consume_token(ASTERISK);
            sel = getSelectorFactory().createElementSelector(null, null);
            if (sel instanceof Locatable)
            {
                ((Locatable) sel).setLocator(getLocator());
            }
            {if (true) return sel;}
        break;
      default:
        jj_la1[75] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (ParseException e) {
        {if (true) throw toCSSParseException("invalidElementName", e);}
    }
    throw new Error("Missing return statement in function");
  }

//
// attrib
//   : '[' S* IDENT S* [ [ '=' | INCLUDES | DASHMATCH | PREFIXMATCH | SUFFIXMATCH | SUBSTRINGMATCH ] S*
//     [ IDENT | STRING ] S* ]? ']'
//   ;
//
  final public Condition attrib(Condition pred, boolean pseudoElementFound) throws ParseException {
    Token t;
    String name = null;
    String value = null;
    int type = 0;
    Locator locator;
    try {
      jj_consume_token(LSQUARE);
            locator = getLocator();
      label_48:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[76] = jj_gen;
          break label_48;
        }
        jj_consume_token(S);
      }
          if (pseudoElementFound) { {if (true) throw generateParseException();} }
      t = jj_consume_token(IDENT);
                      name = unescape(t.image, false);
      label_49:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[77] = jj_gen;
          break label_49;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INCLUDES:
      case DASHMATCH:
      case PREFIXMATCH:
      case SUFFIXMATCH:
      case SUBSTRINGMATCH:
      case EQUALS:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PREFIXMATCH:
          jj_consume_token(PREFIXMATCH);
                                type = 4;
          break;
        case SUFFIXMATCH:
          jj_consume_token(SUFFIXMATCH);
                                type = 5;
          break;
        case SUBSTRINGMATCH:
          jj_consume_token(SUBSTRINGMATCH);
                                   type = 6;
          break;
        case EQUALS:
          jj_consume_token(EQUALS);
                      type = 1;
          break;
        case INCLUDES:
          jj_consume_token(INCLUDES);
                             type = 2;
          break;
        case DASHMATCH:
          jj_consume_token(DASHMATCH);
                              type = 3;
          break;
        default:
          jj_la1[78] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_50:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[79] = jj_gen;
            break label_50;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
          t = jj_consume_token(IDENT);
                              value = unescape(t.image, false);
          break;
        case STRING:
          t = jj_consume_token(STRING);
                               value = unescape(t.image, false);
          break;
        default:
          jj_la1[80] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_51:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[81] = jj_gen;
            break label_51;
          }
          jj_consume_token(S);
        }
        break;
      default:
        jj_la1[82] = jj_gen;
        ;
      }
      jj_consume_token(RSQUARE);
            Condition c = null;
            switch (type) {
            case 0:
                c = getConditionFactory().createAttributeCondition(name, null, false, null);
                break;
            case 1:
                c = getConditionFactory().createAttributeCondition(name, null, null != value, value);
                break;
            case 2:
                c = getConditionFactory().createOneOfAttributeCondition(name, null, null != value, value);
                break;
            case 3:
                c = getConditionFactory().createBeginHyphenAttributeCondition(name, null, null != value, value);
                break;
            case 4:
                c = ((com.steadystate.css.parser.selectors.ConditionFactoryImpl) getConditionFactory())
                    .createPrefixAttributeCondition(name, null, null != value, value);
                break;
            case 5:
                c = ((com.steadystate.css.parser.selectors.ConditionFactoryImpl) getConditionFactory())
                    .createSuffixAttributeCondition(name, null, null != value, value);
                break;
            case 6:
                c = ((com.steadystate.css.parser.selectors.ConditionFactoryImpl) getConditionFactory())
                    .createSubstringAttributeCondition(name, null, null != value, value);
                break;
            }
            if (c instanceof Locatable) {
                ((Locatable) c).setLocator(locator);
            }
            {if (true) return (pred == null) ? c : getConditionFactory().createAndCondition(pred, c);}
    } catch (ParseException e) {
        {if (true) throw toCSSParseException("invalidAttrib", e);}
    }
    throw new Error("Missing return statement in function");
  }

//
// pseudo
//  : ':' (':')?
//        [ IDENT
//          | FUNCTION_NOT S* selector() S* ')'
//          | FUNCTION_LANG S* IDENT S* ')'
//          | FUNCTION S* ((PLUS | MINUS | DIMENSION | NUMBER | STRING | IDENT)? S*)+ ')'
//        ]
//  ;
//
  final public Object pseudo(Condition pred, boolean pseudoElementFound) throws ParseException {
    SimpleSelector pseudoElementSel = null;
    Condition c = null;
    Token t;
    String function;
    Selector sel;
    Locator locator;
    try {
      jj_consume_token(COLON);
                  locator = getLocator();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        jj_consume_token(COLON);
        break;
      default:
        jj_la1[83] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        t = jj_consume_token(IDENT);
                String s = unescape(t.image, false);
                if (pseudoElementFound) { {if (true) throw toCSSParseException("duplicatePseudo", new String[] { s }, locator);} }
                if ("first-line".equals(s)
                    || "first-letter".equals(s)
                    || "before".equals(s)
                    || "after".equals(s))
                {
                    pseudoElementSel = getSelectorFactory().createPseudoElementSelector(null, s);
                    if (pseudoElementSel instanceof Locatable) {
                        ((Locatable) pseudoElementSel).setLocator(locator);
                    }
                    {if (true) return pseudoElementSel;}
                }
                c = getConditionFactory().createPseudoClassCondition(null, s);
                if (c instanceof Locatable) {
                    ((Locatable) c).setLocator(locator);
                }
                {if (true) return (pred == null)
                    ? c
                    : getConditionFactory().createAndCondition(pred, c);}
        break;
      case FUNCTION_NOT:
        t = jj_consume_token(FUNCTION_NOT);
                                     function = unescape(t.image, false);
        label_52:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[84] = jj_gen;
            break label_52;
          }
          jj_consume_token(S);
        }
        sel = negation_arg();
                                       String arg = sel.toString();
        label_53:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[85] = jj_gen;
            break label_53;
          }
          jj_consume_token(S);
        }
        jj_consume_token(RROUND);
                    if (pseudoElementFound) { {if (true) throw toCSSParseException("duplicatePseudo", new String[] { function + arg + ")" }, locator);} }
                    c = getConditionFactory().createPseudoClassCondition(null, function + arg + ")");
                    if (c instanceof Locatable) {
                        ((Locatable) c).setLocator(locator);
                    }
                    {if (true) return (pred == null)
                        ? c
                        : getConditionFactory().createAndCondition(pred, c);}
        break;
      case FUNCTION_LANG:
        t = jj_consume_token(FUNCTION_LANG);
                                      function = unescape(t.image, false);
        label_54:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[86] = jj_gen;
            break label_54;
          }
          jj_consume_token(S);
        }
        t = jj_consume_token(IDENT);
                              String lang = unescape(t.image, false);
        label_55:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[87] = jj_gen;
            break label_55;
          }
          jj_consume_token(S);
        }
        jj_consume_token(RROUND);
                    if (pseudoElementFound) { {if (true) throw toCSSParseException("duplicatePseudo", new String[] { "lang(" + lang + ")" }, locator);} }
                    c = getConditionFactory().createLangCondition(lang);
                    if (c instanceof Locatable) {
                        ((Locatable) c).setLocator(locator);
                    }
                    {if (true) return (pred == null)
                        ? c
                        : getConditionFactory().createAndCondition(pred, c);}
        break;
      case FUNCTION:
        t = jj_consume_token(FUNCTION);
                                 function = unescape(t.image, false); StringBuilder args = new StringBuilder();
        label_56:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[88] = jj_gen;
            break label_56;
          }
          jj_consume_token(S);
        }
        label_57:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case PLUS:
            t = jj_consume_token(PLUS);
            break;
          case MINUS:
            t = jj_consume_token(MINUS);
            break;
          case DIMENSION:
            t = jj_consume_token(DIMENSION);
            break;
          case NUMBER:
            t = jj_consume_token(NUMBER);
            break;
          case STRING:
            t = jj_consume_token(STRING);
            break;
          case IDENT:
            t = jj_consume_token(IDENT);
            break;
          default:
            jj_la1[89] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
                      args.append(unescape(t.image, false));
          label_58:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case S:
              ;
              break;
            default:
              jj_la1[90] = jj_gen;
              break label_58;
            }
            t = jj_consume_token(S);
                          args.append(unescape(t.image, false));
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NUMBER:
          case IDENT:
          case STRING:
          case MINUS:
          case PLUS:
          case DIMENSION:
            ;
            break;
          default:
            jj_la1[91] = jj_gen;
            break label_57;
          }
        }
        jj_consume_token(RROUND);
                    if (pseudoElementFound) { {if (true) throw toCSSParseException("duplicatePseudo", new String[] { function + args.toString().trim() + ")" }, locator);} }
                    c = getConditionFactory().createPseudoClassCondition(null, function + args.toString().trim() + ")");
                    if (c instanceof Locatable) {
                        ((Locatable) c).setLocator(locator);
                    }
                    {if (true) return (pred == null)
                        ? c
                        : getConditionFactory().createAndCondition(pred, c);}
        break;
      default:
        jj_la1[92] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (ParseException e) {
        {if (true) throw toCSSParseException("invalidPseudo", e);}
    }
    throw new Error("Missing return statement in function");
  }

  final public Condition hash(Condition pred, boolean pseudoElementFound) throws ParseException {
    Token t;
    ParseException pe = null;
    try {
          if (pseudoElementFound) { pe = generateParseException(); }
      t = jj_consume_token(HASH);
            if (pseudoElementFound) { {if (true) throw pe;} }
            Condition c = getConditionFactory().createIdCondition(unescape(t.image.substring(1), false));
            if (c instanceof Locatable)
            {
                ((Locatable) c).setLocator(getLocator());
            }
            {if (true) return (pred == null) ? c : getConditionFactory().createAndCondition(pred, c);}
    } catch (ParseException e) {
        {if (true) throw toCSSParseException("invalidHash", e);}
    }
    throw new Error("Missing return statement in function");
  }

  final public void styleDeclaration() throws ParseException {
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
      case ASTERISK:
        declaration();
        break;
      default:
        jj_la1[93] = jj_gen;
        ;
      }
      label_59:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[94] = jj_gen;
          break label_59;
        }
        jj_consume_token(SEMICOLON);
        label_60:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[95] = jj_gen;
            break label_60;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
        case ASTERISK:
          declaration();
          break;
        default:
          jj_la1[96] = jj_gen;
          ;
        }
      }
    } catch (ParseException ex) {
        CSSParseException cpe = toCSSParseException("invalidDeclaration", ex);
        getErrorHandler().error(cpe);
        error_skipdecl();
    }
  }

//
// declaration
//   : property ':' S* expr prio?
//   |
//   ;
//
  final public void declaration() throws ParseException {
  String p;
  LexicalUnit e;
  boolean priority = false;
  Locator starHack = null;
  Locator locator = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
        jj_consume_token(ASTERISK);
                       starHack = getLocator();
        break;
      default:
        jj_la1[97] = jj_gen;
        ;
      }
      p = property();
            locator = getLocator();
      jj_consume_token(COLON);
      label_61:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[98] = jj_gen;
          break label_61;
        }
        jj_consume_token(S);
      }
      e = expr();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORTANT_SYM:
        priority = prio();
        break;
      default:
        jj_la1[99] = jj_gen;
        ;
      }
            if (starHack != null)
            {
                CSSParseException cpe = toCSSParseException("invalidDeclarationStarHack", null, starHack);
                getErrorHandler().error(cpe);
                {if (true) return;}
            }
            handleProperty(p, e, priority, locator);
    } catch (CSSParseException ex) {
        getErrorHandler().error(ex);
        error_skipdecl();
    } catch (ParseException ex) {
        CSSParseException cpe = toCSSParseException("invalidDeclaration", ex);
        getErrorHandler().error(cpe);
        error_skipdecl();
    }
  }

//
// prio
//   : IMPORTANT_SYM S*
//   ;
  final public boolean prio() throws ParseException {
    jj_consume_token(IMPORTANT_SYM);
    label_62:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[100] = jj_gen;
        break label_62;
      }
      jj_consume_token(S);
    }
    {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

//
// expr
//   : term [ operator term ]*
//   ;
//
// TODO: Deal with the operator
//
  final public LexicalUnit expr() throws ParseException {
    LexicalUnit head;
    LexicalUnit body;
    try {
      head = term(null);
                            body = head;
      label_63:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMBER:
        case INHERIT:
        case IDENT:
        case STRING:
        case SLASH:
        case MINUS:
        case PLUS:
        case COMMA:
        case HASH:
        case EMS:
        case EXS:
        case LENGTH_PX:
        case LENGTH_CM:
        case LENGTH_MM:
        case LENGTH_IN:
        case LENGTH_PT:
        case LENGTH_PC:
        case ANGLE_DEG:
        case ANGLE_RAD:
        case ANGLE_GRAD:
        case TIME_MS:
        case TIME_S:
        case FREQ_HZ:
        case FREQ_KHZ:
        case RESOLUTION_DPI:
        case RESOLUTION_DPCM:
        case PERCENTAGE:
        case DIMENSION:
        case URI:
        case FUNCTION:
          ;
          break;
        default:
          jj_la1[101] = jj_gen;
          break label_63;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SLASH:
        case COMMA:
          body = operator(body);
          break;
        default:
          jj_la1[102] = jj_gen;
          ;
        }
        body = term(body);
      }
          {if (true) return head;}
    } catch (ParseException ex) {
        {if (true) throw toCSSParseException("invalidExpr", ex);}
    }
    throw new Error("Missing return statement in function");
  }

//
// term
//  : unary_operator?
//    [ NUMBER | PERCENTAGE | LENGTH | EMS | EXS | ANGLE | TIME | FREQ | function ]
//  | STRING | IDENT | URI | hexcolor | DIMENSION
//  S*
//  ;
//
  final public LexicalUnit term(LexicalUnit prev) throws ParseException {
  Token t;
  char op = ' ';
  LexicalUnit value = null;
  Locator locator = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
    case PLUS:
      op = unaryOperator();
      break;
    default:
      jj_la1[103] = jj_gen;
      ;
    }
        if (op != ' ')
        {
            locator = getLocator();
        }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER:
    case EMS:
    case EXS:
    case LENGTH_PX:
    case LENGTH_CM:
    case LENGTH_MM:
    case LENGTH_IN:
    case LENGTH_PT:
    case LENGTH_PC:
    case ANGLE_DEG:
    case ANGLE_RAD:
    case ANGLE_GRAD:
    case TIME_MS:
    case TIME_S:
    case FREQ_HZ:
    case FREQ_KHZ:
    case RESOLUTION_DPI:
    case RESOLUTION_DPCM:
    case PERCENTAGE:
    case FUNCTION:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
        t = jj_consume_token(NUMBER);
                try
                {
                    value = LexicalUnitImpl.createNumber(prev, intValue(op, t.image));
                }
                catch (NumberFormatException e)
                {
                    value = LexicalUnitImpl.createNumber(prev, floatValue(op, t.image));
                }
        break;
      case PERCENTAGE:
        t = jj_consume_token(PERCENTAGE);
                                        value = LexicalUnitImpl.createPercentage(prev, floatValue(op, t.image));
        break;
      case LENGTH_PX:
        t = jj_consume_token(LENGTH_PX);
                                        value = LexicalUnitImpl.createPixel(prev, floatValue(op, t.image));
        break;
      case LENGTH_CM:
        t = jj_consume_token(LENGTH_CM);
                                        value = LexicalUnitImpl.createCentimeter(prev, floatValue(op, t.image));
        break;
      case LENGTH_MM:
        t = jj_consume_token(LENGTH_MM);
                                        value = LexicalUnitImpl.createMillimeter(prev, floatValue(op, t.image));
        break;
      case LENGTH_IN:
        t = jj_consume_token(LENGTH_IN);
                                        value = LexicalUnitImpl.createInch(prev, floatValue(op, t.image));
        break;
      case LENGTH_PT:
        t = jj_consume_token(LENGTH_PT);
                                        value = LexicalUnitImpl.createPoint(prev, floatValue(op, t.image));
        break;
      case LENGTH_PC:
        t = jj_consume_token(LENGTH_PC);
                                        value = LexicalUnitImpl.createPica(prev, floatValue(op, t.image));
        break;
      case EMS:
        t = jj_consume_token(EMS);
                                        value = LexicalUnitImpl.createEm(prev, floatValue(op, t.image));
        break;
      case EXS:
        t = jj_consume_token(EXS);
                                        value = LexicalUnitImpl.createEx(prev, floatValue(op, t.image));
        break;
      case ANGLE_DEG:
        t = jj_consume_token(ANGLE_DEG);
                                        value = LexicalUnitImpl.createDegree(prev, floatValue(op, t.image));
        break;
      case ANGLE_RAD:
        t = jj_consume_token(ANGLE_RAD);
                                        value = LexicalUnitImpl.createRadian(prev, floatValue(op, t.image));
        break;
      case ANGLE_GRAD:
        t = jj_consume_token(ANGLE_GRAD);
                                        value = LexicalUnitImpl.createGradian(prev, floatValue(op, t.image));
        break;
      case TIME_MS:
        t = jj_consume_token(TIME_MS);
                                        value = LexicalUnitImpl.createMillisecond(prev, floatValue(op, t.image));
        break;
      case TIME_S:
        t = jj_consume_token(TIME_S);
                                        value = LexicalUnitImpl.createSecond(prev, floatValue(op, t.image));
        break;
      case FREQ_HZ:
        t = jj_consume_token(FREQ_HZ);
                                        value = LexicalUnitImpl.createHertz(prev, floatValue(op, t.image));
        break;
      case FREQ_KHZ:
        t = jj_consume_token(FREQ_KHZ);
                                        value = LexicalUnitImpl.createKiloHertz(prev, floatValue(op, t.image));
        break;
      case RESOLUTION_DPI:
        t = jj_consume_token(RESOLUTION_DPI);
                                        value = LexicalUnitImpl.createDimension(prev, floatValue(op, t.image), "dpi");
        break;
      case RESOLUTION_DPCM:
        t = jj_consume_token(RESOLUTION_DPCM);
                                        value = LexicalUnitImpl.createDimension(prev, floatValue(op, t.image), "dpcm");
        break;
      case FUNCTION:
        value = function(prev);
        break;
      default:
        jj_la1[104] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case STRING:
      t = jj_consume_token(STRING);
                                  value = LexicalUnitImpl.createString(prev, unescape(t.image, false));
      break;
    case IDENT:
      t = jj_consume_token(IDENT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        jj_consume_token(COLON);
                            {if (true) throw toCSSParseException("invalidExprColon", new String[]{ unescape(t.image, false) }, getLocator());}
        break;
      default:
        jj_la1[105] = jj_gen;
        ;
      }
              value = LexicalUnitImpl.createIdent(prev, unescape(t.image, false));
      break;
    case URI:
      t = jj_consume_token(URI);
                                  value = LexicalUnitImpl.createURI(prev, unescape(t.image, true));
      break;
    case HASH:
      value = hexcolor(prev);
      break;
    case DIMENSION:
      t = jj_consume_token(DIMENSION);
                int n = getLastNumPos(t.image);
                value = LexicalUnitImpl.createDimension(
                    prev,
                    floatValue(op, t.image.substring(0, n+1)),
                    t.image.substring(n+1));
      break;
    case INHERIT:
      t = jj_consume_token(INHERIT);
                                  value = new LexicalUnitImpl(prev, LexicalUnit.SAC_INHERIT, t.image);
      break;
    default:
      jj_la1[106] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            if (locator == null)
            {
                locator = getLocator();
            }
    label_64:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[107] = jj_gen;
        break label_64;
      }
      jj_consume_token(S);
    }
            if (value instanceof Locatable)
            {
                ((Locatable) value).setLocator(locator);
            }
            {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

//
// function
//   : FUNCTION S* ((EQUALS | COMMA | (unaryOperator? NUMBER) | STRING | IDENT | URI)? S*)+ ')' S*
//   ;
//
  final public LexicalUnit function(LexicalUnit prev) throws ParseException {
    Token t;
    LexicalUnit param = null;
    LexicalUnit body = null;
    String funct = "";
    t = jj_consume_token(FUNCTION);
                     funct = funct + unescape(t.image, false);
    label_65:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[108] = jj_gen;
        break label_65;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER:
    case INHERIT:
    case IDENT:
    case STRING:
    case MINUS:
    case PLUS:
    case HASH:
    case EMS:
    case EXS:
    case LENGTH_PX:
    case LENGTH_CM:
    case LENGTH_MM:
    case LENGTH_IN:
    case LENGTH_PT:
    case LENGTH_PC:
    case ANGLE_DEG:
    case ANGLE_RAD:
    case ANGLE_GRAD:
    case TIME_MS:
    case TIME_S:
    case FREQ_HZ:
    case FREQ_KHZ:
    case RESOLUTION_DPI:
    case RESOLUTION_DPCM:
    case PERCENTAGE:
    case DIMENSION:
    case URI:
    case FUNCTION:
      param = term(null);
                             body = param;
      label_66:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMBER:
        case INHERIT:
        case IDENT:
        case STRING:
        case MINUS:
        case EQUALS:
        case PLUS:
        case COMMA:
        case HASH:
        case EMS:
        case EXS:
        case LENGTH_PX:
        case LENGTH_CM:
        case LENGTH_MM:
        case LENGTH_IN:
        case LENGTH_PT:
        case LENGTH_PC:
        case ANGLE_DEG:
        case ANGLE_RAD:
        case ANGLE_GRAD:
        case TIME_MS:
        case TIME_S:
        case FREQ_HZ:
        case FREQ_KHZ:
        case RESOLUTION_DPI:
        case RESOLUTION_DPCM:
        case PERCENTAGE:
        case DIMENSION:
        case URI:
        case FUNCTION:
          ;
          break;
        default:
          jj_la1[109] = jj_gen;
          break label_66;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQUALS:
        case COMMA:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            t = jj_consume_token(COMMA);
                                   body = LexicalUnitImpl.createComma(body);
            break;
          case EQUALS:
            t = jj_consume_token(EQUALS);
                                     body = LexicalUnitImpl.createIdent(body, t.image);
            break;
          default:
            jj_la1[110] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          label_67:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case S:
              ;
              break;
            default:
              jj_la1[111] = jj_gen;
              break label_67;
            }
            jj_consume_token(S);
          }
          break;
        default:
          jj_la1[112] = jj_gen;
          ;
        }
        body = term(body);
      }
      break;
    default:
      jj_la1[113] = jj_gen;
      ;
    }
    jj_consume_token(RROUND);
        {if (true) return functionInternal(prev, funct, param);}
    throw new Error("Missing return statement in function");
  }

//
// negation_arg
//   : type_selector | universal | HASH | class | attrib | pseudo
//   ;
//
  final public Selector negation_arg() throws ParseException {
    Selector negationArg = null;
    Condition c = null;
    SimpleSelector simpleSel = null;
    SimpleSelector pseudoElementSel = null;
    Object o;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
    case ASTERISK:
      simpleSel = elementName();
      break;
    case HASH:
      c = hash(null, false);
      break;
    case DOT:
      c = _class(null, false);
      break;
    case LSQUARE:
      c = attrib(null, false);
      break;
    case COLON:
      o = pseudo(null, false);
               if (o instanceof Condition)
               {   c = (Condition) o;
               } else {
                   pseudoElementSel = (SimpleSelector) o;
                   negationArg = getSelectorFactory().createDescendantSelector(null, pseudoElementSel);
               }
      break;
    default:
      jj_la1[114] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            if (negationArg != null) {
                {if (true) return negationArg;}
            }

            if (simpleSel != null) {
                {if (true) return simpleSel;}
            }

            simpleSel = getSelectorFactory().createElementSelector(null, null);
            simpleSel = getSelectorFactory().createConditionalSelector(simpleSel, c);
            {if (true) return simpleSel;}
    throw new Error("Missing return statement in function");
  }

//
// hexcolor
//   : HASH S*
//   ;
//
  final public LexicalUnit hexcolor(LexicalUnit prev) throws ParseException {
    Token t;
    t = jj_consume_token(HASH);
        {if (true) return hexcolorInternal(prev, t);}
    throw new Error("Missing return statement in function");
  }

  String skip() throws ParseException {
  StringBuilder sb = new StringBuilder();
  int nesting = 0;
  Token t = getToken(0);
  if (t.image != null) {
    sb.append(t.image);
  }
  do {
    t = getNextToken();
    if (t.kind == EOF)
      break;
    sb.append(t.image);
    if (t.kind == LBRACE)
      nesting++;
    else if (t.kind == RBRACE)
      nesting--;
    else if (t.kind == SEMICOLON && nesting <= 0)
      break;
  }
  while ((t.kind != RBRACE) || (nesting > 0));

  return sb.toString();
  }

  void error_skipblock() throws ParseException {
    Token t;
    int nesting = 0;
    do
    {
        t = getNextToken();
        if (t.kind == LBRACE)
        {
            nesting++;
        }
        else if (t.kind == RBRACE)
        {
            nesting--;
        }
        else if (t.kind == EOF)
        {
            break;
        }
    }
    while ((t.kind != RBRACE) || (nesting > 0));
  }

  void error_skipdecl() throws ParseException {
    Token t = getToken(1);
    if (t.kind == LBRACE)
    {
        error_skipblock();
    }
    else if (t.kind == RBRACE)
    {
        // next will be RBRACE so we are finished
        return;
    }
    else
    {
        Token oldToken = token;
        while (t.kind != SEMICOLON && t.kind != RBRACE && t.kind != EOF )
        {
            oldToken = t;
            t = getNextToken();
        }
        if (t.kind != EOF)
        {
            token = oldToken;
        }
    }
  }

  void error_skipAtRule() throws ParseException {
    Token t = null;
    do
    {
        t = getNextToken();
    }
    while (t.kind != SEMICOLON && t.kind != EOF);
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_3R_89() {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_scan_token(TILDE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_scan_token(GREATER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_3R_91()) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_scan_token(PLUS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_3R_89()) return true;
    return false;
  }

  private boolean jj_3R_68() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_scan_token(HASH)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_68()) return true;
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_77() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) return true;
    }
    return false;
  }

  private boolean jj_3R_75() {
    Token xsp;
    if (jj_3R_78()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_78()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_scan_token(LSQUARE)) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_scan_token(GREATER)) return true;
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_69() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) return true;
    }
    return false;
  }

  private boolean jj_3R_76() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_scan_token(ASTERISK)) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_scan_token(TILDE)) return true;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(S)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_76()) jj_scanpos = xsp;
    return false;
  }

  /** Generated Token Manager. */
  public SACParserCSS3TokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[115];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x2,0x2,0x2,0x2,0x0,0x400000,0x400000,0x400000,0x2,0x2,0x2,0x400000,0x2,0x2,0x2000000,0x2,0x4c0000,0x2,0x2,0x400000,0x0,0x2,0xc0000,0x2,0xc0000,0x20000,0x2,0x20000,0x2,0x4c0000,0x2,0x2,0x0,0x2,0x400000,0x2,0x400000,0x2,0x2,0x2,0x0,0x2,0x400000,0x0,0x2,0x400000,0x2,0x2,0x400000,0x0,0x2,0x400000,0x2,0x2,0x0,0x2,0x2,0x2,0x0,0x2,0x0,0x2,0x0,0x2,0x2,0x1,0x2,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0x400000,0x400000,0x2,0x2,0x0,0x2,0x2400000,0x2,0x0,0x0,0x2,0x2,0x2,0x2,0x2,0x2500000,0x2,0x2500000,0x400000,0x400000,0x0,0x2,0x400000,0x0,0x2,0x0,0x2,0x2700000,0x0,0x0,0x100000,0x0,0x2700000,0x2,0x2,0x2700000,0x0,0x2,0x0,0x2700000,0x400000,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x30000,0x30000,0x30000,0x30000,0x0,0x68000000,0x68000000,0x68000000,0x30000,0x30000,0x0,0x68000000,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x68000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x20000000,0x0,0x68000000,0x0,0x68000000,0x0,0x0,0x0,0x20000000,0x0,0x40000000,0x10000000,0x0,0x40000000,0x0,0x0,0x40000000,0x10000000,0x0,0x40000000,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x28000000,0x28000000,0x28000000,0x28000000,0x68000000,0x40000000,0x0,0x0,0x7c0000,0x0,0x0,0x0,0x7c0000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x10000000,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x68000000,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x2000,0x1f04,0x1d04,0x1f04,0x0,0x0,0x0,0x3f04,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x704,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x704,0x0,0x704,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x70,0x0,0x70,0x70,0x11,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x104,0x104,0x104,0x104,0x104,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x11,0x0,0x11,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0xffff8191,0x80,0x11,0xffff8000,0x0,0xffff8100,0x0,0x0,0xffff8193,0x82,0x0,0x82,0xffff8111,0x104,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x40,0x0,0x0,0x0,0x40,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x2,0x38,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x27,0x0,0x0,0x21,0x0,0x27,0x0,0x0,0x27,0x0,0x0,0x0,0x27,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[1];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with user supplied CharStream. */
  public SACParserCSS3(CharStream stream) {
    token_source = new SACParserCSS3TokenManager(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 115; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 115; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public SACParserCSS3(SACParserCSS3TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 115; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(SACParserCSS3TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 115; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[104];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 115; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 104; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 1; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
